/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.beans;

import ai.org.jfree.beans.AbstractCategoryChart;
import ai.org.jfree.chart.ChartFactory;
import ai.org.jfree.chart.JFreeChart;
import ai.org.jfree.chart.axis.CategoryAxis;
import ai.org.jfree.chart.plot.CategoryPlot;
import ai.org.jfree.chart.plot.PlotOrientation;
import ai.org.jfree.chart.renderer.category.BarRenderer;
import ai.org.jfree.data.category.CategoryDataset;
import ai.org.jfree.data.category.DefaultCategoryDataset;
import ai.org.jfree.ui.RectangleInsets;
import java.awt.Color;

public class JBarChart
extends AbstractCategoryChart {
    protected JFreeChart createDefaultChart() {
        DefaultCategoryDataset defaultCategoryDataset = new DefaultCategoryDataset();
        defaultCategoryDataset.setValue(5.0, (Comparable)((Object)"Series 1"), (Comparable)((Object)"Category A"));
        defaultCategoryDataset.setValue(6.0, (Comparable)((Object)"Series 1"), (Comparable)((Object)"Category B"));
        defaultCategoryDataset.setValue(7.0, (Comparable)((Object)"Series 2"), (Comparable)((Object)"Category A"));
        defaultCategoryDataset.setValue(4.0, (Comparable)((Object)"Series 2"), (Comparable)((Object)"Category B"));
        defaultCategoryDataset.setValue(3.0, (Comparable)((Object)"Series 3"), (Comparable)((Object)"Category A"));
        defaultCategoryDataset.setValue(9.0, (Comparable)((Object)"Series 3"), (Comparable)((Object)"Category B"));
        JFreeChart jFreeChart = ChartFactory.createBarChart("JBarChart - Title", "Category", "Value", defaultCategoryDataset, PlotOrientation.VERTICAL, true, true, false);
        CategoryPlot categoryPlot = (CategoryPlot)jFreeChart.getPlot();
        categoryPlot.setBackgroundPaint(Color.lightGray);
        categoryPlot.setDomainGridlinePaint(Color.white);
        categoryPlot.setRangeGridlinePaint(Color.white);
        categoryPlot.setAxisOffset(new RectangleInsets(4.0, 4.0, 4.0, 4.0));
        CategoryAxis categoryAxis = categoryPlot.getDomainAxis();
        categoryAxis.setCategoryMargin(0.05);
        BarRenderer barRenderer = (BarRenderer)categoryPlot.getRenderer();
        barRenderer.setItemMargin(0.0);
        barRenderer.setDrawBarOutline(false);
        return jFreeChart;
    }

    public CategoryDataset getDataset() {
        CategoryDataset categoryDataset = null;
        CategoryPlot categoryPlot = (CategoryPlot)this.chart.getPlot();
        if (categoryPlot != null) {
            categoryDataset = categoryPlot.getDataset();
        }
        return categoryDataset;
    }

    public void setDataset(CategoryDataset categoryDataset) {
        CategoryPlot categoryPlot = (CategoryPlot)this.chart.getPlot();
        if (categoryPlot != null) {
            CategoryDataset categoryDataset2 = categoryPlot.getDataset();
            categoryPlot.setDataset(categoryDataset);
            this.firePropertyChange("dataset", categoryDataset2, categoryDataset);
        }
    }

    public boolean isBarOutlineVisible() {
        CategoryPlot categoryPlot = (CategoryPlot)this.chart.getPlot();
        if (categoryPlot == null) {
            return false;
        }
        BarRenderer barRenderer = (BarRenderer)categoryPlot.getRenderer();
        if (barRenderer == null) {
            return false;
        }
        return barRenderer.isDrawBarOutline();
    }

    public void setBarOutlineVisible(boolean bl) {
        CategoryPlot categoryPlot = (CategoryPlot)this.chart.getPlot();
        if (categoryPlot == null) {
            return;
        }
        BarRenderer barRenderer = (BarRenderer)categoryPlot.getRenderer();
        if (barRenderer == null) {
            return;
        }
        boolean bl2 = barRenderer.isDrawBarOutline();
        barRenderer.setDrawBarOutline(bl);
        this.firePropertyChange("barOutlineVisible", bl2, bl);
    }

    public double getBarItemMargin() {
        CategoryPlot categoryPlot = (CategoryPlot)this.chart.getPlot();
        if (categoryPlot == null) {
            return 0.0;
        }
        BarRenderer barRenderer = (BarRenderer)categoryPlot.getRenderer();
        if (barRenderer == null) {
            return 0.0;
        }
        return barRenderer.getItemMargin();
    }

    public void setBarItemMargin(double d) {
        CategoryPlot categoryPlot = (CategoryPlot)this.chart.getPlot();
        if (categoryPlot == null) {
            return;
        }
        BarRenderer barRenderer = (BarRenderer)categoryPlot.getRenderer();
        if (barRenderer == null) {
            return;
        }
        double d2 = barRenderer.getItemMargin();
        barRenderer.setItemMargin(d);
        this.firePropertyChange("barItemMargin", d2, d);
    }

    public double getBarBaseValue() {
        CategoryPlot categoryPlot = (CategoryPlot)this.chart.getPlot();
        if (categoryPlot == null) {
            return 0.0;
        }
        BarRenderer barRenderer = (BarRenderer)categoryPlot.getRenderer();
        if (barRenderer == null) {
            return 0.0;
        }
        return barRenderer.getBase();
    }

    public void setBarBaseValue(double d) {
        CategoryPlot categoryPlot = (CategoryPlot)this.chart.getPlot();
        if (categoryPlot == null) {
            return;
        }
        BarRenderer barRenderer = (BarRenderer)categoryPlot.getRenderer();
        if (barRenderer == null) {
            return;
        }
        double d2 = barRenderer.getBase();
        barRenderer.setBase(d);
        this.firePropertyChange("barBaseValue", d2, d);
    }
}

