/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.base.config;

import ai.org.jfree.base.config.HierarchicalConfiguration;
import ai.org.jfree.util.Log;
import ai.org.jfree.util.ObjectUtilities;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;

public class PropertyFileConfiguration
extends HierarchicalConfiguration {
    public void load(String string) {
        this.load(string, PropertyFileConfiguration.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(String string, Class clazz) {
        InputStream inputStream = ObjectUtilities.getResourceRelativeAsStream(string, clazz);
        if (inputStream != null) {
            try {
                this.load(inputStream);
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        Log.debug("Configuration file not found in the classpath: " + string);
    }

    public void load(InputStream inputStream) {
        if (inputStream == null) {
            throw new NullPointerException();
        }
        try {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
            Properties properties = new Properties();
            properties.load(bufferedInputStream);
            this.getConfiguration().putAll((Map<?, ?>)properties);
            bufferedInputStream.close();
        }
        catch (IOException iOException) {
            Log.warn("Unable to read configuration", iOException);
        }
    }
}

