/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.util;

import ai.org.apache.poi.util.LittleEndianInput;
import ai.org.apache.poi.util.LittleEndianOutput;
import java.io.UnsupportedEncodingException;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.util.Iterator;

public class StringUtil {
    private static final String ENCODING_ISO_8859_1 = "ISO-8859-1";

    private StringUtil() {
    }

    public static String getFromUnicodeLE(byte[] byArray, int n, int n2) throws ArrayIndexOutOfBoundsException, IllegalArgumentException {
        if (n < 0 || n >= byArray.length) {
            throw new ArrayIndexOutOfBoundsException("Illegal offset " + n + " (String data is of length " + byArray.length + ")");
        }
        if (n2 < 0 || (byArray.length - n) / 2 < n2) {
            throw new IllegalArgumentException("Illegal length " + n2);
        }
        try {
            return new String(byArray, n, n2 * 2, "UTF-16LE");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
    }

    public static String getFromUnicodeLE(byte[] byArray) {
        if (byArray.length == 0) {
            return "";
        }
        return StringUtil.getFromUnicodeLE(byArray, 0, byArray.length / 2);
    }

    public static String getFromCompressedUnicode(byte[] byArray, int n, int n2) {
        try {
            int n3 = Math.min(n2, byArray.length - n);
            return new String(byArray, n, n3, ENCODING_ISO_8859_1);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
    }

    public static String readCompressedUnicode(LittleEndianInput littleEndianInput, int n) {
        char[] cArray = new char[n];
        for (int i = 0; i < cArray.length; ++i) {
            cArray[i] = (char)littleEndianInput.readUByte();
        }
        return new String(cArray);
    }

    public static String readUnicodeString(LittleEndianInput littleEndianInput) {
        int n = littleEndianInput.readUShort();
        byte by = littleEndianInput.readByte();
        if ((by & 1) == 0) {
            return StringUtil.readCompressedUnicode(littleEndianInput, n);
        }
        return StringUtil.readUnicodeLE(littleEndianInput, n);
    }

    public static String readUnicodeString(LittleEndianInput littleEndianInput, int n) {
        byte by = littleEndianInput.readByte();
        if ((by & 1) == 0) {
            return StringUtil.readCompressedUnicode(littleEndianInput, n);
        }
        return StringUtil.readUnicodeLE(littleEndianInput, n);
    }

    public static void writeUnicodeString(LittleEndianOutput littleEndianOutput, String string) {
        int n = string.length();
        littleEndianOutput.writeShort(n);
        boolean bl = StringUtil.hasMultibyte(string);
        littleEndianOutput.writeByte(bl ? 1 : 0);
        if (bl) {
            StringUtil.putUnicodeLE(string, littleEndianOutput);
        } else {
            StringUtil.putCompressedUnicode(string, littleEndianOutput);
        }
    }

    public static void writeUnicodeStringFlagAndData(LittleEndianOutput littleEndianOutput, String string) {
        boolean bl = StringUtil.hasMultibyte(string);
        littleEndianOutput.writeByte(bl ? 1 : 0);
        if (bl) {
            StringUtil.putUnicodeLE(string, littleEndianOutput);
        } else {
            StringUtil.putCompressedUnicode(string, littleEndianOutput);
        }
    }

    public static int getEncodedSize(String string) {
        int n = 3;
        return n += string.length() * (StringUtil.hasMultibyte(string) ? 2 : 1);
    }

    public static void putCompressedUnicode(String string, byte[] byArray, int n) {
        byte[] byArray2;
        try {
            byArray2 = string.getBytes(ENCODING_ISO_8859_1);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
        System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
    }

    public static void putCompressedUnicode(String string, LittleEndianOutput littleEndianOutput) {
        byte[] byArray;
        try {
            byArray = string.getBytes(ENCODING_ISO_8859_1);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
        littleEndianOutput.write(byArray);
    }

    public static void putUnicodeLE(String string, byte[] byArray, int n) {
        byte[] byArray2;
        try {
            byArray2 = string.getBytes("UTF-16LE");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
        System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
    }

    public static void putUnicodeLE(String string, LittleEndianOutput littleEndianOutput) {
        byte[] byArray;
        try {
            byArray = string.getBytes("UTF-16LE");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
        littleEndianOutput.write(byArray);
    }

    public static String readUnicodeLE(LittleEndianInput littleEndianInput, int n) {
        char[] cArray = new char[n];
        for (int i = 0; i < cArray.length; ++i) {
            cArray[i] = (char)littleEndianInput.readUShort();
        }
        return new String(cArray);
    }

    public static String format(String string, Object[] objectArray) {
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '%') {
                if (n >= objectArray.length) {
                    stringBuffer.append("?missing data?");
                    continue;
                }
                if (objectArray[n] instanceof Number && i + 1 < string.length()) {
                    i += StringUtil.matchOptionalFormatting((Number)objectArray[n++], string.substring(i + 1), stringBuffer);
                    continue;
                }
                stringBuffer.append(objectArray[n++].toString());
                continue;
            }
            if (string.charAt(i) == '\\' && i + 1 < string.length() && string.charAt(i + 1) == '%') {
                stringBuffer.append('%');
                ++i;
                continue;
            }
            stringBuffer.append(string.charAt(i));
        }
        return stringBuffer.toString();
    }

    private static int matchOptionalFormatting(Number number, String string, StringBuffer stringBuffer) {
        NumberFormat numberFormat = NumberFormat.getInstance();
        if (0 < string.length() && Character.isDigit(string.charAt(0))) {
            numberFormat.setMinimumIntegerDigits(Integer.parseInt(string.charAt(0) + ""));
            if (2 < string.length() && string.charAt(1) == '.' && Character.isDigit(string.charAt(2))) {
                numberFormat.setMaximumFractionDigits(Integer.parseInt(string.charAt(2) + ""));
                numberFormat.format(number, stringBuffer, new FieldPosition(0));
                return 3;
            }
            numberFormat.format(number, stringBuffer, new FieldPosition(0));
            return 1;
        }
        if (0 < string.length() && string.charAt(0) == '.' && 1 < string.length() && Character.isDigit(string.charAt(1))) {
            numberFormat.setMaximumFractionDigits(Integer.parseInt(string.charAt(1) + ""));
            numberFormat.format(number, stringBuffer, new FieldPosition(0));
            return 2;
        }
        numberFormat.format(number, stringBuffer, new FieldPosition(0));
        return 1;
    }

    public static String getPreferredEncoding() {
        return ENCODING_ISO_8859_1;
    }

    public static boolean hasMultibyte(String string) {
        if (string == null) {
            return false;
        }
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c <= '\u00ff') continue;
            return true;
        }
        return false;
    }

    public static boolean isUnicodeString(String string) {
        try {
            return !string.equals(new String(string.getBytes(ENCODING_ISO_8859_1), ENCODING_ISO_8859_1));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class StringsIterator
    implements Iterator<String> {
        private String[] strings;
        private int position = 0;

        public StringsIterator(String[] stringArray) {
            this.strings = stringArray != null ? stringArray : new String[0];
        }

        @Override
        public boolean hasNext() {
            return this.position < this.strings.length;
        }

        @Override
        public String next() {
            int n;
            if ((n = this.position++) >= this.strings.length) {
                throw new ArrayIndexOutOfBoundsException(n);
            }
            return this.strings[n];
        }

        @Override
        public void remove() {
        }
    }
}

