/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.util;

import ai.org.apache.poi.util.LittleEndianConsts;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class LittleEndian
implements LittleEndianConsts {
    public static byte[] getByteArray(byte[] byArray, int n, int n2) {
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        return byArray2;
    }

    public static double getDouble(byte[] byArray) {
        return Double.longBitsToDouble(LittleEndian.getLong(byArray, 0));
    }

    public static double getDouble(byte[] byArray, int n) {
        return Double.longBitsToDouble(LittleEndian.getLong(byArray, n));
    }

    public static float getFloat(byte[] byArray) {
        return LittleEndian.getFloat(byArray, 0);
    }

    public static float getFloat(byte[] byArray, int n) {
        return Float.intBitsToFloat(LittleEndian.getInt(byArray, n));
    }

    public static int getInt(byte[] byArray) {
        return LittleEndian.getInt(byArray, 0);
    }

    public static int getInt(byte[] byArray, int n) {
        int n2 = n;
        int n3 = byArray[n2++] & 0xFF;
        int n4 = byArray[n2++] & 0xFF;
        int n5 = byArray[n2++] & 0xFF;
        int n6 = byArray[n2++] & 0xFF;
        return (n6 << 24) + (n5 << 16) + (n4 << 8) + (n3 << 0);
    }

    public static long getLong(byte[] byArray) {
        return LittleEndian.getLong(byArray, 0);
    }

    public static long getLong(byte[] byArray, int n) {
        long l = 0xFF & byArray[n + 7];
        for (int i = n + 8 - 1; i >= n; --i) {
            l <<= 8;
            l |= (long)(0xFF & byArray[i]);
        }
        return l;
    }

    public static short getShort(byte[] byArray) {
        return LittleEndian.getShort(byArray, 0);
    }

    public static short getShort(byte[] byArray, int n) {
        int n2 = byArray[n] & 0xFF;
        int n3 = byArray[n + 1] & 0xFF;
        return (short)((n3 << 8) + (n2 << 0));
    }

    public static short[] getShortArray(byte[] byArray, int n, int n2) {
        short[] sArray = new short[n2 / 2];
        for (int i = 0; i < sArray.length; ++i) {
            sArray[i] = LittleEndian.getShort(byArray, n + i * 2);
        }
        return sArray;
    }

    public static short getUByte(byte[] byArray) {
        return (short)(byArray[0] & 0xFF);
    }

    public static short getUByte(byte[] byArray, int n) {
        return (short)(byArray[n] & 0xFF);
    }

    public static long getUInt(byte[] byArray) {
        return LittleEndian.getUInt(byArray, 0);
    }

    public static long getUInt(byte[] byArray, int n) {
        long l = LittleEndian.getInt(byArray, n);
        return l & 0xFFFFFFFFL;
    }

    @Deprecated
    public static int getUnsignedByte(byte[] byArray, int n) {
        return byArray[n] & 0xFF;
    }

    public static int getUShort(byte[] byArray) {
        return LittleEndian.getUShort(byArray, 0);
    }

    public static int getUShort(byte[] byArray, int n) {
        int n2 = byArray[n] & 0xFF;
        int n3 = byArray[n + 1] & 0xFF;
        return (n3 << 8) + (n2 << 0);
    }

    public static void putByte(byte[] byArray, int n, int n2) {
        byArray[n] = (byte)n2;
    }

    public static void putDouble(byte[] byArray, int n, double d) {
        LittleEndian.putLong(byArray, n, Double.doubleToLongBits(d));
    }

    public static void putDouble(double d, OutputStream outputStream) throws IOException {
        LittleEndian.putLong(Double.doubleToLongBits(d), outputStream);
    }

    public static void putFloat(byte[] byArray, int n, float f) {
        LittleEndian.putInt(byArray, n, Float.floatToIntBits(f));
    }

    public static void putFloat(float f, OutputStream outputStream) throws IOException {
        LittleEndian.putInt(Float.floatToIntBits(f), outputStream);
    }

    @Deprecated
    public static void putInt(byte[] byArray, int n) {
        LittleEndian.putInt(byArray, 0, n);
    }

    public static void putInt(byte[] byArray, int n, int n2) {
        int n3 = n;
        byArray[n3++] = (byte)(n2 >>> 0 & 0xFF);
        byArray[n3++] = (byte)(n2 >>> 8 & 0xFF);
        byArray[n3++] = (byte)(n2 >>> 16 & 0xFF);
        byArray[n3++] = (byte)(n2 >>> 24 & 0xFF);
    }

    public static void putInt(int n, OutputStream outputStream) throws IOException {
        outputStream.write((byte)(n >>> 0 & 0xFF));
        outputStream.write((byte)(n >>> 8 & 0xFF));
        outputStream.write((byte)(n >>> 16 & 0xFF));
        outputStream.write((byte)(n >>> 24 & 0xFF));
    }

    public static void putLong(byte[] byArray, int n, long l) {
        byArray[n + 0] = (byte)(l >>> 0 & 0xFFL);
        byArray[n + 1] = (byte)(l >>> 8 & 0xFFL);
        byArray[n + 2] = (byte)(l >>> 16 & 0xFFL);
        byArray[n + 3] = (byte)(l >>> 24 & 0xFFL);
        byArray[n + 4] = (byte)(l >>> 32 & 0xFFL);
        byArray[n + 5] = (byte)(l >>> 40 & 0xFFL);
        byArray[n + 6] = (byte)(l >>> 48 & 0xFFL);
        byArray[n + 7] = (byte)(l >>> 56 & 0xFFL);
    }

    public static void putLong(long l, OutputStream outputStream) throws IOException {
        outputStream.write((byte)(l >>> 0 & 0xFFL));
        outputStream.write((byte)(l >>> 8 & 0xFFL));
        outputStream.write((byte)(l >>> 16 & 0xFFL));
        outputStream.write((byte)(l >>> 24 & 0xFFL));
        outputStream.write((byte)(l >>> 32 & 0xFFL));
        outputStream.write((byte)(l >>> 40 & 0xFFL));
        outputStream.write((byte)(l >>> 48 & 0xFFL));
        outputStream.write((byte)(l >>> 56 & 0xFFL));
    }

    public static void putShort(byte[] byArray, int n, short s) {
        int n2 = n;
        byArray[n2++] = (byte)(s >>> 0 & 0xFF);
        byArray[n2++] = (byte)(s >>> 8 & 0xFF);
    }

    @Deprecated
    public static void putShort(byte[] byArray, short s) {
        LittleEndian.putShort(byArray, 0, s);
    }

    public static void putShort(OutputStream outputStream, short s) throws IOException {
        outputStream.write((byte)(s >>> 0 & 0xFF));
        outputStream.write((byte)(s >>> 8 & 0xFF));
    }

    public static void putShortArray(byte[] byArray, int n, short[] sArray) {
        int n2 = n;
        for (short s : sArray) {
            LittleEndian.putShort(byArray, n2, s);
            n2 += 2;
        }
    }

    public static void putUByte(byte[] byArray, int n, short s) {
        byArray[n] = (byte)(s & 0xFF);
    }

    public static void putUInt(byte[] byArray, int n, long l) {
        int n2 = n;
        byArray[n2++] = (byte)(l >>> 0 & 0xFFL);
        byArray[n2++] = (byte)(l >>> 8 & 0xFFL);
        byArray[n2++] = (byte)(l >>> 16 & 0xFFL);
        byArray[n2++] = (byte)(l >>> 24 & 0xFFL);
    }

    @Deprecated
    public static void putUInt(byte[] byArray, long l) {
        LittleEndian.putUInt(byArray, 0, l);
    }

    public static void putUInt(long l, OutputStream outputStream) throws IOException {
        outputStream.write((byte)(l >>> 0 & 0xFFL));
        outputStream.write((byte)(l >>> 8 & 0xFFL));
        outputStream.write((byte)(l >>> 16 & 0xFFL));
        outputStream.write((byte)(l >>> 24 & 0xFFL));
    }

    public static void putUShort(byte[] byArray, int n, int n2) {
        int n3 = n;
        byArray[n3++] = (byte)(n2 >>> 0 & 0xFF);
        byArray[n3++] = (byte)(n2 >>> 8 & 0xFF);
    }

    public static void putUShort(int n, OutputStream outputStream) throws IOException {
        outputStream.write((byte)(n >>> 0 & 0xFF));
        outputStream.write((byte)(n >>> 8 & 0xFF));
    }

    public static int readInt(InputStream inputStream) throws IOException, BufferUnderrunException {
        int n;
        int n2;
        int n3;
        int n4 = inputStream.read();
        if ((n4 | (n3 = inputStream.read()) | (n2 = inputStream.read()) | (n = inputStream.read())) < 0) {
            throw new BufferUnderrunException();
        }
        return (n << 24) + (n2 << 16) + (n3 << 8) + (n4 << 0);
    }

    public static long readUInt(InputStream inputStream) throws IOException, BufferUnderrunException {
        long l = LittleEndian.readInt(inputStream);
        return l & 0xFFFFFFFFL;
    }

    public static long readLong(InputStream inputStream) throws IOException, BufferUnderrunException {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8 = inputStream.read();
        if ((n8 | (n7 = inputStream.read()) | (n6 = inputStream.read()) | (n5 = inputStream.read()) | (n4 = inputStream.read()) | (n3 = inputStream.read()) | (n2 = inputStream.read()) | (n = inputStream.read())) < 0) {
            throw new BufferUnderrunException();
        }
        return ((long)n << 56) + ((long)n2 << 48) + ((long)n3 << 40) + ((long)n4 << 32) + ((long)n5 << 24) + (long)(n6 << 16) + (long)(n7 << 8) + (long)(n8 << 0);
    }

    public static short readShort(InputStream inputStream) throws IOException, BufferUnderrunException {
        return (short)LittleEndian.readUShort(inputStream);
    }

    public static int readUShort(InputStream inputStream) throws IOException, BufferUnderrunException {
        int n;
        int n2 = inputStream.read();
        if ((n2 | (n = inputStream.read())) < 0) {
            throw new BufferUnderrunException();
        }
        return (n << 8) + (n2 << 0);
    }

    public static int ubyteToInt(byte by) {
        return by & 0xFF;
    }

    private LittleEndian() {
    }

    public static final class BufferUnderrunException
    extends IOException {
        private static final long serialVersionUID = 8736973884877006145L;

        BufferUnderrunException() {
            super("buffer underrun");
        }
    }
}

