/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public abstract class LZWDecompresser {
    private final boolean maskMeansCompressed;
    private final int codeLengthIncrease;
    private final boolean positionIsBigEndian;

    protected LZWDecompresser(boolean bl, int n, boolean bl2) {
        this.maskMeansCompressed = bl;
        this.codeLengthIncrease = n;
        this.positionIsBigEndian = bl2;
    }

    protected abstract int populateDictionary(byte[] var1);

    protected abstract int adjustDictionaryOffset(int var1);

    public byte[] decompress(InputStream inputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.decompress(inputStream, byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public void decompress(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        byte[] byArray = new byte[4096];
        int n2 = this.populateDictionary(byArray);
        byte[] byArray2 = new byte[16 + this.codeLengthIncrease];
        block0: while ((n = inputStream.read()) != -1) {
            for (int i = 1; i < 256; i <<= 1) {
                boolean bl;
                boolean bl2 = bl = (n & i) > 0;
                if (bl ^ this.maskMeansCompressed) {
                    int n3 = inputStream.read();
                    if (n3 == -1) continue;
                    byArray[n2 & 0xFFF] = LZWDecompresser.fromInt(n3);
                    ++n2;
                    outputStream.write(new byte[]{LZWDecompresser.fromInt(n3)});
                    continue;
                }
                int n4 = inputStream.read();
                int n5 = inputStream.read();
                if (n4 == -1 || n5 == -1) continue block0;
                int n6 = (n5 & 0xF) + this.codeLengthIncrease;
                int n7 = this.positionIsBigEndian ? (n4 << 4) + (n5 >> 4) : n4 + ((n5 & 0xF0) << 4);
                n7 = this.adjustDictionaryOffset(n7);
                for (int j = 0; j < n6; ++j) {
                    byArray2[j] = byArray[n7 + j & 0xFFF];
                    byArray[n2 + j & 0xFFF] = byArray2[j];
                }
                outputStream.write(byArray2, 0, n6);
                n2 += n6;
            }
        }
    }

    public static byte fromInt(int n) {
        if (n < 128) {
            return (byte)n;
        }
        return (byte)(n - 256);
    }

    public static int fromByte(byte by) {
        if (by >= 0) {
            return by;
        }
        return by + 256;
    }
}

