/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.ss.util;

import ai.org.apache.poi.ss.util.ExpandedDouble;
import ai.org.apache.poi.ss.util.IEEEDouble;
import ai.org.apache.poi.ss.util.NormalisedDecimal;

public final class NumberComparer {
    public static int compare(double d, double d2) {
        boolean bl;
        long l = Double.doubleToLongBits(d);
        long l2 = Double.doubleToLongBits(d2);
        int n = IEEEDouble.getBiasedExponent(l);
        int n2 = IEEEDouble.getBiasedExponent(l2);
        if (n == 2047) {
            throw new IllegalArgumentException("Special double values are not allowed: " + NumberComparer.toHex(d));
        }
        if (n2 == 2047) {
            throw new IllegalArgumentException("Special double values are not allowed: " + NumberComparer.toHex(d));
        }
        boolean bl2 = l < 0L;
        boolean bl3 = bl = l2 < 0L;
        if (bl2 != bl) {
            return bl2 ? -1 : 1;
        }
        int n3 = n - n2;
        int n4 = Math.abs(n3);
        if (n4 > 1) {
            return bl2 ? -n3 : n3;
        }
        if (n4 != 1 && l == l2) {
            return 0;
        }
        if (n == 0) {
            if (n2 == 0) {
                return NumberComparer.compareSubnormalNumbers(l & 0xFFFFFFFFFFFFFL, l2 & 0xFFFFFFFFFFFFFL, bl2);
            }
            return -NumberComparer.compareAcrossSubnormalThreshold(l2, l, bl2);
        }
        if (n2 == 0) {
            return NumberComparer.compareAcrossSubnormalThreshold(l, l2, bl2);
        }
        ExpandedDouble expandedDouble = ExpandedDouble.fromRawBitsAndExponent(l, n - 1023);
        ExpandedDouble expandedDouble2 = ExpandedDouble.fromRawBitsAndExponent(l2, n2 - 1023);
        NormalisedDecimal normalisedDecimal = expandedDouble.normaliseBaseTen().roundUnits();
        NormalisedDecimal normalisedDecimal2 = expandedDouble2.normaliseBaseTen().roundUnits();
        n3 = normalisedDecimal.compareNormalised(normalisedDecimal2);
        if (bl2) {
            return -n3;
        }
        return n3;
    }

    private static int compareSubnormalNumbers(long l, long l2, boolean bl) {
        int n = l > l2 ? 1 : (l < l2 ? -1 : 0);
        return bl ? -n : n;
    }

    private static int compareAcrossSubnormalThreshold(long l, long l2, boolean bl) {
        long l3 = l2 & 0xFFFFFFFFFFFFFL;
        if (l3 == 0L) {
            return bl ? -1 : 1;
        }
        long l4 = l & 0xFFFFFFFFFFFFFL;
        if (l4 <= 7L && l3 >= 0xFFFFFFFFFFFFAL) {
            if (l4 == 7L && l3 == 0xFFFFFFFFFFFFAL) {
                return 0;
            }
            return bl ? 1 : -1;
        }
        return bl ? -1 : 1;
    }

    private static String toHex(double d) {
        return "0x" + Long.toHexString(Double.doubleToLongBits(d)).toUpperCase();
    }
}

