/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.ss.util;

import ai.org.apache.poi.ss.util.NormalisedDecimal;
import java.math.BigInteger;

final class ExpandedDouble {
    private static final BigInteger BI_FRAC_MASK = BigInteger.valueOf(0xFFFFFFFFFFFFFL);
    private static final BigInteger BI_IMPLIED_FRAC_MSB = BigInteger.valueOf(0x10000000000000L);
    private final BigInteger _significand;
    private final int _binaryExponent;

    private static BigInteger getFrac(long l) {
        return BigInteger.valueOf(l).and(BI_FRAC_MASK).or(BI_IMPLIED_FRAC_MSB).shiftLeft(11);
    }

    public static ExpandedDouble fromRawBitsAndExponent(long l, int n) {
        return new ExpandedDouble(ExpandedDouble.getFrac(l), n);
    }

    public ExpandedDouble(long l) {
        int n = (int)(l >> 52);
        if (n == 0) {
            BigInteger bigInteger = BigInteger.valueOf(l).and(BI_FRAC_MASK);
            int n2 = 64 - bigInteger.bitLength();
            this._significand = bigInteger.shiftLeft(n2);
            this._binaryExponent = (n & 0x7FF) - 1023 - n2;
        } else {
            BigInteger bigInteger;
            this._significand = bigInteger = ExpandedDouble.getFrac(l);
            this._binaryExponent = (n & 0x7FF) - 1023;
        }
    }

    ExpandedDouble(BigInteger bigInteger, int n) {
        if (bigInteger.bitLength() != 64) {
            throw new IllegalArgumentException("bad bit length");
        }
        this._significand = bigInteger;
        this._binaryExponent = n;
    }

    public NormalisedDecimal normaliseBaseTen() {
        return NormalisedDecimal.create(this._significand, this._binaryExponent);
    }

    public int getBinaryExponent() {
        return this._binaryExponent;
    }

    public BigInteger getSignificand() {
        return this._significand;
    }
}

