/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.ss.util;

import ai.org.apache.poi.ss.usermodel.Cell;
import ai.org.apache.poi.ss.usermodel.CellStyle;
import ai.org.apache.poi.ss.usermodel.Font;
import ai.org.apache.poi.ss.usermodel.Row;
import ai.org.apache.poi.ss.usermodel.Sheet;
import ai.org.apache.poi.ss.usermodel.Workbook;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CellUtil {
    public static final String ALIGNMENT = "alignment";
    public static final String BORDER_BOTTOM = "borderBottom";
    public static final String BORDER_LEFT = "borderLeft";
    public static final String BORDER_RIGHT = "borderRight";
    public static final String BORDER_TOP = "borderTop";
    public static final String BOTTOM_BORDER_COLOR = "bottomBorderColor";
    public static final String DATA_FORMAT = "dataFormat";
    public static final String FILL_BACKGROUND_COLOR = "fillBackgroundColor";
    public static final String FILL_FOREGROUND_COLOR = "fillForegroundColor";
    public static final String FILL_PATTERN = "fillPattern";
    public static final String FONT = "font";
    public static final String HIDDEN = "hidden";
    public static final String INDENTION = "indention";
    public static final String LEFT_BORDER_COLOR = "leftBorderColor";
    public static final String LOCKED = "locked";
    public static final String RIGHT_BORDER_COLOR = "rightBorderColor";
    public static final String ROTATION = "rotation";
    public static final String TOP_BORDER_COLOR = "topBorderColor";
    public static final String VERTICAL_ALIGNMENT = "verticalAlignment";
    public static final String WRAP_TEXT = "wrapText";
    private static UnicodeMapping[] unicodeMappings = new UnicodeMapping[]{CellUtil.um("alpha", "\u03b1"), CellUtil.um("beta", "\u03b2"), CellUtil.um("gamma", "\u03b3"), CellUtil.um("delta", "\u03b4"), CellUtil.um("epsilon", "\u03b5"), CellUtil.um("zeta", "\u03b6"), CellUtil.um("eta", "\u03b7"), CellUtil.um("theta", "\u03b8"), CellUtil.um("iota", "\u03b9"), CellUtil.um("kappa", "\u03ba"), CellUtil.um("lambda", "\u03bb"), CellUtil.um("mu", "\u03bc"), CellUtil.um("nu", "\u03bd"), CellUtil.um("xi", "\u03be"), CellUtil.um("omicron", "\u03bf")};

    private CellUtil() {
    }

    public static Row getRow(int n, Sheet sheet) {
        Row row = sheet.getRow(n);
        if (row == null) {
            row = sheet.createRow(n);
        }
        return row;
    }

    public static Cell getCell(Row row, int n) {
        Cell cell = row.getCell(n);
        if (cell == null) {
            cell = row.createCell(n);
        }
        return cell;
    }

    public static Cell createCell(Row row, int n, String string, CellStyle cellStyle) {
        Cell cell = CellUtil.getCell(row, n);
        cell.setCellValue(cell.getRow().getSheet().getWorkbook().getCreationHelper().createRichTextString(string));
        if (cellStyle != null) {
            cell.setCellStyle(cellStyle);
        }
        return cell;
    }

    public static Cell createCell(Row row, int n, String string) {
        return CellUtil.createCell(row, n, string, null);
    }

    public static void setAlignment(Cell cell, Workbook workbook, short s) {
        CellUtil.setCellStyleProperty(cell, workbook, ALIGNMENT, s);
    }

    public static void setFont(Cell cell, Workbook workbook, Font font) {
        CellUtil.setCellStyleProperty(cell, workbook, FONT, font.getIndex());
    }

    public static void setCellStyleProperty(Cell cell, Workbook workbook, String string, Object object) {
        CellStyle cellStyle = cell.getCellStyle();
        CellStyle cellStyle2 = null;
        Map<String, Object> map = CellUtil.getFormatProperties(cellStyle);
        map.put(string, object);
        short s = workbook.getNumCellStyles();
        for (short s2 = 0; s2 < s; s2 = (short)(s2 + 1)) {
            CellStyle cellStyle3 = workbook.getCellStyleAt(s2);
            Map<String, Object> map2 = CellUtil.getFormatProperties(cellStyle3);
            if (!map2.equals(map)) continue;
            cellStyle2 = cellStyle3;
            break;
        }
        if (cellStyle2 == null) {
            cellStyle2 = workbook.createCellStyle();
            CellUtil.setFormatProperties(cellStyle2, workbook, map);
        }
        cell.setCellStyle(cellStyle2);
    }

    private static Map<String, Object> getFormatProperties(CellStyle cellStyle) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        CellUtil.putShort(hashMap, ALIGNMENT, cellStyle.getAlignment());
        CellUtil.putShort(hashMap, BORDER_BOTTOM, cellStyle.getBorderBottom());
        CellUtil.putShort(hashMap, BORDER_LEFT, cellStyle.getBorderLeft());
        CellUtil.putShort(hashMap, BORDER_RIGHT, cellStyle.getBorderRight());
        CellUtil.putShort(hashMap, BORDER_TOP, cellStyle.getBorderTop());
        CellUtil.putShort(hashMap, BOTTOM_BORDER_COLOR, cellStyle.getBottomBorderColor());
        CellUtil.putShort(hashMap, DATA_FORMAT, cellStyle.getDataFormat());
        CellUtil.putShort(hashMap, FILL_BACKGROUND_COLOR, cellStyle.getFillBackgroundColor());
        CellUtil.putShort(hashMap, FILL_FOREGROUND_COLOR, cellStyle.getFillForegroundColor());
        CellUtil.putShort(hashMap, FILL_PATTERN, cellStyle.getFillPattern());
        CellUtil.putShort(hashMap, FONT, cellStyle.getFontIndex());
        CellUtil.putBoolean(hashMap, HIDDEN, cellStyle.getHidden());
        CellUtil.putShort(hashMap, INDENTION, cellStyle.getIndention());
        CellUtil.putShort(hashMap, LEFT_BORDER_COLOR, cellStyle.getLeftBorderColor());
        CellUtil.putBoolean(hashMap, LOCKED, cellStyle.getLocked());
        CellUtil.putShort(hashMap, RIGHT_BORDER_COLOR, cellStyle.getRightBorderColor());
        CellUtil.putShort(hashMap, ROTATION, cellStyle.getRotation());
        CellUtil.putShort(hashMap, TOP_BORDER_COLOR, cellStyle.getTopBorderColor());
        CellUtil.putShort(hashMap, VERTICAL_ALIGNMENT, cellStyle.getVerticalAlignment());
        CellUtil.putBoolean(hashMap, WRAP_TEXT, cellStyle.getWrapText());
        return hashMap;
    }

    private static void setFormatProperties(CellStyle cellStyle, Workbook workbook, Map<String, Object> map) {
        cellStyle.setAlignment(CellUtil.getShort(map, ALIGNMENT));
        cellStyle.setBorderBottom(CellUtil.getShort(map, BORDER_BOTTOM));
        cellStyle.setBorderLeft(CellUtil.getShort(map, BORDER_LEFT));
        cellStyle.setBorderRight(CellUtil.getShort(map, BORDER_RIGHT));
        cellStyle.setBorderTop(CellUtil.getShort(map, BORDER_TOP));
        cellStyle.setBottomBorderColor(CellUtil.getShort(map, BOTTOM_BORDER_COLOR));
        cellStyle.setDataFormat(CellUtil.getShort(map, DATA_FORMAT));
        cellStyle.setFillBackgroundColor(CellUtil.getShort(map, FILL_BACKGROUND_COLOR));
        cellStyle.setFillForegroundColor(CellUtil.getShort(map, FILL_FOREGROUND_COLOR));
        cellStyle.setFillPattern(CellUtil.getShort(map, FILL_PATTERN));
        cellStyle.setFont(workbook.getFontAt(CellUtil.getShort(map, FONT)));
        cellStyle.setHidden(CellUtil.getBoolean(map, HIDDEN));
        cellStyle.setIndention(CellUtil.getShort(map, INDENTION));
        cellStyle.setLeftBorderColor(CellUtil.getShort(map, LEFT_BORDER_COLOR));
        cellStyle.setLocked(CellUtil.getBoolean(map, LOCKED));
        cellStyle.setRightBorderColor(CellUtil.getShort(map, RIGHT_BORDER_COLOR));
        cellStyle.setRotation(CellUtil.getShort(map, ROTATION));
        cellStyle.setTopBorderColor(CellUtil.getShort(map, TOP_BORDER_COLOR));
        cellStyle.setVerticalAlignment(CellUtil.getShort(map, VERTICAL_ALIGNMENT));
        cellStyle.setWrapText(CellUtil.getBoolean(map, WRAP_TEXT));
    }

    private static short getShort(Map<String, Object> map, String string) {
        Object object = map.get(string);
        if (object instanceof Short) {
            return (Short)object;
        }
        return 0;
    }

    private static boolean getBoolean(Map<String, Object> map, String string) {
        Object object = map.get(string);
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        return false;
    }

    private static void putShort(Map<String, Object> map, String string, short s) {
        map.put(string, s);
    }

    private static void putBoolean(Map<String, Object> map, String string, boolean bl) {
        map.put(string, bl);
    }

    public static Cell translateUnicodeValues(Cell cell) {
        String string = cell.getRichStringCellValue().getString();
        boolean bl = false;
        String string2 = string.toLowerCase();
        for (int i = 0; i < unicodeMappings.length; ++i) {
            UnicodeMapping unicodeMapping = unicodeMappings[i];
            String string3 = unicodeMapping.entityName;
            if (string2.indexOf(string3) == -1) continue;
            string = string.replaceAll(string3, unicodeMapping.resolvedValue);
            bl = true;
        }
        if (bl) {
            cell.setCellValue(cell.getRow().getSheet().getWorkbook().getCreationHelper().createRichTextString(string));
        }
        return cell;
    }

    private static UnicodeMapping um(String string, String string2) {
        return new UnicodeMapping(string, string2);
    }

    private static final class UnicodeMapping {
        public final String entityName;
        public final String resolvedValue;

        public UnicodeMapping(String string, String string2) {
            this.entityName = "&" + string + ";";
            this.resolvedValue = string2;
        }
    }
}

