/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.ss.util;

import ai.org.apache.poi.ss.SpreadsheetVersion;
import ai.org.apache.poi.ss.util.CellReference;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class AreaReference {
    private static final char SHEET_NAME_DELIMITER = '!';
    private static final char CELL_DELIMITER = ':';
    private static final char SPECIAL_NAME_DELIMITER = '\'';
    private final CellReference _firstCell;
    private final CellReference _lastCell;
    private final boolean _isSingleCell;

    public AreaReference(String string) {
        if (!AreaReference.isContiguous(string)) {
            throw new IllegalArgumentException("References passed to the AreaReference must be contiguous, use generateContiguous(ref) if you have non-contiguous references");
        }
        String[] stringArray = AreaReference.separateAreaRefs(string);
        String string2 = stringArray[0];
        if (stringArray.length == 1) {
            this._lastCell = this._firstCell = new CellReference(string2);
            this._isSingleCell = true;
            return;
        }
        if (stringArray.length != 2) {
            throw new IllegalArgumentException("Bad area ref '" + string + "'");
        }
        String string3 = stringArray[1];
        if (this.isPlainColumn(string2)) {
            if (!this.isPlainColumn(string3)) {
                throw new RuntimeException("Bad area ref '" + string + "'");
            }
            boolean bl = CellReference.isPartAbsolute(string2);
            boolean bl2 = CellReference.isPartAbsolute(string3);
            int n = CellReference.convertColStringToIndex(string2);
            int n2 = CellReference.convertColStringToIndex(string3);
            this._firstCell = new CellReference(0, n, true, bl);
            this._lastCell = new CellReference(65535, n2, true, bl2);
            this._isSingleCell = false;
        } else {
            this._firstCell = new CellReference(string2);
            this._lastCell = new CellReference(string3);
            this._isSingleCell = string2.equals(string3);
        }
    }

    private boolean isPlainColumn(String string) {
        for (int i = string.length() - 1; i >= 0; --i) {
            char c = string.charAt(i);
            if (c == '$' && i == 0 || c >= 'A' && c <= 'Z') continue;
            return false;
        }
        return true;
    }

    public AreaReference(CellReference cellReference, CellReference cellReference2) {
        boolean bl;
        boolean bl2 = cellReference.getRow() > cellReference2.getRow();
        boolean bl3 = bl = cellReference.getCol() > cellReference2.getCol();
        if (bl2 || bl) {
            boolean bl4;
            short s;
            boolean bl5;
            short s2;
            boolean bl6;
            int n;
            boolean bl7;
            int n2;
            if (bl2) {
                n2 = cellReference2.getRow();
                bl7 = cellReference2.isRowAbsolute();
                n = cellReference.getRow();
                bl6 = cellReference.isRowAbsolute();
            } else {
                n2 = cellReference.getRow();
                bl7 = cellReference.isRowAbsolute();
                n = cellReference2.getRow();
                bl6 = cellReference2.isRowAbsolute();
            }
            if (bl) {
                s2 = cellReference2.getCol();
                bl5 = cellReference2.isColAbsolute();
                s = cellReference.getCol();
                bl4 = cellReference.isColAbsolute();
            } else {
                s2 = cellReference.getCol();
                bl5 = cellReference.isColAbsolute();
                s = cellReference2.getCol();
                bl4 = cellReference2.isColAbsolute();
            }
            this._firstCell = new CellReference(n2, s2, bl7, bl5);
            this._lastCell = new CellReference(n, s, bl6, bl4);
        } else {
            this._firstCell = cellReference;
            this._lastCell = cellReference2;
        }
        this._isSingleCell = false;
    }

    public static boolean isContiguous(String string) {
        int n = string.indexOf(33);
        if (n != -1) {
            string = string.substring(n);
        }
        return string.indexOf(44) == -1;
    }

    public static AreaReference getWholeRow(String string, String string2) {
        return new AreaReference("$A" + string + ":$IV" + string2);
    }

    public static AreaReference getWholeColumn(String string, String string2) {
        return new AreaReference(string + "$1:" + string2 + "$65536");
    }

    public static boolean isWholeColumnReference(CellReference cellReference, CellReference cellReference2) {
        return cellReference.getRow() == 0 && cellReference.isRowAbsolute() && cellReference2.getRow() == SpreadsheetVersion.EXCEL97.getLastRowIndex() && cellReference2.isRowAbsolute();
    }

    public boolean isWholeColumnReference() {
        return AreaReference.isWholeColumnReference(this._firstCell, this._lastCell);
    }

    public static AreaReference[] generateContiguous(String string) {
        ArrayList<AreaReference> arrayList = new ArrayList<AreaReference>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(new AreaReference(stringTokenizer.nextToken()));
        }
        return arrayList.toArray(new AreaReference[arrayList.size()]);
    }

    public boolean isSingleCell() {
        return this._isSingleCell;
    }

    public CellReference getFirstCell() {
        return this._firstCell;
    }

    public CellReference getLastCell() {
        return this._lastCell;
    }

    public CellReference[] getAllReferencedCells() {
        if (this._isSingleCell) {
            return new CellReference[]{this._firstCell};
        }
        int n = Math.min(this._firstCell.getRow(), this._lastCell.getRow());
        int n2 = Math.max(this._firstCell.getRow(), this._lastCell.getRow());
        int n3 = Math.min(this._firstCell.getCol(), this._lastCell.getCol());
        int n4 = Math.max(this._firstCell.getCol(), this._lastCell.getCol());
        String string = this._firstCell.getSheetName();
        ArrayList<CellReference> arrayList = new ArrayList<CellReference>();
        for (int i = n; i <= n2; ++i) {
            for (int j = n3; j <= n4; ++j) {
                CellReference cellReference = new CellReference(string, i, j, this._firstCell.isRowAbsolute(), this._firstCell.isColAbsolute());
                arrayList.add(cellReference);
            }
        }
        return arrayList.toArray(new CellReference[arrayList.size()]);
    }

    public String formatAsString() {
        if (this.isWholeColumnReference()) {
            return CellReference.convertNumToColString(this._firstCell.getCol()) + ":" + CellReference.convertNumToColString(this._lastCell.getCol());
        }
        StringBuffer stringBuffer = new StringBuffer(32);
        stringBuffer.append(this._firstCell.formatAsString());
        if (!this._isSingleCell) {
            stringBuffer.append(':');
            if (this._lastCell.getSheetName() == null) {
                stringBuffer.append(this._lastCell.formatAsString());
            } else {
                this._lastCell.appendCellReference(stringBuffer);
            }
        }
        return stringBuffer.toString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(64);
        stringBuffer.append(this.getClass().getName()).append(" [");
        stringBuffer.append(this.formatAsString());
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    private static String[] separateAreaRefs(String string) {
        int n = string.length();
        int n2 = -1;
        boolean bl = false;
        block4: for (int i = 0; i < n; ++i) {
            switch (string.charAt(i)) {
                case ':': {
                    if (!bl) {
                        if (n2 >= 0) {
                            throw new IllegalArgumentException("More than one cell delimiter ':' appears in area reference '" + string + "'");
                        }
                        n2 = i;
                    }
                }
                default: {
                    continue block4;
                }
                case '\'': {
                    if (!bl) {
                        bl = true;
                        continue block4;
                    }
                    if (i >= n - 1) {
                        throw new IllegalArgumentException("Area reference '" + string + "' ends with special name delimiter '" + '\'' + "'");
                    }
                    if (string.charAt(i + 1) == '\'') {
                        ++i;
                        continue block4;
                    }
                    bl = false;
                }
            }
        }
        if (n2 < 0) {
            return new String[]{string};
        }
        String string2 = string.substring(0, n2);
        String string3 = string.substring(n2 + 1);
        if (string3.indexOf(33) >= 0) {
            throw new RuntimeException("Unexpected ! in second cell reference of '" + string + "'");
        }
        int n3 = string2.lastIndexOf(33);
        if (n3 < 0) {
            return new String[]{string2, string3};
        }
        String string4 = string2.substring(0, n3 + 1);
        return new String[]{string2, string4 + string3};
    }
}

