/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.ss.usermodel;

import ai.org.apache.poi.ss.usermodel.DataFormatter;
import java.math.RoundingMode;
import java.text.DateFormatSymbols;
import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class ExcelStyleDateFormatter
extends SimpleDateFormat {
    public static final char MMMMM_START_SYMBOL = '\ue001';
    public static final char MMMMM_TRUNCATE_SYMBOL = '\ue002';
    public static final char H_BRACKET_SYMBOL = '\ue010';
    public static final char HH_BRACKET_SYMBOL = '\ue011';
    public static final char M_BRACKET_SYMBOL = '\ue012';
    public static final char MM_BRACKET_SYMBOL = '\ue013';
    public static final char S_BRACKET_SYMBOL = '\ue014';
    public static final char SS_BRACKET_SYMBOL = '\ue015';
    public static final char L_BRACKET_SYMBOL = '\ue016';
    public static final char LL_BRACKET_SYMBOL = '\ue017';
    private DecimalFormat format1digit = new DecimalFormat("0");
    private DecimalFormat format2digits = new DecimalFormat("00");
    private DecimalFormat format3digit = new DecimalFormat("0");
    private DecimalFormat format4digits = new DecimalFormat("00");
    private double dateToBeFormatted;

    public ExcelStyleDateFormatter() {
        DataFormatter.setExcelStyleRoundingMode(this.format1digit, RoundingMode.DOWN);
        DataFormatter.setExcelStyleRoundingMode(this.format2digits, RoundingMode.DOWN);
        DataFormatter.setExcelStyleRoundingMode(this.format3digit);
        DataFormatter.setExcelStyleRoundingMode(this.format4digits);
        this.dateToBeFormatted = 0.0;
    }

    public ExcelStyleDateFormatter(String string) {
        super(ExcelStyleDateFormatter.processFormatPattern(string));
        DataFormatter.setExcelStyleRoundingMode(this.format1digit, RoundingMode.DOWN);
        DataFormatter.setExcelStyleRoundingMode(this.format2digits, RoundingMode.DOWN);
        DataFormatter.setExcelStyleRoundingMode(this.format3digit);
        DataFormatter.setExcelStyleRoundingMode(this.format4digits);
        this.dateToBeFormatted = 0.0;
    }

    public ExcelStyleDateFormatter(String string, DateFormatSymbols dateFormatSymbols) {
        super(ExcelStyleDateFormatter.processFormatPattern(string), dateFormatSymbols);
        DataFormatter.setExcelStyleRoundingMode(this.format1digit, RoundingMode.DOWN);
        DataFormatter.setExcelStyleRoundingMode(this.format2digits, RoundingMode.DOWN);
        DataFormatter.setExcelStyleRoundingMode(this.format3digit);
        DataFormatter.setExcelStyleRoundingMode(this.format4digits);
        this.dateToBeFormatted = 0.0;
    }

    public ExcelStyleDateFormatter(String string, Locale locale) {
        super(ExcelStyleDateFormatter.processFormatPattern(string), locale);
        DataFormatter.setExcelStyleRoundingMode(this.format1digit, RoundingMode.DOWN);
        DataFormatter.setExcelStyleRoundingMode(this.format2digits, RoundingMode.DOWN);
        DataFormatter.setExcelStyleRoundingMode(this.format3digit);
        DataFormatter.setExcelStyleRoundingMode(this.format4digits);
        this.dateToBeFormatted = 0.0;
    }

    private static String processFormatPattern(String string) {
        String string2 = string.replaceAll("MMMMM", "\ue001MMM\ue002");
        string2 = string2.replaceAll("\\[H\\]", String.valueOf('\ue010'));
        string2 = string2.replaceAll("\\[HH\\]", String.valueOf('\ue011'));
        string2 = string2.replaceAll("\\[m\\]", String.valueOf('\ue012'));
        string2 = string2.replaceAll("\\[mm\\]", String.valueOf('\ue013'));
        string2 = string2.replaceAll("\\[s\\]", String.valueOf('\ue014'));
        string2 = string2.replaceAll("\\[ss\\]", String.valueOf('\ue015'));
        string2 = string2.replaceAll("s.000", "s.SSS");
        string2 = string2.replaceAll("s.00", "s.\ue017");
        string2 = string2.replaceAll("s.0", "s.\ue016");
        return string2;
    }

    public void setDateToBeFormatted(double d) {
        this.dateToBeFormatted = d;
    }

    public StringBuffer format(Date date, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        float f;
        String string = super.format(date, stringBuffer, fieldPosition).toString();
        if (string.indexOf(57345) != -1) {
            string = string.replaceAll("\ue001(\\w)\\w+\ue002", "$1");
        }
        if (string.indexOf(57360) != -1 || string.indexOf(57361) != -1) {
            f = (float)this.dateToBeFormatted * 24.0f;
            string = string.replaceAll(String.valueOf('\ue010'), this.format1digit.format(f));
            string = string.replaceAll(String.valueOf('\ue011'), this.format2digits.format(f));
        }
        if (string.indexOf(57362) != -1 || string.indexOf(57363) != -1) {
            f = (float)this.dateToBeFormatted * 24.0f * 60.0f;
            string = string.replaceAll(String.valueOf('\ue012'), this.format1digit.format(f));
            string = string.replaceAll(String.valueOf('\ue013'), this.format2digits.format(f));
        }
        if (string.indexOf(57364) != -1 || string.indexOf(57365) != -1) {
            f = (float)(this.dateToBeFormatted * 24.0 * 60.0 * 60.0);
            string = string.replaceAll(String.valueOf('\ue014'), this.format1digit.format(f));
            string = string.replaceAll(String.valueOf('\ue015'), this.format2digits.format(f));
        }
        if (string.indexOf(57366) != -1 || string.indexOf(57367) != -1) {
            f = (float)((this.dateToBeFormatted - Math.floor(this.dateToBeFormatted)) * 24.0 * 60.0 * 60.0);
            float f2 = f - (float)((int)f);
            string = string.replaceAll(String.valueOf('\ue016'), this.format3digit.format(f2 * 10.0f));
            string = string.replaceAll(String.valueOf('\ue017'), this.format4digits.format(f2 * 100.0f));
        }
        return new StringBuffer(string);
    }
}

