/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.ss.usermodel;

import ai.org.apache.poi.ss.formula.eval.ErrorEval;

public final class CellValue {
    public static final CellValue TRUE = new CellValue(4, 0.0, true, null, 0);
    public static final CellValue FALSE = new CellValue(4, 0.0, false, null, 0);
    private final int _cellType;
    private final double _numberValue;
    private final boolean _booleanValue;
    private final String _textValue;
    private final int _errorCode;

    private CellValue(int n, double d, boolean bl, String string, int n2) {
        this._cellType = n;
        this._numberValue = d;
        this._booleanValue = bl;
        this._textValue = string;
        this._errorCode = n2;
    }

    public CellValue(double d) {
        this(0, d, false, null, 0);
    }

    public static CellValue valueOf(boolean bl) {
        return bl ? TRUE : FALSE;
    }

    public CellValue(String string) {
        this(1, 0.0, false, string, 0);
    }

    public static CellValue getError(int n) {
        return new CellValue(5, 0.0, false, null, n);
    }

    public boolean getBooleanValue() {
        return this._booleanValue;
    }

    public double getNumberValue() {
        return this._numberValue;
    }

    public String getStringValue() {
        return this._textValue;
    }

    public int getCellType() {
        return this._cellType;
    }

    public byte getErrorValue() {
        return (byte)this._errorCode;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(64);
        stringBuffer.append(this.getClass().getName()).append(" [");
        stringBuffer.append(this.formatAsString());
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public String formatAsString() {
        switch (this._cellType) {
            case 0: {
                return String.valueOf(this._numberValue);
            }
            case 1: {
                return '\"' + this._textValue + '\"';
            }
            case 4: {
                return this._booleanValue ? "TRUE" : "FALSE";
            }
            case 5: {
                return ErrorEval.getText(this._errorCode);
            }
        }
        return "<error unexpected cell type " + this._cellType + ">";
    }
}

