/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.ss.formula.ptg;

import ai.org.apache.poi.ss.formula.ptg.RefPtgBase;
import ai.org.apache.poi.ss.util.CellReference;
import ai.org.apache.poi.util.LittleEndianInput;
import ai.org.apache.poi.util.LittleEndianOutput;

abstract class Ref2DPtgBase
extends RefPtgBase {
    private static final int SIZE = 5;

    protected Ref2DPtgBase(int n, int n2, boolean bl, boolean bl2) {
        this.setRow(n);
        this.setColumn(n2);
        this.setRowRelative(bl);
        this.setColRelative(bl2);
    }

    protected Ref2DPtgBase(LittleEndianInput littleEndianInput) {
        this.readCoordinates(littleEndianInput);
    }

    protected Ref2DPtgBase(CellReference cellReference) {
        super(cellReference);
    }

    public void write(LittleEndianOutput littleEndianOutput) {
        littleEndianOutput.writeByte(this.getSid() + this.getPtgClass());
        this.writeCoordinates(littleEndianOutput);
    }

    public final String toFormulaString() {
        return this.formatReferenceAsString();
    }

    protected abstract byte getSid();

    public final int getSize() {
        return 5;
    }

    public final String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getClass().getName());
        stringBuffer.append(" [");
        stringBuffer.append(this.formatReferenceAsString());
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

