/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.ss.formula.ptg;

import ai.org.apache.poi.ss.formula.ptg.AddPtg;
import ai.org.apache.poi.ss.formula.ptg.Area3DPtg;
import ai.org.apache.poi.ss.formula.ptg.AreaErrPtg;
import ai.org.apache.poi.ss.formula.ptg.AreaNPtg;
import ai.org.apache.poi.ss.formula.ptg.AreaPtg;
import ai.org.apache.poi.ss.formula.ptg.ArrayPtg;
import ai.org.apache.poi.ss.formula.ptg.AttrPtg;
import ai.org.apache.poi.ss.formula.ptg.BoolPtg;
import ai.org.apache.poi.ss.formula.ptg.ConcatPtg;
import ai.org.apache.poi.ss.formula.ptg.DeletedArea3DPtg;
import ai.org.apache.poi.ss.formula.ptg.DeletedRef3DPtg;
import ai.org.apache.poi.ss.formula.ptg.DividePtg;
import ai.org.apache.poi.ss.formula.ptg.EqualPtg;
import ai.org.apache.poi.ss.formula.ptg.ErrPtg;
import ai.org.apache.poi.ss.formula.ptg.ExpPtg;
import ai.org.apache.poi.ss.formula.ptg.FuncPtg;
import ai.org.apache.poi.ss.formula.ptg.FuncVarPtg;
import ai.org.apache.poi.ss.formula.ptg.GreaterEqualPtg;
import ai.org.apache.poi.ss.formula.ptg.GreaterThanPtg;
import ai.org.apache.poi.ss.formula.ptg.IntPtg;
import ai.org.apache.poi.ss.formula.ptg.IntersectionPtg;
import ai.org.apache.poi.ss.formula.ptg.LessEqualPtg;
import ai.org.apache.poi.ss.formula.ptg.LessThanPtg;
import ai.org.apache.poi.ss.formula.ptg.MemAreaPtg;
import ai.org.apache.poi.ss.formula.ptg.MemErrPtg;
import ai.org.apache.poi.ss.formula.ptg.MemFuncPtg;
import ai.org.apache.poi.ss.formula.ptg.MissingArgPtg;
import ai.org.apache.poi.ss.formula.ptg.MultiplyPtg;
import ai.org.apache.poi.ss.formula.ptg.NamePtg;
import ai.org.apache.poi.ss.formula.ptg.NameXPtg;
import ai.org.apache.poi.ss.formula.ptg.NotEqualPtg;
import ai.org.apache.poi.ss.formula.ptg.NumberPtg;
import ai.org.apache.poi.ss.formula.ptg.ParenthesisPtg;
import ai.org.apache.poi.ss.formula.ptg.PercentPtg;
import ai.org.apache.poi.ss.formula.ptg.PowerPtg;
import ai.org.apache.poi.ss.formula.ptg.RangePtg;
import ai.org.apache.poi.ss.formula.ptg.Ref3DPtg;
import ai.org.apache.poi.ss.formula.ptg.RefErrorPtg;
import ai.org.apache.poi.ss.formula.ptg.RefNPtg;
import ai.org.apache.poi.ss.formula.ptg.RefPtg;
import ai.org.apache.poi.ss.formula.ptg.StringPtg;
import ai.org.apache.poi.ss.formula.ptg.SubtractPtg;
import ai.org.apache.poi.ss.formula.ptg.TblPtg;
import ai.org.apache.poi.ss.formula.ptg.UnaryMinusPtg;
import ai.org.apache.poi.ss.formula.ptg.UnaryPlusPtg;
import ai.org.apache.poi.ss.formula.ptg.UnionPtg;
import ai.org.apache.poi.ss.formula.ptg.UnknownPtg;
import ai.org.apache.poi.util.LittleEndianByteArrayOutputStream;
import ai.org.apache.poi.util.LittleEndianInput;
import ai.org.apache.poi.util.LittleEndianOutput;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Ptg {
    public static final Ptg[] EMPTY_PTG_ARRAY = new Ptg[0];
    public static final byte CLASS_REF = 0;
    public static final byte CLASS_VALUE = 32;
    public static final byte CLASS_ARRAY = 64;
    private byte ptgClass = 0;

    public static Ptg[] readTokens(int n, LittleEndianInput littleEndianInput) {
        int n2;
        Ptg[] ptgArray;
        ArrayList<Ptg> arrayList = new ArrayList<Ptg>(4 + n / 2);
        boolean bl = false;
        for (n2 = 0; n2 < n; n2 += ptgArray.getSize()) {
            ptgArray = Ptg.createPtg(littleEndianInput);
            if (ptgArray instanceof ArrayPtg.Initial) {
                bl = true;
            }
            arrayList.add((Ptg)ptgArray);
        }
        if (n2 != n) {
            throw new RuntimeException("Ptg array size mismatch");
        }
        if (bl) {
            ptgArray = Ptg.toPtgArray(arrayList);
            for (int i = 0; i < ptgArray.length; ++i) {
                if (!(ptgArray[i] instanceof ArrayPtg.Initial)) continue;
                ptgArray[i] = ((ArrayPtg.Initial)ptgArray[i]).finishReading(littleEndianInput);
            }
            return ptgArray;
        }
        return Ptg.toPtgArray(arrayList);
    }

    public static Ptg createPtg(LittleEndianInput littleEndianInput) {
        byte by = littleEndianInput.readByte();
        if (by < 32) {
            return Ptg.createBasePtg(by, littleEndianInput);
        }
        Ptg ptg = Ptg.createClassifiedPtg(by, littleEndianInput);
        if (by >= 96) {
            ptg.setClass((byte)64);
        } else if (by >= 64) {
            ptg.setClass((byte)32);
        } else {
            ptg.setClass((byte)0);
        }
        return ptg;
    }

    private static Ptg createClassifiedPtg(byte by, LittleEndianInput littleEndianInput) {
        int n = by & 0x1F | 0x20;
        switch (n) {
            case 32: {
                return new ArrayPtg.Initial(littleEndianInput);
            }
            case 33: {
                return FuncPtg.create(littleEndianInput);
            }
            case 34: {
                return FuncVarPtg.create(littleEndianInput);
            }
            case 35: {
                return new NamePtg(littleEndianInput);
            }
            case 36: {
                return new RefPtg(littleEndianInput);
            }
            case 37: {
                return new AreaPtg(littleEndianInput);
            }
            case 38: {
                return new MemAreaPtg(littleEndianInput);
            }
            case 39: {
                return new MemErrPtg(littleEndianInput);
            }
            case 41: {
                return new MemFuncPtg(littleEndianInput);
            }
            case 42: {
                return new RefErrorPtg(littleEndianInput);
            }
            case 43: {
                return new AreaErrPtg(littleEndianInput);
            }
            case 44: {
                return new RefNPtg(littleEndianInput);
            }
            case 45: {
                return new AreaNPtg(littleEndianInput);
            }
            case 57: {
                return new NameXPtg(littleEndianInput);
            }
            case 58: {
                return new Ref3DPtg(littleEndianInput);
            }
            case 59: {
                return new Area3DPtg(littleEndianInput);
            }
            case 60: {
                return new DeletedRef3DPtg(littleEndianInput);
            }
            case 61: {
                return new DeletedArea3DPtg(littleEndianInput);
            }
        }
        throw new UnsupportedOperationException(" Unknown Ptg in Formula: 0x" + Integer.toHexString(by) + " (" + by + ")");
    }

    private static Ptg createBasePtg(byte by, LittleEndianInput littleEndianInput) {
        switch (by) {
            case 0: {
                return new UnknownPtg(by);
            }
            case 1: {
                return new ExpPtg(littleEndianInput);
            }
            case 2: {
                return new TblPtg(littleEndianInput);
            }
            case 3: {
                return AddPtg.instance;
            }
            case 4: {
                return SubtractPtg.instance;
            }
            case 5: {
                return MultiplyPtg.instance;
            }
            case 6: {
                return DividePtg.instance;
            }
            case 7: {
                return PowerPtg.instance;
            }
            case 8: {
                return ConcatPtg.instance;
            }
            case 9: {
                return LessThanPtg.instance;
            }
            case 10: {
                return LessEqualPtg.instance;
            }
            case 11: {
                return EqualPtg.instance;
            }
            case 12: {
                return GreaterEqualPtg.instance;
            }
            case 13: {
                return GreaterThanPtg.instance;
            }
            case 14: {
                return NotEqualPtg.instance;
            }
            case 15: {
                return IntersectionPtg.instance;
            }
            case 16: {
                return UnionPtg.instance;
            }
            case 17: {
                return RangePtg.instance;
            }
            case 18: {
                return UnaryPlusPtg.instance;
            }
            case 19: {
                return UnaryMinusPtg.instance;
            }
            case 20: {
                return PercentPtg.instance;
            }
            case 21: {
                return ParenthesisPtg.instance;
            }
            case 22: {
                return MissingArgPtg.instance;
            }
            case 23: {
                return new StringPtg(littleEndianInput);
            }
            case 25: {
                return new AttrPtg(littleEndianInput);
            }
            case 28: {
                return ErrPtg.read(littleEndianInput);
            }
            case 29: {
                return BoolPtg.read(littleEndianInput);
            }
            case 30: {
                return new IntPtg(littleEndianInput);
            }
            case 31: {
                return new NumberPtg(littleEndianInput);
            }
        }
        throw new RuntimeException("Unexpected base token id (" + by + ")");
    }

    private static Ptg[] toPtgArray(List<Ptg> list) {
        if (list.isEmpty()) {
            return EMPTY_PTG_ARRAY;
        }
        Ptg[] ptgArray = new Ptg[list.size()];
        list.toArray(ptgArray);
        return ptgArray;
    }

    public static int getEncodedSize(Ptg[] ptgArray) {
        int n = 0;
        for (int i = 0; i < ptgArray.length; ++i) {
            n += ptgArray[i].getSize();
        }
        return n;
    }

    public static int getEncodedSizeWithoutArrayData(Ptg[] ptgArray) {
        int n = 0;
        for (int i = 0; i < ptgArray.length; ++i) {
            Ptg ptg = ptgArray[i];
            if (ptg instanceof ArrayPtg) {
                n += 8;
                continue;
            }
            n += ptg.getSize();
        }
        return n;
    }

    public static int serializePtgs(Ptg[] ptgArray, byte[] byArray, int n) {
        Ptg ptg;
        int n2;
        int n3 = ptgArray.length;
        LittleEndianByteArrayOutputStream littleEndianByteArrayOutputStream = new LittleEndianByteArrayOutputStream(byArray, n);
        ArrayList<Ptg> arrayList = null;
        for (n2 = 0; n2 < n3; ++n2) {
            ptg = ptgArray[n2];
            ptg.write(littleEndianByteArrayOutputStream);
            if (!(ptg instanceof ArrayPtg)) continue;
            if (arrayList == null) {
                arrayList = new ArrayList<Ptg>(5);
            }
            arrayList.add(ptg);
        }
        if (arrayList != null) {
            for (n2 = 0; n2 < arrayList.size(); ++n2) {
                ptg = (ArrayPtg)arrayList.get(n2);
                ((ArrayPtg)ptg).writeTokenValueBytes(littleEndianByteArrayOutputStream);
            }
        }
        return littleEndianByteArrayOutputStream.getWriteIndex() - n;
    }

    public abstract int getSize();

    public abstract void write(LittleEndianOutput var1);

    public abstract String toFormulaString();

    public String toString() {
        return this.getClass().toString();
    }

    public final void setClass(byte by) {
        if (this.isBaseToken()) {
            throw new RuntimeException("setClass should not be called on a base token");
        }
        this.ptgClass = by;
    }

    public final byte getPtgClass() {
        return this.ptgClass;
    }

    public final char getRVAType() {
        if (this.isBaseToken()) {
            return '.';
        }
        switch (this.ptgClass) {
            case 0: {
                return 'R';
            }
            case 32: {
                return 'V';
            }
            case 64: {
                return 'A';
            }
        }
        throw new RuntimeException("Unknown operand class (" + this.ptgClass + ")");
    }

    public abstract byte getDefaultOperandClass();

    public abstract boolean isBaseToken();

    public static boolean doesFormulaReferToDeletedCell(Ptg[] ptgArray) {
        for (int i = 0; i < ptgArray.length; ++i) {
            if (!Ptg.isDeletedCellRef(ptgArray[i])) continue;
            return true;
        }
        return false;
    }

    private static boolean isDeletedCellRef(Ptg ptg) {
        if (ptg == ErrPtg.REF_INVALID) {
            return true;
        }
        if (ptg instanceof DeletedArea3DPtg) {
            return true;
        }
        if (ptg instanceof DeletedRef3DPtg) {
            return true;
        }
        if (ptg instanceof AreaErrPtg) {
            return true;
        }
        return ptg instanceof RefErrorPtg;
    }
}

