/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.ss.formula.ptg;

import ai.org.apache.poi.ss.formula.ExternSheetReferenceToken;
import ai.org.apache.poi.ss.formula.FormulaRenderingWorkbook;
import ai.org.apache.poi.ss.formula.WorkbookDependentFormula;
import ai.org.apache.poi.ss.formula.ptg.AreaPtgBase;
import ai.org.apache.poi.ss.formula.ptg.ExternSheetNameResolver;
import ai.org.apache.poi.ss.util.AreaReference;
import ai.org.apache.poi.util.LittleEndianInput;
import ai.org.apache.poi.util.LittleEndianOutput;

public final class Area3DPtg
extends AreaPtgBase
implements WorkbookDependentFormula,
ExternSheetReferenceToken {
    public static final byte sid = 59;
    private static final int SIZE = 11;
    private int field_1_index_extern_sheet;

    public Area3DPtg(String string, int n) {
        super(new AreaReference(string));
        this.setExternSheetIndex(n);
    }

    public Area3DPtg(LittleEndianInput littleEndianInput) {
        this.field_1_index_extern_sheet = littleEndianInput.readShort();
        this.readCoordinates(littleEndianInput);
    }

    public Area3DPtg(int n, int n2, int n3, int n4, boolean bl, boolean bl2, boolean bl3, boolean bl4, int n5) {
        super(n, n2, n3, n4, bl, bl2, bl3, bl4);
        this.setExternSheetIndex(n5);
    }

    public Area3DPtg(AreaReference areaReference, int n) {
        super(areaReference);
        this.setExternSheetIndex(n);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getClass().getName());
        stringBuffer.append(" [");
        stringBuffer.append("sheetIx=").append(this.getExternSheetIndex());
        stringBuffer.append(" ! ");
        stringBuffer.append(this.formatReferenceAsString());
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public void write(LittleEndianOutput littleEndianOutput) {
        littleEndianOutput.writeByte(59 + this.getPtgClass());
        littleEndianOutput.writeShort(this.field_1_index_extern_sheet);
        this.writeCoordinates(littleEndianOutput);
    }

    public int getSize() {
        return 11;
    }

    public int getExternSheetIndex() {
        return this.field_1_index_extern_sheet;
    }

    public void setExternSheetIndex(int n) {
        this.field_1_index_extern_sheet = n;
    }

    public String format2DRefAsString() {
        return this.formatReferenceAsString();
    }

    public String toFormulaString(FormulaRenderingWorkbook formulaRenderingWorkbook) {
        return ExternSheetNameResolver.prependSheetName(formulaRenderingWorkbook, this.field_1_index_extern_sheet, this.formatReferenceAsString());
    }

    public String toFormulaString() {
        throw new RuntimeException("3D references need a workbook to determine formula text");
    }
}

