/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.ss.formula.functions;

import ai.org.apache.poi.ss.formula.OperationEvaluationContext;
import ai.org.apache.poi.ss.formula.eval.ErrorEval;
import ai.org.apache.poi.ss.formula.eval.EvaluationException;
import ai.org.apache.poi.ss.formula.eval.NumberEval;
import ai.org.apache.poi.ss.formula.eval.OperandResolver;
import ai.org.apache.poi.ss.formula.eval.ValueEval;
import ai.org.apache.poi.ss.formula.functions.Fixed2ArgFunction;
import ai.org.apache.poi.ss.formula.functions.FreeRefFunction;

public class Quotient
extends Fixed2ArgFunction
implements FreeRefFunction {
    public static final FreeRefFunction instance = new Quotient();

    public ValueEval evaluate(int n, int n2, ValueEval valueEval, ValueEval valueEval2) {
        double d = 0.0;
        try {
            d = OperandResolver.coerceValueToDouble(valueEval);
        }
        catch (EvaluationException evaluationException) {
            return ErrorEval.VALUE_INVALID;
        }
        double d2 = 0.0;
        try {
            d2 = OperandResolver.coerceValueToDouble(valueEval2);
        }
        catch (EvaluationException evaluationException) {
            return ErrorEval.VALUE_INVALID;
        }
        if (d2 == 0.0) {
            return ErrorEval.DIV_ZERO;
        }
        return new NumberEval((int)(d / d2));
    }

    public ValueEval evaluate(ValueEval[] valueEvalArray, OperationEvaluationContext operationEvaluationContext) {
        if (valueEvalArray.length != 2) {
            return ErrorEval.VALUE_INVALID;
        }
        return this.evaluate(operationEvaluationContext.getRowIndex(), operationEvaluationContext.getColumnIndex(), valueEvalArray[0], valueEvalArray[1]);
    }
}

