/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.ss.formula.functions;

import ai.org.apache.poi.ss.formula.eval.BoolEval;
import ai.org.apache.poi.ss.formula.eval.ErrorEval;
import ai.org.apache.poi.ss.formula.eval.EvaluationException;
import ai.org.apache.poi.ss.formula.eval.NumberEval;
import ai.org.apache.poi.ss.formula.eval.OperandResolver;
import ai.org.apache.poi.ss.formula.eval.ValueEval;
import ai.org.apache.poi.ss.formula.functions.Fixed0ArgFunction;
import ai.org.apache.poi.ss.formula.functions.Fixed1ArgFunction;
import ai.org.apache.poi.ss.formula.functions.Fixed2ArgFunction;
import ai.org.apache.poi.ss.formula.functions.Fixed3ArgFunction;
import ai.org.apache.poi.ss.formula.functions.Function;
import ai.org.apache.poi.ss.formula.functions.MathX;
import ai.org.apache.poi.ss.formula.functions.Var1or2ArgFunction;

public abstract class NumericFunction
implements Function {
    static final double ZERO = 0.0;
    static final double TEN = 10.0;
    static final double LOG_10_TO_BASE_e = Math.log(10.0);
    public static final Function ABS = new OneArg(){

        protected double evaluate(double d) {
            return Math.abs(d);
        }
    };
    public static final Function ACOS = new OneArg(){

        protected double evaluate(double d) {
            return Math.acos(d);
        }
    };
    public static final Function ACOSH = new OneArg(){

        protected double evaluate(double d) {
            return MathX.acosh(d);
        }
    };
    public static final Function ASIN = new OneArg(){

        protected double evaluate(double d) {
            return Math.asin(d);
        }
    };
    public static final Function ASINH = new OneArg(){

        protected double evaluate(double d) {
            return MathX.asinh(d);
        }
    };
    public static final Function ATAN = new OneArg(){

        protected double evaluate(double d) {
            return Math.atan(d);
        }
    };
    public static final Function ATANH = new OneArg(){

        protected double evaluate(double d) {
            return MathX.atanh(d);
        }
    };
    public static final Function COS = new OneArg(){

        protected double evaluate(double d) {
            return Math.cos(d);
        }
    };
    public static final Function COSH = new OneArg(){

        protected double evaluate(double d) {
            return MathX.cosh(d);
        }
    };
    public static final Function DEGREES = new OneArg(){

        protected double evaluate(double d) {
            return Math.toDegrees(d);
        }
    };
    static final NumberEval DOLLAR_ARG2_DEFAULT = new NumberEval(2.0);
    public static final Function DOLLAR = new Var1or2ArgFunction(){

        public ValueEval evaluate(int n, int n2, ValueEval valueEval) {
            return this.evaluate(n, n2, valueEval, DOLLAR_ARG2_DEFAULT);
        }

        public ValueEval evaluate(int n, int n2, ValueEval valueEval, ValueEval valueEval2) {
            double d;
            double d2;
            try {
                d2 = NumericFunction.singleOperandEvaluate(valueEval, n, n2);
                d = NumericFunction.singleOperandEvaluate(valueEval2, n, n2);
            }
            catch (EvaluationException evaluationException) {
                return evaluationException.getErrorEval();
            }
            int n3 = (int)d;
            if (n3 > 127) {
                return ErrorEval.VALUE_INVALID;
            }
            return new NumberEval(d2);
        }
    };
    public static final Function EXP = new OneArg(){

        protected double evaluate(double d) {
            return Math.pow(Math.E, d);
        }
    };
    public static final Function FACT = new OneArg(){

        protected double evaluate(double d) {
            return MathX.factorial((int)d);
        }
    };
    public static final Function INT = new OneArg(){

        protected double evaluate(double d) {
            return Math.round(d - 0.5);
        }
    };
    public static final Function LN = new OneArg(){

        protected double evaluate(double d) {
            return Math.log(d);
        }
    };
    public static final Function LOG10 = new OneArg(){

        protected double evaluate(double d) {
            return Math.log(d) / LOG_10_TO_BASE_e;
        }
    };
    public static final Function RADIANS = new OneArg(){

        protected double evaluate(double d) {
            return Math.toRadians(d);
        }
    };
    public static final Function SIGN = new OneArg(){

        protected double evaluate(double d) {
            return MathX.sign(d);
        }
    };
    public static final Function SIN = new OneArg(){

        protected double evaluate(double d) {
            return Math.sin(d);
        }
    };
    public static final Function SINH = new OneArg(){

        protected double evaluate(double d) {
            return MathX.sinh(d);
        }
    };
    public static final Function SQRT = new OneArg(){

        protected double evaluate(double d) {
            return Math.sqrt(d);
        }
    };
    public static final Function TAN = new OneArg(){

        protected double evaluate(double d) {
            return Math.tan(d);
        }
    };
    public static final Function TANH = new OneArg(){

        protected double evaluate(double d) {
            return MathX.tanh(d);
        }
    };
    public static final Function ATAN2 = new TwoArg(){

        protected double evaluate(double d, double d2) throws EvaluationException {
            if (d == 0.0 && d2 == 0.0) {
                throw new EvaluationException(ErrorEval.DIV_ZERO);
            }
            return Math.atan2(d2, d);
        }
    };
    public static final Function CEILING = new TwoArg(){

        protected double evaluate(double d, double d2) {
            return MathX.ceiling(d, d2);
        }
    };
    public static final Function COMBIN = new TwoArg(){

        protected double evaluate(double d, double d2) throws EvaluationException {
            if (d > 2.147483647E9 || d2 > 2.147483647E9) {
                throw new EvaluationException(ErrorEval.NUM_ERROR);
            }
            return MathX.nChooseK((int)d, (int)d2);
        }
    };
    public static final Function FLOOR = new TwoArg(){

        protected double evaluate(double d, double d2) throws EvaluationException {
            if (d2 == 0.0) {
                if (d == 0.0) {
                    return 0.0;
                }
                throw new EvaluationException(ErrorEval.DIV_ZERO);
            }
            return MathX.floor(d, d2);
        }
    };
    public static final Function MOD = new TwoArg(){

        protected double evaluate(double d, double d2) throws EvaluationException {
            if (d2 == 0.0) {
                throw new EvaluationException(ErrorEval.DIV_ZERO);
            }
            return MathX.mod(d, d2);
        }
    };
    public static final Function POWER = new TwoArg(){

        protected double evaluate(double d, double d2) {
            return Math.pow(d, d2);
        }
    };
    public static final Function ROUND = new TwoArg(){

        protected double evaluate(double d, double d2) {
            return MathX.round(d, (int)d2);
        }
    };
    public static final Function ROUNDDOWN = new TwoArg(){

        protected double evaluate(double d, double d2) {
            return MathX.roundDown(d, (int)d2);
        }
    };
    public static final Function ROUNDUP = new TwoArg(){

        protected double evaluate(double d, double d2) {
            return MathX.roundUp(d, (int)d2);
        }
    };
    static final NumberEval TRUNC_ARG2_DEFAULT = new NumberEval(0.0);
    public static final Function TRUNC = new Var1or2ArgFunction(){

        public ValueEval evaluate(int n, int n2, ValueEval valueEval) {
            return this.evaluate(n, n2, valueEval, TRUNC_ARG2_DEFAULT);
        }

        public ValueEval evaluate(int n, int n2, ValueEval valueEval, ValueEval valueEval2) {
            double d;
            try {
                double d2 = NumericFunction.singleOperandEvaluate(valueEval, n, n2);
                double d3 = NumericFunction.singleOperandEvaluate(valueEval2, n, n2);
                double d4 = Math.pow(10.0, d3);
                d = d2 < 0.0 ? -Math.floor(-d2 * d4) / d4 : Math.floor(d2 * d4) / d4;
                NumericFunction.checkValue(d);
            }
            catch (EvaluationException evaluationException) {
                return evaluationException.getErrorEval();
            }
            return new NumberEval(d);
        }
    };
    public static final Function LOG = new Log();
    static final NumberEval PI_EVAL = new NumberEval(Math.PI);
    public static final Function PI = new Fixed0ArgFunction(){

        public ValueEval evaluate(int n, int n2) {
            return PI_EVAL;
        }
    };
    public static final Function RAND = new Fixed0ArgFunction(){

        public ValueEval evaluate(int n, int n2) {
            return new NumberEval(Math.random());
        }
    };
    public static final Function POISSON = new Fixed3ArgFunction(){
        private static final double DEFAULT_RETURN_RESULT = 1.0;
        private final long[] FACTORIALS = new long[]{1L, 1L, 2L, 6L, 24L, 120L, 720L, 5040L, 40320L, 362880L, 3628800L, 39916800L, 479001600L, 6227020800L, 87178291200L, 1307674368000L, 20922789888000L, 355687428096000L, 6402373705728000L, 121645100408832000L, 2432902008176640000L};

        private boolean isDefaultResult(double d, double d2) {
            return d == 0.0 && d2 == 0.0;
        }

        private boolean checkArgument(double d) throws EvaluationException {
            NumericFunction.checkValue(d);
            if (d < 0.0) {
                throw new EvaluationException(ErrorEval.NUM_ERROR);
            }
            return true;
        }

        private double probability(int n, double d) {
            return Math.pow(d, n) * Math.exp(-d) / (double)this.factorial(n);
        }

        private double cumulativeProbability(int n, double d) {
            double d2 = 0.0;
            for (int i = 0; i <= n; ++i) {
                d2 += this.probability(i, d);
            }
            return d2;
        }

        public long factorial(int n) {
            if (n < 0 || n > 20) {
                throw new IllegalArgumentException("Valid argument should be in the range [0..20]");
            }
            return this.FACTORIALS[n];
        }

        public ValueEval evaluate(int n, int n2, ValueEval valueEval, ValueEval valueEval2, ValueEval valueEval3) {
            double d = 0.0;
            double d2 = 0.0;
            boolean bl = ((BoolEval)valueEval3).getBooleanValue();
            double d3 = 0.0;
            try {
                d2 = NumericFunction.singleOperandEvaluate(valueEval, n, n2);
                d = NumericFunction.singleOperandEvaluate(valueEval2, n, n2);
                if (this.isDefaultResult(d2, d)) {
                    return new NumberEval(1.0);
                }
                this.checkArgument(d2);
                this.checkArgument(d);
                d3 = bl ? this.cumulativeProbability((int)d2, d) : this.probability((int)d2, d);
                NumericFunction.checkValue(d3);
            }
            catch (EvaluationException evaluationException) {
                return evaluationException.getErrorEval();
            }
            return new NumberEval(d3);
        }
    };

    protected static final double singleOperandEvaluate(ValueEval valueEval, int n, int n2) throws EvaluationException {
        if (valueEval == null) {
            throw new IllegalArgumentException("arg must not be null");
        }
        ValueEval valueEval2 = OperandResolver.getSingleValue(valueEval, n, n2);
        double d = OperandResolver.coerceValueToDouble(valueEval2);
        NumericFunction.checkValue(d);
        return d;
    }

    public static final void checkValue(double d) throws EvaluationException {
        if (Double.isNaN(d) || Double.isInfinite(d)) {
            throw new EvaluationException(ErrorEval.NUM_ERROR);
        }
    }

    public final ValueEval evaluate(ValueEval[] valueEvalArray, int n, int n2) {
        double d;
        try {
            d = this.eval(valueEvalArray, n, n2);
            NumericFunction.checkValue(d);
        }
        catch (EvaluationException evaluationException) {
            return evaluationException.getErrorEval();
        }
        return new NumberEval(d);
    }

    protected abstract double eval(ValueEval[] var1, int var2, int var3) throws EvaluationException;

    private static final class Log
    extends Var1or2ArgFunction {
        public ValueEval evaluate(int n, int n2, ValueEval valueEval) {
            double d;
            try {
                double d2 = NumericFunction.singleOperandEvaluate(valueEval, n, n2);
                d = Math.log(d2) / LOG_10_TO_BASE_e;
                NumericFunction.checkValue(d);
            }
            catch (EvaluationException evaluationException) {
                return evaluationException.getErrorEval();
            }
            return new NumberEval(d);
        }

        public ValueEval evaluate(int n, int n2, ValueEval valueEval, ValueEval valueEval2) {
            double d;
            try {
                double d2 = NumericFunction.singleOperandEvaluate(valueEval, n, n2);
                double d3 = NumericFunction.singleOperandEvaluate(valueEval2, n, n2);
                double d4 = Math.log(d2);
                double d5 = d3;
                d = d5 == Math.E ? d4 : d4 / Math.log(d5);
                NumericFunction.checkValue(d);
            }
            catch (EvaluationException evaluationException) {
                return evaluationException.getErrorEval();
            }
            return new NumberEval(d);
        }
    }

    public static abstract class TwoArg
    extends Fixed2ArgFunction {
        protected TwoArg() {
        }

        public ValueEval evaluate(int n, int n2, ValueEval valueEval, ValueEval valueEval2) {
            double d;
            try {
                double d2 = NumericFunction.singleOperandEvaluate(valueEval, n, n2);
                double d3 = NumericFunction.singleOperandEvaluate(valueEval2, n, n2);
                d = this.evaluate(d2, d3);
                NumericFunction.checkValue(d);
            }
            catch (EvaluationException evaluationException) {
                return evaluationException.getErrorEval();
            }
            return new NumberEval(d);
        }

        protected abstract double evaluate(double var1, double var3) throws EvaluationException;
    }

    public static abstract class OneArg
    extends Fixed1ArgFunction {
        protected OneArg() {
        }

        public ValueEval evaluate(int n, int n2, ValueEval valueEval) {
            double d;
            try {
                double d2 = NumericFunction.singleOperandEvaluate(valueEval, n, n2);
                d = this.evaluate(d2);
                NumericFunction.checkValue(d);
            }
            catch (EvaluationException evaluationException) {
                return evaluationException.getErrorEval();
            }
            return new NumberEval(d);
        }

        protected final double eval(ValueEval[] valueEvalArray, int n, int n2) throws EvaluationException {
            if (valueEvalArray.length != 1) {
                throw new EvaluationException(ErrorEval.VALUE_INVALID);
            }
            double d = NumericFunction.singleOperandEvaluate(valueEvalArray[0], n, n2);
            return this.evaluate(d);
        }

        protected abstract double evaluate(double var1) throws EvaluationException;
    }
}

