/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.ss.formula.functions;

import ai.org.apache.poi.ss.formula.ThreeDEval;
import ai.org.apache.poi.ss.formula.TwoDEval;
import ai.org.apache.poi.ss.formula.eval.BlankEval;
import ai.org.apache.poi.ss.formula.eval.BoolEval;
import ai.org.apache.poi.ss.formula.eval.ErrorEval;
import ai.org.apache.poi.ss.formula.eval.EvaluationException;
import ai.org.apache.poi.ss.formula.eval.NumberEval;
import ai.org.apache.poi.ss.formula.eval.NumericValueEval;
import ai.org.apache.poi.ss.formula.eval.OperandResolver;
import ai.org.apache.poi.ss.formula.eval.RefEval;
import ai.org.apache.poi.ss.formula.eval.StringValueEval;
import ai.org.apache.poi.ss.formula.eval.ValueEval;
import ai.org.apache.poi.ss.formula.functions.Function;

public abstract class MultiOperandNumericFunction
implements Function {
    private final boolean _isReferenceBoolCounted;
    private final boolean _isBlankCounted;
    static final double[] EMPTY_DOUBLE_ARRAY = new double[0];
    private static final int DEFAULT_MAX_NUM_OPERANDS = 30;

    protected MultiOperandNumericFunction(boolean bl, boolean bl2) {
        this._isReferenceBoolCounted = bl;
        this._isBlankCounted = bl2;
    }

    public final ValueEval evaluate(ValueEval[] valueEvalArray, int n, int n2) {
        double d;
        try {
            double[] dArray = this.getNumberArray(valueEvalArray);
            d = this.evaluate(dArray);
        }
        catch (EvaluationException evaluationException) {
            return evaluationException.getErrorEval();
        }
        if (Double.isNaN(d) || Double.isInfinite(d)) {
            return ErrorEval.NUM_ERROR;
        }
        return new NumberEval(d);
    }

    protected abstract double evaluate(double[] var1) throws EvaluationException;

    protected int getMaxNumOperands() {
        return 30;
    }

    protected final double[] getNumberArray(ValueEval[] valueEvalArray) throws EvaluationException {
        if (valueEvalArray.length > this.getMaxNumOperands()) {
            throw EvaluationException.invalidValue();
        }
        DoubleList doubleList = new DoubleList();
        int n = valueEvalArray.length;
        for (int i = 0; i < n; ++i) {
            this.collectValues(valueEvalArray[i], doubleList);
        }
        return doubleList.toArray();
    }

    public boolean isSubtotalCounted() {
        return true;
    }

    private void collectValues(ValueEval valueEval, DoubleList doubleList) throws EvaluationException {
        if (valueEval instanceof ThreeDEval) {
            ThreeDEval threeDEval = (ThreeDEval)valueEval;
            for (int i = threeDEval.getFirstSheetIndex(); i <= threeDEval.getLastSheetIndex(); ++i) {
                int n = threeDEval.getWidth();
                int n2 = threeDEval.getHeight();
                for (int j = 0; j < n2; ++j) {
                    for (int k = 0; k < n; ++k) {
                        ValueEval valueEval2 = threeDEval.getValue(i, j, k);
                        if (!this.isSubtotalCounted() && threeDEval.isSubTotal(j, k)) continue;
                        this.collectValue(valueEval2, true, doubleList);
                    }
                }
            }
            return;
        }
        if (valueEval instanceof TwoDEval) {
            TwoDEval twoDEval = (TwoDEval)valueEval;
            int n = twoDEval.getWidth();
            int n3 = twoDEval.getHeight();
            for (int i = 0; i < n3; ++i) {
                for (int j = 0; j < n; ++j) {
                    ValueEval valueEval3 = twoDEval.getValue(i, j);
                    if (!this.isSubtotalCounted() && twoDEval.isSubTotal(i, j)) continue;
                    this.collectValue(valueEval3, true, doubleList);
                }
            }
            return;
        }
        if (valueEval instanceof RefEval) {
            RefEval refEval = (RefEval)valueEval;
            for (int i = refEval.getFirstSheetIndex(); i <= refEval.getLastSheetIndex(); ++i) {
                this.collectValue(refEval.getInnerValueEval(i), true, doubleList);
            }
            return;
        }
        this.collectValue(valueEval, false, doubleList);
    }

    private void collectValue(ValueEval valueEval, boolean bl, DoubleList doubleList) throws EvaluationException {
        if (valueEval == null) {
            throw new IllegalArgumentException("ve must not be null");
        }
        if (valueEval instanceof BoolEval) {
            if (!bl || this._isReferenceBoolCounted) {
                BoolEval boolEval = (BoolEval)valueEval;
                doubleList.add(boolEval.getNumberValue());
            }
            return;
        }
        if (valueEval instanceof NumericValueEval) {
            NumericValueEval numericValueEval = (NumericValueEval)valueEval;
            doubleList.add(numericValueEval.getNumberValue());
            return;
        }
        if (valueEval instanceof StringValueEval) {
            if (bl) {
                return;
            }
            String string = ((StringValueEval)valueEval).getStringValue();
            Double d = OperandResolver.parseDouble(string);
            if (d == null) {
                throw new EvaluationException(ErrorEval.VALUE_INVALID);
            }
            doubleList.add(d);
            return;
        }
        if (valueEval instanceof ErrorEval) {
            throw new EvaluationException((ErrorEval)valueEval);
        }
        if (valueEval == BlankEval.instance) {
            if (this._isBlankCounted) {
                doubleList.add(0.0);
            }
            return;
        }
        throw new RuntimeException("Invalid ValueEval type passed for conversion: (" + valueEval.getClass() + ")");
    }

    private static class DoubleList {
        private double[] _array = new double[8];
        private int _count = 0;

        public double[] toArray() {
            if (this._count < 1) {
                return EMPTY_DOUBLE_ARRAY;
            }
            double[] dArray = new double[this._count];
            System.arraycopy(this._array, 0, dArray, 0, this._count);
            return dArray;
        }

        private void ensureCapacity(int n) {
            if (n > this._array.length) {
                int n2 = n * 3 / 2;
                double[] dArray = new double[n2];
                System.arraycopy(this._array, 0, dArray, 0, this._count);
                this._array = dArray;
            }
        }

        public void add(double d) {
            this.ensureCapacity(this._count + 1);
            this._array[this._count] = d;
            ++this._count;
        }
    }
}

