/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.ss.formula.functions;

import ai.org.apache.poi.ss.formula.eval.ErrorEval;
import ai.org.apache.poi.ss.formula.eval.EvaluationException;
import ai.org.apache.poi.ss.formula.functions.MultiOperandNumericFunction;

public class Mirr
extends MultiOperandNumericFunction {
    public Mirr() {
        super(false, false);
    }

    protected int getMaxNumOperands() {
        return 3;
    }

    protected double evaluate(double[] dArray) throws EvaluationException {
        double d = dArray[dArray.length - 1];
        double d2 = dArray[dArray.length - 2];
        double[] dArray2 = new double[dArray.length - 2];
        System.arraycopy(dArray, 0, dArray2, 0, dArray2.length);
        boolean bl = true;
        for (double d3 : dArray2) {
            bl &= d3 < 0.0;
        }
        if (bl) {
            return -1.0;
        }
        boolean bl2 = true;
        for (double d4 : dArray2) {
            bl2 &= d4 > 0.0;
        }
        if (bl2) {
            throw new EvaluationException(ErrorEval.DIV_ZERO);
        }
        return Mirr.mirr(dArray2, d, d2);
    }

    private static double mirr(double[] dArray, double d, double d2) {
        double d3 = 0.0;
        int n = dArray.length - 1;
        double d4 = 0.0;
        double d5 = 0.0;
        int n2 = 0;
        for (double d6 : dArray) {
            if (!(d6 < 0.0)) continue;
            d4 += d6 / Math.pow(1.0 + d + d2, n2++);
        }
        for (double d6 : dArray) {
            if (!(d6 > 0.0)) continue;
            d5 += d6 * Math.pow(1.0 + d, n - n2++);
        }
        if (d5 != 0.0 && d4 != 0.0) {
            d3 = Math.pow(-d5 / d4, 1.0 / (double)n) - 1.0;
        }
        return d3;
    }
}

