/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.ss.formula.functions;

import ai.org.apache.poi.ss.util.NumberToTextConverter;
import java.math.BigDecimal;
import java.math.RoundingMode;

final class MathX {
    private MathX() {
    }

    public static double round(double d, int n) {
        double d2 = Double.isNaN(d) || Double.isInfinite(d) ? Double.NaN : new BigDecimal(NumberToTextConverter.toText(d)).setScale(n, RoundingMode.HALF_UP).doubleValue();
        return d2;
    }

    public static double roundUp(double d, int n) {
        double d2 = Double.isNaN(d) || Double.isInfinite(d) ? Double.NaN : BigDecimal.valueOf(d).setScale(n, RoundingMode.UP).doubleValue();
        return d2;
    }

    public static double roundDown(double d, int n) {
        double d2 = Double.isNaN(d) || Double.isInfinite(d) ? Double.NaN : BigDecimal.valueOf(d).setScale(n, RoundingMode.DOWN).doubleValue();
        return d2;
    }

    public static short sign(double d) {
        return (short)(d == 0.0 ? 0 : (d < 0.0 ? -1 : 1));
    }

    public static double average(double[] dArray) {
        double d = 0.0;
        double d2 = 0.0;
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            d2 += dArray[i];
        }
        d = d2 / (double)dArray.length;
        return d;
    }

    public static double sum(double[] dArray) {
        double d = 0.0;
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            d += dArray[i];
        }
        return d;
    }

    public static double sumsq(double[] dArray) {
        double d = 0.0;
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            d += dArray[i] * dArray[i];
        }
        return d;
    }

    public static double product(double[] dArray) {
        double d = 0.0;
        if (dArray != null && dArray.length > 0) {
            d = 1.0;
            int n = dArray.length;
            for (int i = 0; i < n; ++i) {
                d *= dArray[i];
            }
        }
        return d;
    }

    public static double min(double[] dArray) {
        double d = Double.POSITIVE_INFINITY;
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            d = Math.min(d, dArray[i]);
        }
        return d;
    }

    public static double max(double[] dArray) {
        double d = Double.NEGATIVE_INFINITY;
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            d = Math.max(d, dArray[i]);
        }
        return d;
    }

    public static double floor(double d, double d2) {
        double d3 = d < 0.0 && d2 > 0.0 || d > 0.0 && d2 < 0.0 || d2 == 0.0 && d != 0.0 ? Double.NaN : (d == 0.0 || d2 == 0.0 ? 0.0 : Math.floor(d / d2) * d2);
        return d3;
    }

    public static double ceiling(double d, double d2) {
        double d3 = d < 0.0 && d2 > 0.0 || d > 0.0 && d2 < 0.0 ? Double.NaN : (d == 0.0 || d2 == 0.0 ? 0.0 : Math.ceil(d / d2) * d2);
        return d3;
    }

    public static double factorial(int n) {
        double d = 1.0;
        if (n >= 0) {
            if (n <= 170) {
                for (int i = 1; i <= n; ++i) {
                    d *= (double)i;
                }
            } else {
                d = Double.POSITIVE_INFINITY;
            }
        } else {
            d = Double.NaN;
        }
        return d;
    }

    public static double mod(double d, double d2) {
        double d3 = 0.0;
        d3 = d2 == 0.0 ? Double.NaN : (MathX.sign(d) == MathX.sign(d2) ? d % d2 : (d % d2 + d2) % d2);
        return d3;
    }

    public static double acosh(double d) {
        return Math.log(Math.sqrt(Math.pow(d, 2.0) - 1.0) + d);
    }

    public static double asinh(double d) {
        return Math.log(Math.sqrt(d * d + 1.0) + d);
    }

    public static double atanh(double d) {
        return Math.log((1.0 + d) / (1.0 - d)) / 2.0;
    }

    public static double cosh(double d) {
        double d2 = Math.pow(Math.E, d);
        double d3 = Math.pow(Math.E, -d);
        return (d2 + d3) / 2.0;
    }

    public static double sinh(double d) {
        double d2 = Math.pow(Math.E, d);
        double d3 = Math.pow(Math.E, -d);
        return (d2 - d3) / 2.0;
    }

    public static double tanh(double d) {
        double d2 = Math.pow(Math.E, d);
        double d3 = Math.pow(Math.E, -d);
        return (d2 - d3) / (d2 + d3);
    }

    public static double nChooseK(int n, int n2) {
        double d = 1.0;
        if (n < 0 || n2 < 0 || n < n2) {
            d = Double.NaN;
        } else {
            int n3;
            int n4 = Math.min(n - n2, n2);
            for (int i = n3 = Math.max(n - n2, n2); i < n; ++i) {
                d *= (double)(i + 1);
            }
            d /= MathX.factorial(n4);
        }
        return d;
    }
}

