/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.ss.formula.functions;

import ai.org.apache.poi.ss.formula.TwoDEval;
import ai.org.apache.poi.ss.formula.eval.EvaluationException;
import ai.org.apache.poi.ss.formula.eval.OperandResolver;
import ai.org.apache.poi.ss.formula.eval.ValueEval;
import ai.org.apache.poi.ss.formula.functions.LookupUtils;
import ai.org.apache.poi.ss.formula.functions.Var2or3ArgFunction;

public final class Lookup
extends Var2or3ArgFunction {
    public ValueEval evaluate(int n, int n2, ValueEval valueEval, ValueEval valueEval2) {
        throw new RuntimeException("Two arg version of LOOKUP not supported yet");
    }

    public ValueEval evaluate(int n, int n2, ValueEval valueEval, ValueEval valueEval2, ValueEval valueEval3) {
        try {
            ValueEval valueEval4 = OperandResolver.getSingleValue(valueEval, n, n2);
            TwoDEval twoDEval = LookupUtils.resolveTableArrayArg(valueEval2);
            TwoDEval twoDEval2 = LookupUtils.resolveTableArrayArg(valueEval3);
            LookupUtils.ValueVector valueVector = Lookup.createVector(twoDEval);
            LookupUtils.ValueVector valueVector2 = Lookup.createVector(twoDEval2);
            if (valueVector.getSize() > valueVector2.getSize()) {
                throw new RuntimeException("Lookup vector and result vector of differing sizes not supported yet");
            }
            int n3 = LookupUtils.lookupIndexOfValue(valueEval4, valueVector, true);
            return valueVector2.getItem(n3);
        }
        catch (EvaluationException evaluationException) {
            return evaluationException.getErrorEval();
        }
    }

    private static LookupUtils.ValueVector createVector(TwoDEval twoDEval) {
        LookupUtils.ValueVector valueVector = LookupUtils.createVector(twoDEval);
        if (valueVector != null) {
            return valueVector;
        }
        throw new RuntimeException("non-vector lookup or result areas not supported yet");
    }
}

