/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.ss.formula.functions;

import ai.org.apache.poi.ss.formula.eval.BoolEval;
import ai.org.apache.poi.ss.formula.eval.ErrorEval;
import ai.org.apache.poi.ss.formula.eval.EvaluationException;
import ai.org.apache.poi.ss.formula.eval.NumberEval;
import ai.org.apache.poi.ss.formula.eval.ValueEval;
import ai.org.apache.poi.ss.formula.functions.FinanceLib;
import ai.org.apache.poi.ss.formula.functions.Function;
import ai.org.apache.poi.ss.formula.functions.Function3Arg;
import ai.org.apache.poi.ss.formula.functions.Function4Arg;
import ai.org.apache.poi.ss.formula.functions.NumericFunction;

public abstract class FinanceFunction
implements Function3Arg,
Function4Arg {
    private static final ValueEval DEFAULT_ARG3 = NumberEval.ZERO;
    private static final ValueEval DEFAULT_ARG4 = BoolEval.FALSE;
    public static final Function FV = new FinanceFunction(){

        protected double evaluate(double d, double d2, double d3, double d4, boolean bl) {
            return FinanceLib.fv(d, d2, d3, d4, bl);
        }
    };
    public static final Function NPER = new FinanceFunction(){

        protected double evaluate(double d, double d2, double d3, double d4, boolean bl) {
            return FinanceLib.nper(d, d2, d3, d4, bl);
        }
    };
    public static final Function PMT = new FinanceFunction(){

        protected double evaluate(double d, double d2, double d3, double d4, boolean bl) {
            return FinanceLib.pmt(d, d2, d3, d4, bl);
        }
    };
    public static final Function PV = new FinanceFunction(){

        protected double evaluate(double d, double d2, double d3, double d4, boolean bl) {
            return FinanceLib.pv(d, d2, d3, d4, bl);
        }
    };

    protected FinanceFunction() {
    }

    public ValueEval evaluate(int n, int n2, ValueEval valueEval, ValueEval valueEval2, ValueEval valueEval3) {
        return this.evaluate(n, n2, valueEval, valueEval2, valueEval3, DEFAULT_ARG3);
    }

    public ValueEval evaluate(int n, int n2, ValueEval valueEval, ValueEval valueEval2, ValueEval valueEval3, ValueEval valueEval4) {
        return this.evaluate(n, n2, valueEval, valueEval2, valueEval3, valueEval4, DEFAULT_ARG4);
    }

    public ValueEval evaluate(int n, int n2, ValueEval valueEval, ValueEval valueEval2, ValueEval valueEval3, ValueEval valueEval4, ValueEval valueEval5) {
        double d;
        try {
            double d2 = NumericFunction.singleOperandEvaluate(valueEval, n, n2);
            double d3 = NumericFunction.singleOperandEvaluate(valueEval2, n, n2);
            double d4 = NumericFunction.singleOperandEvaluate(valueEval3, n, n2);
            double d5 = NumericFunction.singleOperandEvaluate(valueEval4, n, n2);
            double d6 = NumericFunction.singleOperandEvaluate(valueEval5, n, n2);
            d = this.evaluate(d2, d3, d4, d5, d6 != 0.0);
            NumericFunction.checkValue(d);
        }
        catch (EvaluationException evaluationException) {
            return evaluationException.getErrorEval();
        }
        return new NumberEval(d);
    }

    public ValueEval evaluate(ValueEval[] valueEvalArray, int n, int n2) {
        switch (valueEvalArray.length) {
            case 3: {
                return this.evaluate(n, n2, valueEvalArray[0], valueEvalArray[1], valueEvalArray[2], DEFAULT_ARG3, DEFAULT_ARG4);
            }
            case 4: {
                return this.evaluate(n, n2, valueEvalArray[0], valueEvalArray[1], valueEvalArray[2], valueEvalArray[3], DEFAULT_ARG4);
            }
            case 5: {
                return this.evaluate(n, n2, valueEvalArray[0], valueEvalArray[1], valueEvalArray[2], valueEvalArray[3], valueEvalArray[4]);
            }
        }
        return ErrorEval.VALUE_INVALID;
    }

    protected double evaluate(double[] dArray) throws EvaluationException {
        double d = 0.0;
        double d2 = 0.0;
        switch (dArray.length) {
            case 5: {
                d2 = dArray[4];
            }
            case 4: {
                d = dArray[3];
            }
            case 3: {
                break;
            }
            default: {
                throw new IllegalStateException("Wrong number of arguments");
            }
        }
        return this.evaluate(dArray[0], dArray[1], dArray[2], d, d2 != 0.0);
    }

    protected abstract double evaluate(double var1, double var3, double var5, double var7, boolean var9) throws EvaluationException;
}

