/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.ss.formula.functions;

public class Finance {
    public static double pmt(double d, int n, double d2, double d3, int n2) {
        double d4 = -d * (d2 * Math.pow(1.0 + d, n) + d3) / ((1.0 + d * (double)n2) * (Math.pow(1.0 + d, n) - 1.0));
        return d4;
    }

    public static double pmt(double d, int n, double d2, double d3) {
        return Finance.pmt(d, n, d2, d3, 0);
    }

    public static double pmt(double d, int n, double d2) {
        return Finance.pmt(d, n, d2, 0.0);
    }

    public static double ipmt(double d, int n, int n2, double d2, double d3, int n3) {
        double d4 = Finance.fv(d, n - 1, Finance.pmt(d, n2, d2, d3, n3), d2, n3) * d;
        if (n3 == 1) {
            d4 /= 1.0 + d;
        }
        return d4;
    }

    public static double ipmt(double d, int n, int n2, double d2, double d3) {
        return Finance.ipmt(d, n, n2, d2, d3, 0);
    }

    public static double ipmt(double d, int n, int n2, double d2) {
        return Finance.ipmt(d, n, n2, d2, 0.0);
    }

    public static double ppmt(double d, int n, int n2, double d2, double d3, int n3) {
        return Finance.pmt(d, n2, d2, d3, n3) - Finance.ipmt(d, n, n2, d2, d3, n3);
    }

    public static double ppmt(double d, int n, int n2, double d2, double d3) {
        return Finance.pmt(d, n2, d2, d3) - Finance.ipmt(d, n, n2, d2, d3);
    }

    public static double ppmt(double d, int n, int n2, double d2) {
        return Finance.pmt(d, n2, d2) - Finance.ipmt(d, n, n2, d2);
    }

    public static double fv(double d, int n, double d2, double d3, int n2) {
        double d4 = -(d3 * Math.pow(1.0 + d, n) + d2 * (1.0 + d * (double)n2) * (Math.pow(1.0 + d, n) - 1.0) / d);
        return d4;
    }

    public static double fv(double d, int n, double d2, double d3) {
        return Finance.fv(d, n, d2, d3, 0);
    }
}

