/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.ss.formula.functions;

import ai.org.apache.poi.ss.formula.OperationEvaluationContext;
import ai.org.apache.poi.ss.formula.eval.ErrorEval;
import ai.org.apache.poi.ss.formula.eval.EvaluationException;
import ai.org.apache.poi.ss.formula.eval.NumberEval;
import ai.org.apache.poi.ss.formula.eval.ValueEval;
import ai.org.apache.poi.ss.formula.functions.FreeRefFunction;
import ai.org.apache.poi.ss.formula.functions.NumericFunction;
import ai.org.apache.poi.ss.usermodel.DateUtil;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

public class EOMonth
implements FreeRefFunction {
    public static final FreeRefFunction instance = new EOMonth();

    public ValueEval evaluate(ValueEval[] valueEvalArray, OperationEvaluationContext operationEvaluationContext) {
        if (valueEvalArray.length != 2) {
            return ErrorEval.VALUE_INVALID;
        }
        try {
            double d = NumericFunction.singleOperandEvaluate(valueEvalArray[0], operationEvaluationContext.getRowIndex(), operationEvaluationContext.getColumnIndex());
            int n = (int)NumericFunction.singleOperandEvaluate(valueEvalArray[1], operationEvaluationContext.getRowIndex(), operationEvaluationContext.getColumnIndex());
            if (d >= 0.0 && d < 1.0) {
                d = 1.0;
            }
            Date date = DateUtil.getJavaDate(d, false);
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            gregorianCalendar.setTime(date);
            gregorianCalendar.set(gregorianCalendar.get(1), gregorianCalendar.get(2), gregorianCalendar.get(5), 0, 0, 0);
            gregorianCalendar.set(14, 0);
            ((Calendar)gregorianCalendar).add(2, n + 1);
            gregorianCalendar.set(5, 1);
            ((Calendar)gregorianCalendar).add(5, -1);
            return new NumberEval(DateUtil.getExcelDate(gregorianCalendar.getTime()));
        }
        catch (EvaluationException evaluationException) {
            return evaluationException.getErrorEval();
        }
    }
}

