/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.ss.formula.functions;

import ai.org.apache.poi.ss.formula.OperationEvaluationContext;
import ai.org.apache.poi.ss.formula.eval.ErrorEval;
import ai.org.apache.poi.ss.formula.eval.EvaluationException;
import ai.org.apache.poi.ss.formula.eval.OperandResolver;
import ai.org.apache.poi.ss.formula.eval.StringEval;
import ai.org.apache.poi.ss.formula.eval.ValueEval;
import ai.org.apache.poi.ss.formula.functions.FreeRefFunction;
import ai.org.apache.poi.ss.formula.functions.Var1or2ArgFunction;

public class Dec2Bin
extends Var1or2ArgFunction
implements FreeRefFunction {
    public static final FreeRefFunction instance = new Dec2Bin();
    private static final long MIN_VALUE = Long.parseLong("-512");
    private static final long MAX_VALUE = Long.parseLong("512");
    private static final int DEFAULT_PLACES_VALUE = 10;

    public ValueEval evaluate(int n, int n2, ValueEval valueEval, ValueEval valueEval2) {
        Object object;
        int n3;
        ValueEval valueEval3;
        try {
            valueEval3 = OperandResolver.getSingleValue(valueEval, n, n2);
        }
        catch (EvaluationException evaluationException) {
            return evaluationException.getErrorEval();
        }
        String string = OperandResolver.coerceValueToString(valueEval3);
        Double d = OperandResolver.parseDouble(string);
        if (d == null) {
            return ErrorEval.VALUE_INVALID;
        }
        if (d.longValue() < MIN_VALUE || d.longValue() > MAX_VALUE) {
            return ErrorEval.NUM_ERROR;
        }
        if (d < 0.0 || valueEval2 == null) {
            n3 = 10;
        } else {
            try {
                object = OperandResolver.getSingleValue(valueEval2, n, n2);
            }
            catch (EvaluationException evaluationException) {
                return evaluationException.getErrorEval();
            }
            String string2 = OperandResolver.coerceValueToString((ValueEval)object);
            Double d2 = OperandResolver.parseDouble(string2);
            if (d2 == null) {
                return ErrorEval.VALUE_INVALID;
            }
            n3 = d2.intValue();
            if (n3 < 0 || n3 == 0) {
                return ErrorEval.NUM_ERROR;
            }
        }
        object = Integer.toBinaryString(d.intValue());
        if (((String)object).length() > 10) {
            object = ((String)object).substring(((String)object).length() - 10, ((String)object).length());
        }
        if (((String)object).length() > n3) {
            return ErrorEval.NUM_ERROR;
        }
        return new StringEval((String)object);
    }

    public ValueEval evaluate(int n, int n2, ValueEval valueEval) {
        return this.evaluate(n, n2, valueEval, null);
    }

    public ValueEval evaluate(ValueEval[] valueEvalArray, OperationEvaluationContext operationEvaluationContext) {
        if (valueEvalArray.length == 1) {
            return this.evaluate(operationEvaluationContext.getRowIndex(), operationEvaluationContext.getColumnIndex(), valueEvalArray[0]);
        }
        if (valueEvalArray.length == 2) {
            return this.evaluate(operationEvaluationContext.getRowIndex(), operationEvaluationContext.getColumnIndex(), valueEvalArray[0], valueEvalArray[1]);
        }
        return ErrorEval.VALUE_INVALID;
    }
}

