/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.ss.formula.functions;

import ai.org.apache.poi.ss.formula.ThreeDEval;
import ai.org.apache.poi.ss.formula.TwoDEval;
import ai.org.apache.poi.ss.formula.eval.RefEval;
import ai.org.apache.poi.ss.formula.eval.ValueEval;

final class CountUtils {
    private CountUtils() {
    }

    public static int countMatchingCellsInArea(ThreeDEval threeDEval, I_MatchPredicate i_MatchPredicate) {
        int n = 0;
        for (int i = threeDEval.getFirstSheetIndex(); i <= threeDEval.getLastSheetIndex(); ++i) {
            int n2 = threeDEval.getHeight();
            int n3 = threeDEval.getWidth();
            for (int j = 0; j < n2; ++j) {
                for (int k = 0; k < n3; ++k) {
                    I_MatchAreaPredicate i_MatchAreaPredicate;
                    ValueEval valueEval = threeDEval.getValue(i, j, k);
                    if (i_MatchPredicate instanceof I_MatchAreaPredicate && !(i_MatchAreaPredicate = (I_MatchAreaPredicate)i_MatchPredicate).matches(threeDEval, j, k) || !i_MatchPredicate.matches(valueEval)) continue;
                    ++n;
                }
            }
        }
        return n;
    }

    public static int countMatchingCellsInRef(RefEval refEval, I_MatchPredicate i_MatchPredicate) {
        int n = 0;
        for (int i = refEval.getFirstSheetIndex(); i <= refEval.getLastSheetIndex(); ++i) {
            ValueEval valueEval = refEval.getInnerValueEval(i);
            if (!i_MatchPredicate.matches(valueEval)) continue;
            ++n;
        }
        return n;
    }

    public static int countArg(ValueEval valueEval, I_MatchPredicate i_MatchPredicate) {
        if (valueEval == null) {
            throw new IllegalArgumentException("eval must not be null");
        }
        if (valueEval instanceof ThreeDEval) {
            return CountUtils.countMatchingCellsInArea((ThreeDEval)valueEval, i_MatchPredicate);
        }
        if (valueEval instanceof TwoDEval) {
            throw new IllegalArgumentException("Count requires 3D Evals, 2D ones aren't supported");
        }
        if (valueEval instanceof RefEval) {
            return CountUtils.countMatchingCellsInRef((RefEval)valueEval, i_MatchPredicate);
        }
        return i_MatchPredicate.matches(valueEval) ? 1 : 0;
    }

    public static interface I_MatchAreaPredicate
    extends I_MatchPredicate {
        public boolean matches(TwoDEval var1, int var2, int var3);
    }

    public static interface I_MatchPredicate {
        public boolean matches(ValueEval var1);
    }
}

