/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.ss.formula.eval.forked;

import ai.org.apache.poi.hssf.usermodel.HSSFEvaluationWorkbook;
import ai.org.apache.poi.hssf.usermodel.HSSFWorkbook;
import ai.org.apache.poi.ss.formula.CollaboratingWorkbooksEnvironment;
import ai.org.apache.poi.ss.formula.EvaluationCell;
import ai.org.apache.poi.ss.formula.EvaluationWorkbook;
import ai.org.apache.poi.ss.formula.IStabilityClassifier;
import ai.org.apache.poi.ss.formula.WorkbookEvaluator;
import ai.org.apache.poi.ss.formula.eval.BoolEval;
import ai.org.apache.poi.ss.formula.eval.ErrorEval;
import ai.org.apache.poi.ss.formula.eval.NumberEval;
import ai.org.apache.poi.ss.formula.eval.StringEval;
import ai.org.apache.poi.ss.formula.eval.ValueEval;
import ai.org.apache.poi.ss.formula.eval.forked.ForkedEvaluationCell;
import ai.org.apache.poi.ss.formula.eval.forked.ForkedEvaluationWorkbook;
import ai.org.apache.poi.ss.formula.udf.UDFFinder;
import ai.org.apache.poi.ss.usermodel.Workbook;

public final class ForkedEvaluator {
    private WorkbookEvaluator _evaluator;
    private ForkedEvaluationWorkbook _sewb;

    private ForkedEvaluator(EvaluationWorkbook evaluationWorkbook, IStabilityClassifier iStabilityClassifier, UDFFinder uDFFinder) {
        this._sewb = new ForkedEvaluationWorkbook(evaluationWorkbook);
        this._evaluator = new WorkbookEvaluator(this._sewb, iStabilityClassifier, uDFFinder);
    }

    private static EvaluationWorkbook createEvaluationWorkbook(Workbook workbook) {
        if (workbook instanceof HSSFWorkbook) {
            return HSSFEvaluationWorkbook.create((HSSFWorkbook)workbook);
        }
        throw new IllegalArgumentException("Unexpected workbook type (" + workbook.getClass().getName() + ")");
    }

    public static ForkedEvaluator create(Workbook workbook, IStabilityClassifier iStabilityClassifier) {
        return ForkedEvaluator.create(workbook, iStabilityClassifier, null);
    }

    public static ForkedEvaluator create(Workbook workbook, IStabilityClassifier iStabilityClassifier, UDFFinder uDFFinder) {
        return new ForkedEvaluator(ForkedEvaluator.createEvaluationWorkbook(workbook), iStabilityClassifier, uDFFinder);
    }

    public void updateCell(String string, int n, int n2, ValueEval valueEval) {
        ForkedEvaluationCell forkedEvaluationCell = this._sewb.getOrCreateUpdatableCell(string, n, n2);
        forkedEvaluationCell.setValue(valueEval);
        this._evaluator.notifyUpdateCell(forkedEvaluationCell);
    }

    public void copyUpdatedCells(Workbook workbook) {
        this._sewb.copyUpdatedCells(workbook);
    }

    public ValueEval evaluate(String string, int n, int n2) {
        EvaluationCell evaluationCell = this._sewb.getEvaluationCell(string, n, n2);
        switch (evaluationCell.getCellType()) {
            case 4: {
                return BoolEval.valueOf(evaluationCell.getBooleanCellValue());
            }
            case 5: {
                return ErrorEval.valueOf(evaluationCell.getErrorCellValue());
            }
            case 2: {
                return this._evaluator.evaluate(evaluationCell);
            }
            case 0: {
                return new NumberEval(evaluationCell.getNumericCellValue());
            }
            case 1: {
                return new StringEval(evaluationCell.getStringCellValue());
            }
            case 3: {
                return null;
            }
        }
        throw new IllegalStateException("Bad cell type (" + evaluationCell.getCellType() + ")");
    }

    public static void setupEnvironment(String[] stringArray, ForkedEvaluator[] forkedEvaluatorArray) {
        WorkbookEvaluator[] workbookEvaluatorArray = new WorkbookEvaluator[forkedEvaluatorArray.length];
        for (int i = 0; i < workbookEvaluatorArray.length; ++i) {
            workbookEvaluatorArray[i] = forkedEvaluatorArray[i]._evaluator;
        }
        CollaboratingWorkbooksEnvironment.setup(stringArray, workbookEvaluatorArray);
    }
}

