/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.ss.formula.eval;

import ai.org.apache.poi.ss.formula.eval.BlankEval;
import ai.org.apache.poi.ss.formula.eval.BoolEval;
import ai.org.apache.poi.ss.formula.eval.EvaluationException;
import ai.org.apache.poi.ss.formula.eval.NumberEval;
import ai.org.apache.poi.ss.formula.eval.OperandResolver;
import ai.org.apache.poi.ss.formula.eval.StringEval;
import ai.org.apache.poi.ss.formula.eval.ValueEval;
import ai.org.apache.poi.ss.formula.functions.Fixed2ArgFunction;
import ai.org.apache.poi.ss.formula.functions.Function;
import ai.org.apache.poi.ss.util.NumberComparer;

public abstract class RelationalOperationEval
extends Fixed2ArgFunction {
    public static final Function EqualEval = new RelationalOperationEval(){

        protected boolean convertComparisonResult(int n) {
            return n == 0;
        }
    };
    public static final Function GreaterEqualEval = new RelationalOperationEval(){

        protected boolean convertComparisonResult(int n) {
            return n >= 0;
        }
    };
    public static final Function GreaterThanEval = new RelationalOperationEval(){

        protected boolean convertComparisonResult(int n) {
            return n > 0;
        }
    };
    public static final Function LessEqualEval = new RelationalOperationEval(){

        protected boolean convertComparisonResult(int n) {
            return n <= 0;
        }
    };
    public static final Function LessThanEval = new RelationalOperationEval(){

        protected boolean convertComparisonResult(int n) {
            return n < 0;
        }
    };
    public static final Function NotEqualEval = new RelationalOperationEval(){

        protected boolean convertComparisonResult(int n) {
            return n != 0;
        }
    };

    protected abstract boolean convertComparisonResult(int var1);

    public ValueEval evaluate(int n, int n2, ValueEval valueEval, ValueEval valueEval2) {
        ValueEval valueEval3;
        ValueEval valueEval4;
        try {
            valueEval4 = OperandResolver.getSingleValue(valueEval, n, n2);
            valueEval3 = OperandResolver.getSingleValue(valueEval2, n, n2);
        }
        catch (EvaluationException evaluationException) {
            return evaluationException.getErrorEval();
        }
        int n3 = RelationalOperationEval.doCompare(valueEval4, valueEval3);
        boolean bl = this.convertComparisonResult(n3);
        return BoolEval.valueOf(bl);
    }

    private static int doCompare(ValueEval valueEval, ValueEval valueEval2) {
        if (valueEval == BlankEval.instance) {
            return RelationalOperationEval.compareBlank(valueEval2);
        }
        if (valueEval2 == BlankEval.instance) {
            return -RelationalOperationEval.compareBlank(valueEval);
        }
        if (valueEval instanceof BoolEval) {
            if (valueEval2 instanceof BoolEval) {
                BoolEval boolEval = (BoolEval)valueEval;
                BoolEval boolEval2 = (BoolEval)valueEval2;
                if (boolEval.getBooleanValue() == boolEval2.getBooleanValue()) {
                    return 0;
                }
                return boolEval.getBooleanValue() ? 1 : -1;
            }
            return 1;
        }
        if (valueEval2 instanceof BoolEval) {
            return -1;
        }
        if (valueEval instanceof StringEval) {
            if (valueEval2 instanceof StringEval) {
                StringEval stringEval = (StringEval)valueEval;
                StringEval stringEval2 = (StringEval)valueEval2;
                return stringEval.getStringValue().compareToIgnoreCase(stringEval2.getStringValue());
            }
            return 1;
        }
        if (valueEval2 instanceof StringEval) {
            return -1;
        }
        if (valueEval instanceof NumberEval && valueEval2 instanceof NumberEval) {
            NumberEval numberEval = (NumberEval)valueEval;
            NumberEval numberEval2 = (NumberEval)valueEval2;
            return NumberComparer.compare(numberEval.getNumberValue(), numberEval2.getNumberValue());
        }
        throw new IllegalArgumentException("Bad operand types (" + valueEval.getClass().getName() + "), (" + valueEval2.getClass().getName() + ")");
    }

    private static int compareBlank(ValueEval valueEval) {
        if (valueEval == BlankEval.instance) {
            return 0;
        }
        if (valueEval instanceof BoolEval) {
            BoolEval boolEval = (BoolEval)valueEval;
            return boolEval.getBooleanValue() ? -1 : 0;
        }
        if (valueEval instanceof NumberEval) {
            NumberEval numberEval = (NumberEval)valueEval;
            return NumberComparer.compare(0.0, numberEval.getNumberValue());
        }
        if (valueEval instanceof StringEval) {
            StringEval stringEval = (StringEval)valueEval;
            return stringEval.getStringValue().length() < 1 ? 0 : -1;
        }
        throw new IllegalArgumentException("bad value class (" + valueEval.getClass().getName() + ")");
    }
}

