/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.ss.formula.eval;

import ai.org.apache.poi.ss.formula.eval.NumericValueEval;
import ai.org.apache.poi.ss.formula.eval.StringValueEval;
import ai.org.apache.poi.ss.formula.ptg.IntPtg;
import ai.org.apache.poi.ss.formula.ptg.NumberPtg;
import ai.org.apache.poi.ss.formula.ptg.Ptg;
import ai.org.apache.poi.ss.util.NumberToTextConverter;

public final class NumberEval
implements NumericValueEval,
StringValueEval {
    public static final NumberEval ZERO = new NumberEval(0.0);
    private final double _value;
    private String _stringValue;

    public NumberEval(Ptg ptg) {
        if (ptg == null) {
            throw new IllegalArgumentException("ptg must not be null");
        }
        if (ptg instanceof IntPtg) {
            this._value = ((IntPtg)ptg).getValue();
        } else if (ptg instanceof NumberPtg) {
            this._value = ((NumberPtg)ptg).getValue();
        } else {
            throw new IllegalArgumentException("bad argument type (" + ptg.getClass().getName() + ")");
        }
    }

    public NumberEval(double d) {
        this._value = d;
    }

    public double getNumberValue() {
        return this._value;
    }

    public String getStringValue() {
        if (this._stringValue == null) {
            this._stringValue = NumberToTextConverter.toText(this._value);
        }
        return this._stringValue;
    }

    public final String toString() {
        StringBuffer stringBuffer = new StringBuffer(64);
        stringBuffer.append(this.getClass().getName()).append(" [");
        stringBuffer.append(this.getStringValue());
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

