/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.ss.formula.eval;

import ai.org.apache.poi.ss.formula.atp.AnalysisToolPak;
import ai.org.apache.poi.ss.formula.eval.NotImplementedException;
import ai.org.apache.poi.ss.formula.function.FunctionMetadata;
import ai.org.apache.poi.ss.formula.function.FunctionMetadataRegistry;
import ai.org.apache.poi.ss.formula.functions.Address;
import ai.org.apache.poi.ss.formula.functions.AggregateFunction;
import ai.org.apache.poi.ss.formula.functions.BooleanFunction;
import ai.org.apache.poi.ss.formula.functions.CalendarFieldFunction;
import ai.org.apache.poi.ss.formula.functions.Choose;
import ai.org.apache.poi.ss.formula.functions.Code;
import ai.org.apache.poi.ss.formula.functions.Column;
import ai.org.apache.poi.ss.formula.functions.Columns;
import ai.org.apache.poi.ss.formula.functions.Count;
import ai.org.apache.poi.ss.formula.functions.Counta;
import ai.org.apache.poi.ss.formula.functions.Countblank;
import ai.org.apache.poi.ss.formula.functions.Countif;
import ai.org.apache.poi.ss.formula.functions.DateFunc;
import ai.org.apache.poi.ss.formula.functions.Days360;
import ai.org.apache.poi.ss.formula.functions.Errortype;
import ai.org.apache.poi.ss.formula.functions.Even;
import ai.org.apache.poi.ss.formula.functions.FinanceFunction;
import ai.org.apache.poi.ss.formula.functions.Fixed;
import ai.org.apache.poi.ss.formula.functions.Function;
import ai.org.apache.poi.ss.formula.functions.Hlookup;
import ai.org.apache.poi.ss.formula.functions.Hyperlink;
import ai.org.apache.poi.ss.formula.functions.IPMT;
import ai.org.apache.poi.ss.formula.functions.IfFunc;
import ai.org.apache.poi.ss.formula.functions.Index;
import ai.org.apache.poi.ss.formula.functions.Intercept;
import ai.org.apache.poi.ss.formula.functions.Irr;
import ai.org.apache.poi.ss.formula.functions.LogicalFunction;
import ai.org.apache.poi.ss.formula.functions.Lookup;
import ai.org.apache.poi.ss.formula.functions.Match;
import ai.org.apache.poi.ss.formula.functions.MinaMaxa;
import ai.org.apache.poi.ss.formula.functions.Mirr;
import ai.org.apache.poi.ss.formula.functions.Mode;
import ai.org.apache.poi.ss.formula.functions.Na;
import ai.org.apache.poi.ss.formula.functions.NotImplementedFunction;
import ai.org.apache.poi.ss.formula.functions.Now;
import ai.org.apache.poi.ss.formula.functions.Npv;
import ai.org.apache.poi.ss.formula.functions.NumericFunction;
import ai.org.apache.poi.ss.formula.functions.Odd;
import ai.org.apache.poi.ss.formula.functions.Offset;
import ai.org.apache.poi.ss.formula.functions.PPMT;
import ai.org.apache.poi.ss.formula.functions.Rank;
import ai.org.apache.poi.ss.formula.functions.Rate;
import ai.org.apache.poi.ss.formula.functions.Replace;
import ai.org.apache.poi.ss.formula.functions.Rept;
import ai.org.apache.poi.ss.formula.functions.Roman;
import ai.org.apache.poi.ss.formula.functions.RowFunc;
import ai.org.apache.poi.ss.formula.functions.Rows;
import ai.org.apache.poi.ss.formula.functions.Slope;
import ai.org.apache.poi.ss.formula.functions.Substitute;
import ai.org.apache.poi.ss.formula.functions.Subtotal;
import ai.org.apache.poi.ss.formula.functions.Sumif;
import ai.org.apache.poi.ss.formula.functions.Sumproduct;
import ai.org.apache.poi.ss.formula.functions.Sumx2my2;
import ai.org.apache.poi.ss.formula.functions.Sumx2py2;
import ai.org.apache.poi.ss.formula.functions.Sumxmy2;
import ai.org.apache.poi.ss.formula.functions.T;
import ai.org.apache.poi.ss.formula.functions.TextFunction;
import ai.org.apache.poi.ss.formula.functions.TimeFunc;
import ai.org.apache.poi.ss.formula.functions.Today;
import ai.org.apache.poi.ss.formula.functions.Value;
import ai.org.apache.poi.ss.formula.functions.Vlookup;
import ai.org.apache.poi.ss.formula.functions.WeekdayFunc;
import java.util.Collection;
import java.util.Collections;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FunctionEval {
    protected static final Function[] functions = FunctionEval.produceFunctions();

    private static Function[] produceFunctions() {
        Function[] functionArray = new Function[368];
        functionArray[0] = new Count();
        functionArray[1] = new IfFunc();
        functionArray[2] = LogicalFunction.ISNA;
        functionArray[3] = LogicalFunction.ISERROR;
        functionArray[4] = AggregateFunction.SUM;
        functionArray[5] = AggregateFunction.AVERAGE;
        functionArray[6] = AggregateFunction.MIN;
        functionArray[7] = AggregateFunction.MAX;
        functionArray[8] = new RowFunc();
        functionArray[9] = new Column();
        functionArray[10] = new Na();
        functionArray[11] = new Npv();
        functionArray[12] = AggregateFunction.STDEV;
        functionArray[13] = NumericFunction.DOLLAR;
        functionArray[14] = new Fixed();
        functionArray[15] = NumericFunction.SIN;
        functionArray[16] = NumericFunction.COS;
        functionArray[17] = NumericFunction.TAN;
        functionArray[18] = NumericFunction.ATAN;
        functionArray[19] = NumericFunction.PI;
        functionArray[20] = NumericFunction.SQRT;
        functionArray[21] = NumericFunction.EXP;
        functionArray[22] = NumericFunction.LN;
        functionArray[23] = NumericFunction.LOG10;
        functionArray[24] = NumericFunction.ABS;
        functionArray[25] = NumericFunction.INT;
        functionArray[26] = NumericFunction.SIGN;
        functionArray[27] = NumericFunction.ROUND;
        functionArray[28] = new Lookup();
        functionArray[29] = new Index();
        functionArray[30] = new Rept();
        functionArray[31] = TextFunction.MID;
        functionArray[32] = TextFunction.LEN;
        functionArray[33] = new Value();
        functionArray[34] = BooleanFunction.TRUE;
        functionArray[35] = BooleanFunction.FALSE;
        functionArray[36] = BooleanFunction.AND;
        functionArray[37] = BooleanFunction.OR;
        functionArray[38] = BooleanFunction.NOT;
        functionArray[39] = NumericFunction.MOD;
        functionArray[46] = AggregateFunction.VAR;
        functionArray[48] = TextFunction.TEXT;
        functionArray[56] = FinanceFunction.PV;
        functionArray[57] = FinanceFunction.FV;
        functionArray[58] = FinanceFunction.NPER;
        functionArray[59] = FinanceFunction.PMT;
        functionArray[60] = new Rate();
        functionArray[61] = new Mirr();
        functionArray[62] = new Irr();
        functionArray[63] = NumericFunction.RAND;
        functionArray[64] = new Match();
        functionArray[65] = DateFunc.instance;
        functionArray[66] = new TimeFunc();
        functionArray[67] = CalendarFieldFunction.DAY;
        functionArray[68] = CalendarFieldFunction.MONTH;
        functionArray[69] = CalendarFieldFunction.YEAR;
        functionArray[70] = WeekdayFunc.instance;
        functionArray[71] = CalendarFieldFunction.HOUR;
        functionArray[72] = CalendarFieldFunction.MINUTE;
        functionArray[73] = CalendarFieldFunction.SECOND;
        functionArray[74] = new Now();
        functionArray[76] = new Rows();
        functionArray[77] = new Columns();
        functionArray[82] = TextFunction.SEARCH;
        functionArray[78] = new Offset();
        functionArray[82] = TextFunction.SEARCH;
        functionArray[97] = NumericFunction.ATAN2;
        functionArray[98] = NumericFunction.ASIN;
        functionArray[99] = NumericFunction.ACOS;
        functionArray[100] = new Choose();
        functionArray[101] = new Hlookup();
        functionArray[102] = new Vlookup();
        functionArray[105] = LogicalFunction.ISREF;
        functionArray[109] = NumericFunction.LOG;
        functionArray[111] = TextFunction.CHAR;
        functionArray[112] = TextFunction.LOWER;
        functionArray[113] = TextFunction.UPPER;
        functionArray[114] = TextFunction.PROPER;
        functionArray[115] = TextFunction.LEFT;
        functionArray[116] = TextFunction.RIGHT;
        functionArray[117] = TextFunction.EXACT;
        functionArray[118] = TextFunction.TRIM;
        functionArray[119] = new Replace();
        functionArray[120] = new Substitute();
        functionArray[121] = new Code();
        functionArray[124] = TextFunction.FIND;
        functionArray[127] = LogicalFunction.ISTEXT;
        functionArray[128] = LogicalFunction.ISNUMBER;
        functionArray[129] = LogicalFunction.ISBLANK;
        functionArray[130] = new T();
        functionArray[148] = null;
        functionArray[162] = TextFunction.CLEAN;
        functionArray[167] = new IPMT();
        functionArray[168] = new PPMT();
        functionArray[169] = new Counta();
        functionArray[183] = AggregateFunction.PRODUCT;
        functionArray[184] = NumericFunction.FACT;
        functionArray[190] = LogicalFunction.ISNONTEXT;
        functionArray[194] = AggregateFunction.VARP;
        functionArray[197] = NumericFunction.TRUNC;
        functionArray[198] = LogicalFunction.ISLOGICAL;
        functionArray[212] = NumericFunction.ROUNDUP;
        functionArray[213] = NumericFunction.ROUNDDOWN;
        functionArray[216] = new Rank();
        functionArray[219] = new Address();
        functionArray[220] = new Days360();
        functionArray[221] = new Today();
        functionArray[227] = AggregateFunction.MEDIAN;
        functionArray[228] = new Sumproduct();
        functionArray[229] = NumericFunction.SINH;
        functionArray[230] = NumericFunction.COSH;
        functionArray[231] = NumericFunction.TANH;
        functionArray[232] = NumericFunction.ASINH;
        functionArray[233] = NumericFunction.ACOSH;
        functionArray[234] = NumericFunction.ATANH;
        functionArray[255] = null;
        functionArray[261] = new Errortype();
        functionArray[269] = AggregateFunction.AVEDEV;
        functionArray[276] = NumericFunction.COMBIN;
        functionArray[279] = new Even();
        functionArray[285] = NumericFunction.FLOOR;
        functionArray[288] = NumericFunction.CEILING;
        functionArray[298] = new Odd();
        functionArray[300] = NumericFunction.POISSON;
        functionArray[303] = new Sumxmy2();
        functionArray[304] = new Sumx2my2();
        functionArray[305] = new Sumx2py2();
        functionArray[311] = new Intercept();
        functionArray[315] = new Slope();
        functionArray[318] = AggregateFunction.DEVSQ;
        functionArray[321] = AggregateFunction.SUMSQ;
        functionArray[325] = AggregateFunction.LARGE;
        functionArray[326] = AggregateFunction.SMALL;
        functionArray[328] = AggregateFunction.PERCENTILE;
        functionArray[330] = new Mode();
        functionArray[336] = TextFunction.CONCATENATE;
        functionArray[337] = NumericFunction.POWER;
        functionArray[342] = NumericFunction.RADIANS;
        functionArray[343] = NumericFunction.DEGREES;
        functionArray[344] = new Subtotal();
        functionArray[345] = new Sumif();
        functionArray[346] = new Countif();
        functionArray[347] = new Countblank();
        functionArray[354] = new Roman();
        functionArray[359] = new Hyperlink();
        functionArray[362] = MinaMaxa.MAXA;
        functionArray[363] = MinaMaxa.MINA;
        for (int i = 0; i < functionArray.length; ++i) {
            FunctionMetadata functionMetadata;
            Function function = functionArray[i];
            if (function != null || (functionMetadata = FunctionMetadataRegistry.getFunctionByIndex(i)) == null) continue;
            functionArray[i] = new NotImplementedFunction(functionMetadata.getName());
        }
        return functionArray;
    }

    public static Function getBasicFunction(int n) {
        switch (n) {
            case 148: 
            case 255: {
                return null;
            }
        }
        Function function = functions[n];
        if (function == null) {
            throw new NotImplementedException("FuncIx=" + n);
        }
        return function;
    }

    public static void registerFunction(String string, Function function) {
        FunctionMetadata functionMetadata = FunctionMetadataRegistry.getFunctionByName(string);
        if (functionMetadata == null) {
            if (AnalysisToolPak.isATPFunction(string)) {
                throw new IllegalArgumentException(string + " is a function from the Excel Analysis Toolpack. " + "Use AnalysisToolpack.registerFunction(String name, FreeRefFunction func) instead.");
            }
            throw new IllegalArgumentException("Unknown function: " + string);
        }
        int n = functionMetadata.getIndex();
        if (!(functions[n] instanceof NotImplementedFunction)) {
            throw new IllegalArgumentException("POI already implememts " + string + ". You cannot override POI's implementations of Excel functions");
        }
        FunctionEval.functions[n] = function;
    }

    public static Collection<String> getSupportedFunctionNames() {
        TreeSet<String> treeSet = new TreeSet<String>();
        for (int i = 0; i < functions.length; ++i) {
            Function function = functions[i];
            FunctionMetadata functionMetadata = FunctionMetadataRegistry.getFunctionByIndex(i);
            if (function == null || function instanceof NotImplementedFunction) continue;
            treeSet.add(functionMetadata.getName());
        }
        treeSet.add("INDIRECT");
        return Collections.unmodifiableCollection(treeSet);
    }

    public static Collection<String> getNotSupportedFunctionNames() {
        TreeSet<String> treeSet = new TreeSet<String>();
        for (int i = 0; i < functions.length; ++i) {
            Function function = functions[i];
            if (function == null || !(function instanceof NotImplementedFunction)) continue;
            FunctionMetadata functionMetadata = FunctionMetadataRegistry.getFunctionByIndex(i);
            treeSet.add(functionMetadata.getName());
        }
        treeSet.remove("INDIRECT");
        return Collections.unmodifiableCollection(treeSet);
    }

    private static final class FunctionID {
        public static final int IF = 1;
        public static final int SUM = 4;
        public static final int OFFSET = 78;
        public static final int CHOOSE = 100;
        public static final int INDIRECT = 148;
        public static final int EXTERNAL_FUNC = 255;

        private FunctionID() {
        }
    }
}

