/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.ss.formula.constant;

import ai.org.apache.poi.ss.formula.constant.ErrorConstant;
import ai.org.apache.poi.util.LittleEndianInput;
import ai.org.apache.poi.util.LittleEndianOutput;
import ai.org.apache.poi.util.StringUtil;

public final class ConstantValueParser {
    private static final int TYPE_EMPTY = 0;
    private static final int TYPE_NUMBER = 1;
    private static final int TYPE_STRING = 2;
    private static final int TYPE_BOOLEAN = 4;
    private static final int TYPE_ERROR_CODE = 16;
    private static final int TRUE_ENCODING = 1;
    private static final int FALSE_ENCODING = 0;
    private static final Object EMPTY_REPRESENTATION = null;

    private ConstantValueParser() {
    }

    public static Object[] parse(LittleEndianInput littleEndianInput, int n) {
        Object[] objectArray = new Object[n];
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray[i] = ConstantValueParser.readAConstantValue(littleEndianInput);
        }
        return objectArray;
    }

    private static Object readAConstantValue(LittleEndianInput littleEndianInput) {
        byte by = littleEndianInput.readByte();
        switch (by) {
            case 0: {
                littleEndianInput.readLong();
                return EMPTY_REPRESENTATION;
            }
            case 1: {
                return new Double(littleEndianInput.readDouble());
            }
            case 2: {
                return StringUtil.readUnicodeString(littleEndianInput);
            }
            case 4: {
                return ConstantValueParser.readBoolean(littleEndianInput);
            }
            case 16: {
                int n = littleEndianInput.readUShort();
                littleEndianInput.readUShort();
                littleEndianInput.readInt();
                return ErrorConstant.valueOf(n);
            }
        }
        throw new RuntimeException("Unknown grbit value (" + by + ")");
    }

    private static Object readBoolean(LittleEndianInput littleEndianInput) {
        byte by = (byte)littleEndianInput.readLong();
        switch (by) {
            case 0: {
                return Boolean.FALSE;
            }
            case 1: {
                return Boolean.TRUE;
            }
        }
        throw new RuntimeException("unexpected boolean encoding (" + by + ")");
    }

    public static int getEncodedSize(Object[] objectArray) {
        int n = objectArray.length * 1;
        for (int i = 0; i < objectArray.length; ++i) {
            n += ConstantValueParser.getEncodedSize(objectArray[i]);
        }
        return n;
    }

    private static int getEncodedSize(Object object) {
        if (object == EMPTY_REPRESENTATION) {
            return 8;
        }
        Class<?> clazz = object.getClass();
        if (clazz == Boolean.class || clazz == Double.class || clazz == ErrorConstant.class) {
            return 8;
        }
        String string = (String)object;
        return StringUtil.getEncodedSize(string);
    }

    public static void encode(LittleEndianOutput littleEndianOutput, Object[] objectArray) {
        for (int i = 0; i < objectArray.length; ++i) {
            ConstantValueParser.encodeSingleValue(littleEndianOutput, objectArray[i]);
        }
    }

    private static void encodeSingleValue(LittleEndianOutput littleEndianOutput, Object object) {
        if (object == EMPTY_REPRESENTATION) {
            littleEndianOutput.writeByte(0);
            littleEndianOutput.writeLong(0L);
            return;
        }
        if (object instanceof Boolean) {
            Boolean bl = (Boolean)object;
            littleEndianOutput.writeByte(4);
            long l = bl != false ? 1L : 0L;
            littleEndianOutput.writeLong(l);
            return;
        }
        if (object instanceof Double) {
            Double d = (Double)object;
            littleEndianOutput.writeByte(1);
            littleEndianOutput.writeDouble(d);
            return;
        }
        if (object instanceof String) {
            String string = (String)object;
            littleEndianOutput.writeByte(2);
            StringUtil.writeUnicodeString(littleEndianOutput, string);
            return;
        }
        if (object instanceof ErrorConstant) {
            ErrorConstant errorConstant = (ErrorConstant)object;
            littleEndianOutput.writeByte(16);
            long l = errorConstant.getErrorCode();
            littleEndianOutput.writeLong(l);
            return;
        }
        throw new IllegalStateException("Unexpected value type (" + object.getClass().getName() + "'");
    }
}

