/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.ss.formula.atp;

import ai.org.apache.poi.ss.usermodel.DateUtil;
import java.util.Calendar;
import java.util.Date;

public class WorkdayCalculator {
    public static final WorkdayCalculator instance = new WorkdayCalculator();

    private WorkdayCalculator() {
    }

    public int calculateWorkdays(double d, double d2, double[] dArray) {
        int n = this.pastDaysOfWeek(d, d2, 7);
        int n2 = this.pastDaysOfWeek(d, d2, 1);
        int n3 = this.calculateNonWeekendHolidays(d, d2, dArray);
        return (int)(d2 - d + 1.0) - n - n2 - n3;
    }

    public Date calculateWorkdays(double d, int n, double[] dArray) {
        Date date = DateUtil.getJavaDate(d);
        int n2 = n < 0 ? -1 : 1;
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        double d2 = DateUtil.getExcelDate(calendar.getTime());
        while (n != 0) {
            calendar.add(6, n2);
            if (calendar.get(7) == 7 || calendar.get(7) == 1 || this.isHoliday(d2 += (double)n2, dArray)) continue;
            n -= n2;
        }
        return calendar.getTime();
    }

    protected int pastDaysOfWeek(double d, double d2, int n) {
        int n2 = 0;
        int n3 = (int)Math.floor(d2 > d ? d2 : d);
        for (int i = (int)Math.floor(d < d2 ? d : d2); i <= n3; ++i) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(DateUtil.getJavaDate(i));
            if (calendar.get(7) != n) continue;
            ++n2;
        }
        return d < d2 ? n2 : -n2;
    }

    protected int calculateNonWeekendHolidays(double d, double d2, double[] dArray) {
        int n = 0;
        double d3 = d < d2 ? d : d2;
        double d4 = d2 > d ? d2 : d;
        for (int i = 0; i < dArray.length; ++i) {
            if (!this.isInARange(d3, d4, dArray[i]) || this.isWeekend(dArray[i])) continue;
            ++n;
        }
        return d < d2 ? n : -n;
    }

    protected boolean isWeekend(double d) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(DateUtil.getJavaDate(d));
        return calendar.get(7) == 7 || calendar.get(7) == 1;
    }

    protected boolean isHoliday(double d, double[] dArray) {
        for (int i = 0; i < dArray.length; ++i) {
            if (Math.round(dArray[i]) != Math.round(d)) continue;
            return true;
        }
        return false;
    }

    protected int isNonWorkday(double d, double[] dArray) {
        return this.isWeekend(d) || this.isHoliday(d, dArray) ? 1 : 0;
    }

    protected boolean isInARange(double d, double d2, double d3) {
        return d3 >= d && d3 <= d2;
    }
}

