/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.ss.formula;

import ai.org.apache.poi.ss.formula.PlainValueCellCacheEntry;
import java.util.HashMap;
import java.util.Map;

final class PlainCellCache {
    private Map<Loc, PlainValueCellCacheEntry> _plainValueEntriesByLoc = new HashMap<Loc, PlainValueCellCacheEntry>();

    public void put(Loc loc, PlainValueCellCacheEntry plainValueCellCacheEntry) {
        this._plainValueEntriesByLoc.put(loc, plainValueCellCacheEntry);
    }

    public void clear() {
        this._plainValueEntriesByLoc.clear();
    }

    public PlainValueCellCacheEntry get(Loc loc) {
        return this._plainValueEntriesByLoc.get(loc);
    }

    public void remove(Loc loc) {
        this._plainValueEntriesByLoc.remove(loc);
    }

    public static final class Loc {
        private final long _bookSheetColumn;
        private final int _rowIndex;

        public Loc(int n, int n2, int n3, int n4) {
            this._bookSheetColumn = Loc.toBookSheetColumn(n, n2, n4);
            this._rowIndex = n3;
        }

        public static long toBookSheetColumn(int n, int n2, int n3) {
            return (((long)n & 0xFFFFL) << 48) + (((long)n2 & 0xFFFFL) << 32) + (((long)n3 & 0xFFFFL) << 0);
        }

        public Loc(long l, int n) {
            this._bookSheetColumn = l;
            this._rowIndex = n;
        }

        public int hashCode() {
            return (int)(this._bookSheetColumn ^ this._bookSheetColumn >>> 32) + 17 * this._rowIndex;
        }

        public boolean equals(Object object) {
            assert (object instanceof Loc) : "these package-private cache key instances are only compared to themselves";
            Loc loc = (Loc)object;
            return this._bookSheetColumn == loc._bookSheetColumn && this._rowIndex == loc._rowIndex;
        }

        public int getRowIndex() {
            return this._rowIndex;
        }

        public int getColumnIndex() {
            return (int)(this._bookSheetColumn & 0xFFFFL);
        }

        public int getSheetIndex() {
            return (int)(this._bookSheetColumn >> 32 & 0xFFFFL);
        }

        public int getBookIndex() {
            return (int)(this._bookSheetColumn >> 48 & 0xFFFFL);
        }
    }
}

