/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.ss.formula;

import ai.org.apache.poi.ss.formula.CellCacheEntry;
import ai.org.apache.poi.ss.formula.FormulaUsedBlankCellSet;
import ai.org.apache.poi.ss.formula.IEvaluationListener;
import ai.org.apache.poi.ss.formula.eval.ValueEval;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

final class FormulaCellCacheEntry
extends CellCacheEntry {
    private CellCacheEntry[] _sensitiveInputCells;
    private FormulaUsedBlankCellSet _usedBlankCellGroup;

    public boolean isInputSensitive() {
        if (this._sensitiveInputCells != null && this._sensitiveInputCells.length > 0) {
            return true;
        }
        return this._usedBlankCellGroup == null ? false : !this._usedBlankCellGroup.isEmpty();
    }

    public void setSensitiveInputCells(CellCacheEntry[] cellCacheEntryArray) {
        this.changeConsumingCells(cellCacheEntryArray == null ? CellCacheEntry.EMPTY_ARRAY : cellCacheEntryArray);
        this._sensitiveInputCells = cellCacheEntryArray;
    }

    public void clearFormulaEntry() {
        CellCacheEntry[] cellCacheEntryArray = this._sensitiveInputCells;
        if (cellCacheEntryArray != null) {
            for (int i = cellCacheEntryArray.length - 1; i >= 0; --i) {
                cellCacheEntryArray[i].clearConsumingCell(this);
            }
        }
        this._sensitiveInputCells = null;
        this.clearValue();
    }

    private void changeConsumingCells(CellCacheEntry[] cellCacheEntryArray) {
        int n;
        Set set;
        int n2;
        CellCacheEntry[] cellCacheEntryArray2 = this._sensitiveInputCells;
        int n3 = cellCacheEntryArray.length;
        for (n2 = 0; n2 < n3; ++n2) {
            cellCacheEntryArray[n2].addConsumingCell(this);
        }
        if (cellCacheEntryArray2 == null) {
            return;
        }
        n2 = cellCacheEntryArray2.length;
        if (n2 < 1) {
            return;
        }
        if (n3 < 1) {
            set = Collections.emptySet();
        } else {
            set = new HashSet(n3 * 3 / 2);
            for (n = 0; n < n3; ++n) {
                set.add(cellCacheEntryArray[n]);
            }
        }
        for (n = 0; n < n2; ++n) {
            CellCacheEntry cellCacheEntry = cellCacheEntryArray2[n];
            if (set.contains(cellCacheEntry)) continue;
            cellCacheEntry.clearConsumingCell(this);
        }
    }

    public void updateFormulaResult(ValueEval valueEval, CellCacheEntry[] cellCacheEntryArray, FormulaUsedBlankCellSet formulaUsedBlankCellSet) {
        this.updateValue(valueEval);
        this.setSensitiveInputCells(cellCacheEntryArray);
        this._usedBlankCellGroup = formulaUsedBlankCellSet;
    }

    public void notifyUpdatedBlankCell(FormulaUsedBlankCellSet.BookSheetKey bookSheetKey, int n, int n2, IEvaluationListener iEvaluationListener) {
        if (this._usedBlankCellGroup != null && this._usedBlankCellGroup.containsCell(bookSheetKey, n, n2)) {
            this.clearFormulaEntry();
            this.recurseClearCachedFormulaResults(iEvaluationListener);
        }
    }
}

