/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.ss.formula;

import ai.org.apache.poi.ss.formula.CellCacheEntry;
import ai.org.apache.poi.ss.formula.CellEvaluationFrame;
import ai.org.apache.poi.ss.formula.EvaluationCache;
import ai.org.apache.poi.ss.formula.FormulaCellCacheEntry;
import ai.org.apache.poi.ss.formula.PlainValueCellCacheEntry;
import ai.org.apache.poi.ss.formula.eval.BlankEval;
import ai.org.apache.poi.ss.formula.eval.ErrorEval;
import ai.org.apache.poi.ss.formula.eval.ValueEval;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

final class EvaluationTracker {
    private final List<CellEvaluationFrame> _evaluationFrames;
    private final Set<FormulaCellCacheEntry> _currentlyEvaluatingCells;
    private final EvaluationCache _cache;

    public EvaluationTracker(EvaluationCache evaluationCache) {
        this._cache = evaluationCache;
        this._evaluationFrames = new ArrayList<CellEvaluationFrame>();
        this._currentlyEvaluatingCells = new HashSet<FormulaCellCacheEntry>();
    }

    public boolean startEvaluate(FormulaCellCacheEntry formulaCellCacheEntry) {
        if (formulaCellCacheEntry == null) {
            throw new IllegalArgumentException("cellLoc must not be null");
        }
        if (this._currentlyEvaluatingCells.contains(formulaCellCacheEntry)) {
            return false;
        }
        this._currentlyEvaluatingCells.add(formulaCellCacheEntry);
        this._evaluationFrames.add(new CellEvaluationFrame(formulaCellCacheEntry));
        return true;
    }

    public void updateCacheResult(ValueEval valueEval) {
        int n = this._evaluationFrames.size();
        if (n < 1) {
            throw new IllegalStateException("Call to endEvaluate without matching call to startEvaluate");
        }
        CellEvaluationFrame cellEvaluationFrame = this._evaluationFrames.get(n - 1);
        if (valueEval == ErrorEval.CIRCULAR_REF_ERROR && n > 1) {
            return;
        }
        cellEvaluationFrame.updateFormulaResult(valueEval);
    }

    public void endEvaluate(CellCacheEntry cellCacheEntry) {
        CellEvaluationFrame cellEvaluationFrame;
        int n = this._evaluationFrames.size();
        if (n < 1) {
            throw new IllegalStateException("Call to endEvaluate without matching call to startEvaluate");
        }
        if (cellCacheEntry != (cellEvaluationFrame = this._evaluationFrames.get(--n)).getCCE()) {
            throw new IllegalStateException("Wrong cell specified. ");
        }
        this._evaluationFrames.remove(n);
        this._currentlyEvaluatingCells.remove(cellCacheEntry);
    }

    public void acceptFormulaDependency(CellCacheEntry cellCacheEntry) {
        int n = this._evaluationFrames.size() - 1;
        if (n >= 0) {
            CellEvaluationFrame cellEvaluationFrame = this._evaluationFrames.get(n);
            cellEvaluationFrame.addSensitiveInputCell(cellCacheEntry);
        }
    }

    public void acceptPlainValueDependency(int n, int n2, int n3, int n4, ValueEval valueEval) {
        int n5 = this._evaluationFrames.size() - 1;
        if (n5 >= 0) {
            CellEvaluationFrame cellEvaluationFrame = this._evaluationFrames.get(n5);
            if (valueEval == BlankEval.instance) {
                cellEvaluationFrame.addUsedBlankCell(n, n2, n3, n4);
            } else {
                PlainValueCellCacheEntry plainValueCellCacheEntry = this._cache.getPlainValueEntry(n, n2, n3, n4, valueEval);
                cellEvaluationFrame.addSensitiveInputCell(plainValueCellCacheEntry);
            }
        }
    }
}

