/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.ss.format;

public class SimpleFraction {
    private final int denominator;
    private final int numerator;

    public static SimpleFraction buildFractionExactDenominator(double d, int n) {
        int n2 = (int)Math.round(d * (double)n);
        return new SimpleFraction(n2, n);
    }

    public static SimpleFraction buildFractionMaxDenominator(double d, int n) {
        return SimpleFraction.buildFractionMaxDenominator(d, 0.0, n, 100);
    }

    private static SimpleFraction buildFractionMaxDenominator(double d, double d2, int n, int n2) {
        long l;
        long l2;
        long l3 = Integer.MAX_VALUE;
        double d3 = d;
        long l4 = (long)Math.floor(d3);
        if (l4 > l3) {
            throw new IllegalArgumentException("Overflow trying to convert " + d + " to fraction (" + l4 + "/" + 1L + ")");
        }
        if (Math.abs((double)l4 - d) < d2) {
            return new SimpleFraction((int)l4, 1);
        }
        long l5 = 1L;
        long l6 = 0L;
        long l7 = l4;
        long l8 = 1L;
        int n3 = 0;
        boolean bl = false;
        do {
            ++n3;
            double d4 = 1.0 / (d3 - (double)l4);
            long l9 = (long)Math.floor(d4);
            l2 = l9 * l7 + l5;
            l = l9 * l8 + l6;
            if (d2 == 0.0 && n > 0 && Math.abs(l) > (long)n && Math.abs(l8) < (long)n) {
                return new SimpleFraction((int)l7, (int)l8);
            }
            if (l2 > l3 || l > l3) {
                throw new RuntimeException("Overflow trying to convert " + d + " to fraction (" + l2 + "/" + l + ")");
            }
            double d5 = (double)l2 / (double)l;
            if (n3 < n2 && Math.abs(d5 - d) > d2 && l < (long)n) {
                l5 = l7;
                l7 = l2;
                l6 = l8;
                l8 = l;
                l4 = l9;
                d3 = d4;
                continue;
            }
            bl = true;
        } while (!bl);
        if (n3 >= n2) {
            throw new RuntimeException("Unable to convert " + d + " to fraction after " + n2 + " iterations");
        }
        if (l < (long)n) {
            return new SimpleFraction((int)l2, (int)l);
        }
        return new SimpleFraction((int)l7, (int)l8);
    }

    public SimpleFraction(int n, int n2) {
        this.numerator = n;
        this.denominator = n2;
    }

    public int getDenominator() {
        return this.denominator;
    }

    public int getNumerator() {
        return this.numerator;
    }
}

