/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.ss.format;

import ai.org.apache.poi.hssf.util.HSSFColor;
import ai.org.apache.poi.ss.format.CellFormatCondition;
import ai.org.apache.poi.ss.format.CellFormatResult;
import ai.org.apache.poi.ss.format.CellFormatType;
import ai.org.apache.poi.ss.format.CellFormatter;
import java.awt.Color;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JLabel;

public class CellFormatPart {
    private final Color color;
    private CellFormatCondition condition;
    private final CellFormatter format;
    private final CellFormatType type;
    private static final Map<String, Color> NAMED_COLORS;
    public static final Pattern COLOR_PAT;
    public static final Pattern CONDITION_PAT;
    public static final Pattern SPECIFICATION_PAT;
    public static final Pattern FORMAT_PAT;
    public static final int COLOR_GROUP;
    public static final int CONDITION_OPERATOR_GROUP;
    public static final int CONDITION_VALUE_GROUP;
    public static final int SPECIFICATION_GROUP;

    public CellFormatPart(String string) {
        Matcher matcher = FORMAT_PAT.matcher(string);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Unrecognized format: " + CellFormatter.quote(string));
        }
        this.color = CellFormatPart.getColor(matcher);
        this.condition = this.getCondition(matcher);
        this.type = this.getCellFormatType(matcher);
        this.format = this.getFormatter(matcher);
    }

    public boolean applies(Object object) {
        if (this.condition == null || !(object instanceof Number)) {
            if (object == null) {
                throw new NullPointerException("valueObject");
            }
            return true;
        }
        Number number = (Number)object;
        return this.condition.pass(number.doubleValue());
    }

    private static int findGroup(Pattern pattern, String string, String string2) {
        Matcher matcher = pattern.matcher(string);
        if (!matcher.find()) {
            throw new IllegalArgumentException("Pattern \"" + pattern.pattern() + "\" doesn't match \"" + string + "\"");
        }
        for (int i = 1; i <= matcher.groupCount(); ++i) {
            String string3 = matcher.group(i);
            if (string3 == null || !string3.equals(string2)) continue;
            return i;
        }
        throw new IllegalArgumentException("\"" + string2 + "\" not found in \"" + pattern.pattern() + "\"");
    }

    private static Color getColor(Matcher matcher) {
        String string = matcher.group(COLOR_GROUP);
        if (string == null || string.length() == 0) {
            return null;
        }
        Color color = NAMED_COLORS.get(string);
        if (color == null) {
            CellFormatter.logger.warning("Unknown color: " + CellFormatter.quote(string));
        }
        return color;
    }

    private CellFormatCondition getCondition(Matcher matcher) {
        String string = matcher.group(CONDITION_OPERATOR_GROUP);
        if (string == null || string.length() == 0) {
            return null;
        }
        return CellFormatCondition.getInstance(matcher.group(CONDITION_OPERATOR_GROUP), matcher.group(CONDITION_VALUE_GROUP));
    }

    private CellFormatType getCellFormatType(Matcher matcher) {
        String string = matcher.group(SPECIFICATION_GROUP);
        return this.formatType(string);
    }

    private CellFormatter getFormatter(Matcher matcher) {
        String string = matcher.group(SPECIFICATION_GROUP);
        return this.type.formatter(string);
    }

    private CellFormatType formatType(String string) {
        if ((string = string.trim()).equals("") || string.equalsIgnoreCase("General")) {
            return CellFormatType.GENERAL;
        }
        Matcher matcher = SPECIFICATION_PAT.matcher(string);
        boolean bl = false;
        boolean bl2 = false;
        while (matcher.find()) {
            String string2 = matcher.group(0);
            if (string2.length() <= 0) continue;
            switch (string2.charAt(0)) {
                case '@': {
                    return CellFormatType.TEXT;
                }
                case 'D': 
                case 'Y': 
                case 'd': 
                case 'y': {
                    return CellFormatType.DATE;
                }
                case 'H': 
                case 'M': 
                case 'S': 
                case 'h': 
                case 'm': 
                case 's': {
                    bl = true;
                    break;
                }
                case '0': {
                    bl2 = true;
                    break;
                }
                case '[': {
                    return CellFormatType.ELAPSED;
                }
                case '#': 
                case '?': {
                    return CellFormatType.NUMBER;
                }
            }
        }
        if (bl) {
            return CellFormatType.DATE;
        }
        if (bl2) {
            return CellFormatType.NUMBER;
        }
        return CellFormatType.TEXT;
    }

    static String quoteSpecial(String string, CellFormatType cellFormatType) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\'' && cellFormatType.isSpecial('\'')) {
                stringBuilder.append('\u0000');
                continue;
            }
            boolean bl = cellFormatType.isSpecial(c);
            if (bl) {
                stringBuilder.append("'");
            }
            stringBuilder.append(c);
            if (!bl) continue;
            stringBuilder.append("'");
        }
        return stringBuilder.toString();
    }

    public CellFormatResult apply(Object object) {
        Color color;
        String string;
        boolean bl = this.applies(object);
        if (bl) {
            string = this.format.format(object);
            color = this.color;
        } else {
            string = this.format.simpleFormat(object);
            color = null;
        }
        return new CellFormatResult(bl, string, color);
    }

    public CellFormatResult apply(JLabel jLabel, Object object) {
        CellFormatResult cellFormatResult = this.apply(object);
        jLabel.setText(cellFormatResult.text);
        if (cellFormatResult.textColor != null) {
            jLabel.setForeground(cellFormatResult.textColor);
        }
        return cellFormatResult;
    }

    CellFormatType getCellFormatType() {
        return this.type;
    }

    boolean hasCondition() {
        return this.condition != null;
    }

    public static StringBuffer parseFormat(String string, CellFormatType cellFormatType, PartHandler partHandler) {
        Matcher matcher = SPECIFICATION_PAT.matcher(string);
        StringBuffer stringBuffer = new StringBuffer();
        while (matcher.find()) {
            String string2 = CellFormatPart.group(matcher, 0);
            if (string2.length() <= 0) continue;
            String string3 = partHandler.handlePart(matcher, string2, cellFormatType, stringBuffer);
            if (string3 == null) {
                switch (string2.charAt(0)) {
                    case '\"': {
                        string3 = CellFormatPart.quoteSpecial(string2.substring(1, string2.length() - 1), cellFormatType);
                        break;
                    }
                    case '\\': {
                        string3 = CellFormatPart.quoteSpecial(string2.substring(1), cellFormatType);
                        break;
                    }
                    case '_': {
                        string3 = " ";
                        break;
                    }
                    case '*': {
                        string3 = CellFormatPart.expandChar(string2);
                        break;
                    }
                    default: {
                        string3 = string2;
                    }
                }
            }
            matcher.appendReplacement(stringBuffer, Matcher.quoteReplacement(string3));
        }
        matcher.appendTail(stringBuffer);
        if (cellFormatType.isSpecial('\'')) {
            int n = 0;
            while ((n = stringBuffer.indexOf("''", n)) >= 0) {
                stringBuffer.delete(n, n + 2);
            }
            n = 0;
            while ((n = stringBuffer.indexOf("\u0000", n)) >= 0) {
                stringBuffer.replace(n, n + 1, "''");
            }
        }
        return stringBuffer;
    }

    static String expandChar(String string) {
        char c = string.charAt(1);
        String string2 = "" + c + c + c;
        return string2;
    }

    public static String group(Matcher matcher, int n) {
        String string = matcher.group(n);
        return string == null ? "" : string;
    }

    static {
        Class<?> clazz;
        NAMED_COLORS = new TreeMap<String, Color>(String.CASE_INSENSITIVE_ORDER);
        Object object2 = HSSFColor.getIndexHash();
        for (HSSFColor object3 : object2.values()) {
            clazz = object3.getClass();
            String n = clazz.getSimpleName();
            if (!n.equals(n.toUpperCase())) continue;
            short[] sArray = object3.getTriplet();
            Color color = new Color(sArray[0], sArray[1], sArray[2]);
            NAMED_COLORS.put(n, color);
            if (n.indexOf(95) > 0) {
                NAMED_COLORS.put(n.replace('_', ' '), color);
            }
            if (n.indexOf("_PERCENT") <= 0) continue;
            NAMED_COLORS.put(n.replace("_PERCENT", "%").replace('_', ' '), color);
        }
        object2 = "([<>=]=?|!=|<>)    # The operator\n  \\s*([0-9]+(?:\\.[0-9]*)?)\\s*  # The constant to test against\n";
        String string = "\\[(black|blue|cyan|green|magenta|red|white|yellow|color [0-9]+)\\]";
        String string2 = "\\\\.                 # Quoted single character\n|\"([^\\\\\"]|\\\\.)*\"         # Quoted string of characters (handles escaped quotes like \\\") \n|_.                             # Space as wide as a given character\n|\\*.                           # Repeating fill character\n|@                              # Text: cell text\n|([0?\\#](?:[0?\\#,]*))         # Number: digit + other digits and commas\n|e[-+]                          # Number: Scientific: Exponent\n|m{1,5}                         # Date: month or minute spec\n|d{1,4}                         # Date: day/date spec\n|y{2,4}                         # Date: year spec\n|h{1,2}                         # Date: hour spec\n|s{1,2}                         # Date: second spec\n|am?/pm?                        # Date: am/pm spec\n|\\[h{1,2}\\]                   # Elapsed time: hour spec\n|\\[m{1,2}\\]                   # Elapsed time: minute spec\n|\\[s{1,2}\\]                   # Elapsed time: second spec\n|[^;]                           # A character\n";
        clazz = "(?:" + (String)string + ")?                  # Text color\n" + "(?:\\[" + (String)object2 + "\\])?                # Condition\n" + "((?:" + string2 + ")+)                        # Format spec\n";
        int n = 6;
        COLOR_PAT = Pattern.compile(string, n);
        CONDITION_PAT = Pattern.compile((String)object2, n);
        SPECIFICATION_PAT = Pattern.compile(string2, n);
        FORMAT_PAT = Pattern.compile((String)((Object)clazz), n);
        COLOR_GROUP = CellFormatPart.findGroup(FORMAT_PAT, "[Blue]@", "Blue");
        CONDITION_OPERATOR_GROUP = CellFormatPart.findGroup(FORMAT_PAT, "[>=1]@", ">=");
        CONDITION_VALUE_GROUP = CellFormatPart.findGroup(FORMAT_PAT, "[>=1]@", "1");
        SPECIFICATION_GROUP = CellFormatPart.findGroup(FORMAT_PAT, "[Blue][>1]\\a ?", "\\a ?");
    }

    static interface PartHandler {
        public String handlePart(Matcher var1, String var2, CellFormatType var3, StringBuffer var4);
    }
}

