/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.poifs.storage;

import ai.org.apache.poi.poifs.common.POIFSBigBlockSize;
import ai.org.apache.poi.poifs.storage.BigBlock;
import ai.org.apache.poi.poifs.storage.HeaderBlock;
import ai.org.apache.poi.util.LittleEndian;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BATBlock
extends BigBlock {
    private int[] _values;
    private boolean _has_free_sectors;
    private int ourBlockIndex;

    private BATBlock(POIFSBigBlockSize pOIFSBigBlockSize) {
        super(pOIFSBigBlockSize);
        int n = pOIFSBigBlockSize.getBATEntriesPerBlock();
        this._values = new int[n];
        this._has_free_sectors = true;
        Arrays.fill(this._values, -1);
    }

    private BATBlock(POIFSBigBlockSize pOIFSBigBlockSize, int[] nArray, int n, int n2) {
        this(pOIFSBigBlockSize);
        for (int i = n; i < n2; ++i) {
            this._values[i - n] = nArray[i];
        }
        if (n2 - n == this._values.length) {
            this.recomputeFree();
        }
    }

    private void recomputeFree() {
        boolean bl = false;
        for (int i = 0; i < this._values.length; ++i) {
            if (this._values[i] != -1) continue;
            bl = true;
            break;
        }
        this._has_free_sectors = bl;
    }

    public static BATBlock createBATBlock(POIFSBigBlockSize pOIFSBigBlockSize, ByteBuffer byteBuffer) {
        BATBlock bATBlock = new BATBlock(pOIFSBigBlockSize);
        byte[] byArray = new byte[4];
        for (int i = 0; i < bATBlock._values.length; ++i) {
            byteBuffer.get(byArray);
            bATBlock._values[i] = LittleEndian.getInt(byArray);
        }
        bATBlock.recomputeFree();
        return bATBlock;
    }

    public static BATBlock createEmptyBATBlock(POIFSBigBlockSize pOIFSBigBlockSize, boolean bl) {
        BATBlock bATBlock = new BATBlock(pOIFSBigBlockSize);
        if (bl) {
            bATBlock.setXBATChain(pOIFSBigBlockSize, -2);
        }
        return bATBlock;
    }

    public static BATBlock[] createBATBlocks(POIFSBigBlockSize pOIFSBigBlockSize, int[] nArray) {
        int n = BATBlock.calculateStorageRequirements(pOIFSBigBlockSize, nArray.length);
        BATBlock[] bATBlockArray = new BATBlock[n];
        int n2 = 0;
        int n3 = nArray.length;
        int n4 = pOIFSBigBlockSize.getBATEntriesPerBlock();
        for (int i = 0; i < nArray.length; i += n4) {
            bATBlockArray[n2++] = new BATBlock(pOIFSBigBlockSize, nArray, i, n3 > n4 ? i + n4 : nArray.length);
            n3 -= n4;
        }
        return bATBlockArray;
    }

    public static BATBlock[] createXBATBlocks(POIFSBigBlockSize pOIFSBigBlockSize, int[] nArray, int n) {
        int n2 = BATBlock.calculateXBATStorageRequirements(pOIFSBigBlockSize, nArray.length);
        BATBlock[] bATBlockArray = new BATBlock[n2];
        int n3 = 0;
        int n4 = nArray.length;
        int n5 = pOIFSBigBlockSize.getXBATEntriesPerBlock();
        if (n2 != 0) {
            for (int i = 0; i < nArray.length; i += n5) {
                bATBlockArray[n3++] = new BATBlock(pOIFSBigBlockSize, nArray, i, n4 > n5 ? i + n5 : nArray.length);
                n4 -= n5;
            }
            for (n3 = 0; n3 < bATBlockArray.length - 1; ++n3) {
                bATBlockArray[n3].setXBATChain(pOIFSBigBlockSize, n + n3 + 1);
            }
            bATBlockArray[n3].setXBATChain(pOIFSBigBlockSize, -2);
        }
        return bATBlockArray;
    }

    public static int calculateStorageRequirements(POIFSBigBlockSize pOIFSBigBlockSize, int n) {
        int n2 = pOIFSBigBlockSize.getBATEntriesPerBlock();
        return (n + n2 - 1) / n2;
    }

    public static int calculateXBATStorageRequirements(POIFSBigBlockSize pOIFSBigBlockSize, int n) {
        int n2 = pOIFSBigBlockSize.getXBATEntriesPerBlock();
        return (n + n2 - 1) / n2;
    }

    public static long calculateMaximumSize(POIFSBigBlockSize pOIFSBigBlockSize, int n) {
        long l = 1L;
        return (l += (long)(n * pOIFSBigBlockSize.getBATEntriesPerBlock())) * (long)pOIFSBigBlockSize.getBigBlockSize();
    }

    public static long calculateMaximumSize(HeaderBlock headerBlock) {
        return BATBlock.calculateMaximumSize(headerBlock.getBigBlockSize(), headerBlock.getBATCount());
    }

    public static BATBlockAndIndex getBATBlockAndIndex(int n, HeaderBlock headerBlock, List<BATBlock> list) {
        POIFSBigBlockSize pOIFSBigBlockSize = headerBlock.getBigBlockSize();
        int n2 = (int)Math.floor(n / pOIFSBigBlockSize.getBATEntriesPerBlock());
        int n3 = n % pOIFSBigBlockSize.getBATEntriesPerBlock();
        return new BATBlockAndIndex(n3, list.get(n2));
    }

    public static BATBlockAndIndex getSBATBlockAndIndex(int n, HeaderBlock headerBlock, List<BATBlock> list) {
        POIFSBigBlockSize pOIFSBigBlockSize = headerBlock.getBigBlockSize();
        int n2 = (int)Math.floor(n / pOIFSBigBlockSize.getBATEntriesPerBlock());
        int n3 = n % pOIFSBigBlockSize.getBATEntriesPerBlock();
        return new BATBlockAndIndex(n3, list.get(n2));
    }

    private void setXBATChain(POIFSBigBlockSize pOIFSBigBlockSize, int n) {
        int n2 = pOIFSBigBlockSize.getXBATEntriesPerBlock();
        this._values[n2] = n;
    }

    public boolean hasFreeSectors() {
        return this._has_free_sectors;
    }

    public int getValueAt(int n) {
        if (n >= this._values.length) {
            throw new ArrayIndexOutOfBoundsException("Unable to fetch offset " + n + " as the " + "BAT only contains " + this._values.length + " entries");
        }
        return this._values[n];
    }

    public void setValueAt(int n, int n2) {
        int n3 = this._values[n];
        this._values[n] = n2;
        if (n2 == -1) {
            this._has_free_sectors = true;
            return;
        }
        if (n3 == -1) {
            this.recomputeFree();
        }
    }

    public void setOurBlockIndex(int n) {
        this.ourBlockIndex = n;
    }

    public int getOurBlockIndex() {
        return this.ourBlockIndex;
    }

    @Override
    void writeData(OutputStream outputStream) throws IOException {
        outputStream.write(this.serialize());
    }

    void writeData(ByteBuffer byteBuffer) throws IOException {
        byteBuffer.put(this.serialize());
    }

    private byte[] serialize() {
        byte[] byArray = new byte[this.bigBlockSize.getBigBlockSize()];
        int n = 0;
        for (int i = 0; i < this._values.length; ++i) {
            LittleEndian.putInt(byArray, n, this._values[i]);
            n += 4;
        }
        return byArray;
    }

    public static class BATBlockAndIndex {
        private final int index;
        private final BATBlock block;

        private BATBlockAndIndex(int n, BATBlock bATBlock) {
            this.index = n;
            this.block = bATBlock;
        }

        public int getIndex() {
            return this.index;
        }

        public BATBlock getBlock() {
            return this.block;
        }
    }
}

