/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.poifs.property;

import ai.org.apache.poi.poifs.common.POIFSBigBlockSize;
import ai.org.apache.poi.poifs.property.Property;
import ai.org.apache.poi.poifs.property.PropertyFactory;
import ai.org.apache.poi.poifs.property.PropertyTableBase;
import ai.org.apache.poi.poifs.storage.BlockWritable;
import ai.org.apache.poi.poifs.storage.HeaderBlock;
import ai.org.apache.poi.poifs.storage.PropertyBlock;
import ai.org.apache.poi.poifs.storage.RawDataBlockList;
import java.io.IOException;
import java.io.OutputStream;

public final class PropertyTable
extends PropertyTableBase
implements BlockWritable {
    private POIFSBigBlockSize _bigBigBlockSize;
    private BlockWritable[] _blocks;

    public PropertyTable(HeaderBlock headerBlock) {
        super(headerBlock);
        this._bigBigBlockSize = headerBlock.getBigBlockSize();
        this._blocks = null;
    }

    public PropertyTable(HeaderBlock headerBlock, RawDataBlockList rawDataBlockList) throws IOException {
        super(headerBlock, PropertyFactory.convertToProperties(rawDataBlockList.fetchBlocks(headerBlock.getPropertyStart(), -1)));
        this._bigBigBlockSize = headerBlock.getBigBlockSize();
        this._blocks = null;
    }

    public void preWrite() {
        int n;
        Property[] propertyArray = this._properties.toArray(new Property[this._properties.size()]);
        for (n = 0; n < propertyArray.length; ++n) {
            propertyArray[n].setIndex(n);
        }
        this._blocks = PropertyBlock.createPropertyBlockArray(this._bigBigBlockSize, this._properties);
        for (n = 0; n < propertyArray.length; ++n) {
            propertyArray[n].preWrite();
        }
    }

    public int countBlocks() {
        return this._blocks == null ? 0 : this._blocks.length;
    }

    public void writeBlocks(OutputStream outputStream) throws IOException {
        if (this._blocks != null) {
            for (int i = 0; i < this._blocks.length; ++i) {
                this._blocks[i].writeBlocks(outputStream);
            }
        }
    }
}

