/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.poifs.filesystem;

import ai.org.apache.poi.util.POILogFactory;
import ai.org.apache.poi.util.POILogger;
import java.io.File;

public class POIFSDocumentPath {
    private static final POILogger log = POILogFactory.getLogger(POIFSDocumentPath.class);
    private String[] components;
    private int hashcode = 0;

    public POIFSDocumentPath(String[] stringArray) throws IllegalArgumentException {
        if (stringArray == null) {
            this.components = new String[0];
        } else {
            this.components = new String[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i] == null || stringArray[i].length() == 0) {
                    throw new IllegalArgumentException("components cannot contain null or empty strings");
                }
                this.components[i] = stringArray[i];
            }
        }
    }

    public POIFSDocumentPath() {
        this.components = new String[0];
    }

    public POIFSDocumentPath(POIFSDocumentPath pOIFSDocumentPath, String[] stringArray) throws IllegalArgumentException {
        int n;
        this.components = stringArray == null ? new String[pOIFSDocumentPath.components.length] : new String[pOIFSDocumentPath.components.length + stringArray.length];
        for (n = 0; n < pOIFSDocumentPath.components.length; ++n) {
            this.components[n] = pOIFSDocumentPath.components[n];
        }
        if (stringArray != null) {
            for (n = 0; n < stringArray.length; ++n) {
                if (stringArray[n] == null) {
                    throw new IllegalArgumentException("components cannot contain null");
                }
                if (stringArray[n].length() == 0) {
                    log.log(5, "Directory under " + pOIFSDocumentPath + " has an empty name, " + "not all OLE2 readers will handle this file correctly!");
                }
                this.components[n + pOIFSDocumentPath.components.length] = stringArray[n];
            }
        }
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object != null && object.getClass() == this.getClass()) {
            if (this == object) {
                bl = true;
            } else {
                POIFSDocumentPath pOIFSDocumentPath = (POIFSDocumentPath)object;
                if (pOIFSDocumentPath.components.length == this.components.length) {
                    bl = true;
                    for (int i = 0; i < this.components.length; ++i) {
                        if (pOIFSDocumentPath.components[i].equals(this.components[i])) continue;
                        bl = false;
                        break;
                    }
                }
            }
        }
        return bl;
    }

    public int hashCode() {
        if (this.hashcode == 0) {
            for (int i = 0; i < this.components.length; ++i) {
                this.hashcode += this.components[i].hashCode();
            }
        }
        return this.hashcode;
    }

    public int length() {
        return this.components.length;
    }

    public String getComponent(int n) throws ArrayIndexOutOfBoundsException {
        return this.components[n];
    }

    public POIFSDocumentPath getParent() {
        int n = this.components.length - 1;
        if (n < 0) {
            return null;
        }
        POIFSDocumentPath pOIFSDocumentPath = new POIFSDocumentPath(null);
        pOIFSDocumentPath.components = new String[n];
        System.arraycopy(this.components, 0, pOIFSDocumentPath.components, 0, n);
        return pOIFSDocumentPath;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.length();
        stringBuffer.append(File.separatorChar);
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(this.getComponent(i));
            if (i >= n - 1) continue;
            stringBuffer.append(File.separatorChar);
        }
        return stringBuffer.toString();
    }
}

