/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.poifs.filesystem;

import ai.org.apache.poi.poifs.common.POIFSBigBlockSize;
import ai.org.apache.poi.poifs.common.POIFSConstants;
import ai.org.apache.poi.poifs.dev.POIFSViewable;
import ai.org.apache.poi.poifs.filesystem.BATManaged;
import ai.org.apache.poi.poifs.filesystem.DocumentOutputStream;
import ai.org.apache.poi.poifs.filesystem.POIFSDocumentPath;
import ai.org.apache.poi.poifs.filesystem.POIFSWriterEvent;
import ai.org.apache.poi.poifs.filesystem.POIFSWriterListener;
import ai.org.apache.poi.poifs.property.DocumentProperty;
import ai.org.apache.poi.poifs.property.Property;
import ai.org.apache.poi.poifs.storage.BlockWritable;
import ai.org.apache.poi.poifs.storage.DataInputBlock;
import ai.org.apache.poi.poifs.storage.DocumentBlock;
import ai.org.apache.poi.poifs.storage.ListManagedBlock;
import ai.org.apache.poi.poifs.storage.RawDataBlock;
import ai.org.apache.poi.poifs.storage.SmallDocumentBlock;
import ai.org.apache.poi.util.HexDump;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class POIFSDocument
implements BATManaged,
BlockWritable,
POIFSViewable {
    private static final DocumentBlock[] EMPTY_BIG_BLOCK_ARRAY = new DocumentBlock[0];
    private static final SmallDocumentBlock[] EMPTY_SMALL_BLOCK_ARRAY = new SmallDocumentBlock[0];
    private DocumentProperty _property;
    private int _size;
    private final POIFSBigBlockSize _bigBigBlockSize;
    private SmallBlockStore _small_store;
    private BigBlockStore _big_store;

    public POIFSDocument(String string, RawDataBlock[] rawDataBlockArray, int n) throws IOException {
        this._size = n;
        this._bigBigBlockSize = rawDataBlockArray.length == 0 ? POIFSConstants.SMALLER_BIG_BLOCK_SIZE_DETAILS : (rawDataBlockArray[0].getBigBlockSize() == 512 ? POIFSConstants.SMALLER_BIG_BLOCK_SIZE_DETAILS : POIFSConstants.LARGER_BIG_BLOCK_SIZE_DETAILS);
        this._big_store = new BigBlockStore(this._bigBigBlockSize, POIFSDocument.convertRawBlocksToBigBlocks(rawDataBlockArray));
        this._property = new DocumentProperty(string, this._size);
        this._small_store = new SmallBlockStore(this._bigBigBlockSize, EMPTY_SMALL_BLOCK_ARRAY);
        this._property.setDocument(this);
    }

    private static DocumentBlock[] convertRawBlocksToBigBlocks(ListManagedBlock[] listManagedBlockArray) throws IOException {
        DocumentBlock[] documentBlockArray = new DocumentBlock[listManagedBlockArray.length];
        for (int i = 0; i < documentBlockArray.length; ++i) {
            documentBlockArray[i] = new DocumentBlock((RawDataBlock)listManagedBlockArray[i]);
        }
        return documentBlockArray;
    }

    private static SmallDocumentBlock[] convertRawBlocksToSmallBlocks(ListManagedBlock[] listManagedBlockArray) {
        if (listManagedBlockArray instanceof SmallDocumentBlock[]) {
            return (SmallDocumentBlock[])listManagedBlockArray;
        }
        SmallDocumentBlock[] smallDocumentBlockArray = new SmallDocumentBlock[listManagedBlockArray.length];
        System.arraycopy(listManagedBlockArray, 0, smallDocumentBlockArray, 0, listManagedBlockArray.length);
        return smallDocumentBlockArray;
    }

    public POIFSDocument(String string, SmallDocumentBlock[] smallDocumentBlockArray, int n) {
        this._size = n;
        this._bigBigBlockSize = smallDocumentBlockArray.length == 0 ? POIFSConstants.SMALLER_BIG_BLOCK_SIZE_DETAILS : smallDocumentBlockArray[0].getBigBlockSize();
        this._big_store = new BigBlockStore(this._bigBigBlockSize, EMPTY_BIG_BLOCK_ARRAY);
        this._property = new DocumentProperty(string, this._size);
        this._small_store = new SmallBlockStore(this._bigBigBlockSize, smallDocumentBlockArray);
        this._property.setDocument(this);
    }

    public POIFSDocument(String string, POIFSBigBlockSize pOIFSBigBlockSize, ListManagedBlock[] listManagedBlockArray, int n) throws IOException {
        this._size = n;
        this._bigBigBlockSize = pOIFSBigBlockSize;
        this._property = new DocumentProperty(string, this._size);
        this._property.setDocument(this);
        if (Property.isSmall(this._size)) {
            this._big_store = new BigBlockStore(pOIFSBigBlockSize, EMPTY_BIG_BLOCK_ARRAY);
            this._small_store = new SmallBlockStore(pOIFSBigBlockSize, POIFSDocument.convertRawBlocksToSmallBlocks(listManagedBlockArray));
        } else {
            this._big_store = new BigBlockStore(pOIFSBigBlockSize, POIFSDocument.convertRawBlocksToBigBlocks(listManagedBlockArray));
            this._small_store = new SmallBlockStore(pOIFSBigBlockSize, EMPTY_SMALL_BLOCK_ARRAY);
        }
    }

    public POIFSDocument(String string, ListManagedBlock[] listManagedBlockArray, int n) throws IOException {
        this(string, POIFSConstants.SMALLER_BIG_BLOCK_SIZE_DETAILS, listManagedBlockArray, n);
    }

    public POIFSDocument(String string, POIFSBigBlockSize pOIFSBigBlockSize, InputStream inputStream) throws IOException {
        BlockWritable[] blockWritableArray;
        ArrayList<BlockWritable[]> arrayList = new ArrayList<BlockWritable[]>();
        this._size = 0;
        this._bigBigBlockSize = pOIFSBigBlockSize;
        do {
            int n;
            if ((n = (blockWritableArray = new DocumentBlock(inputStream, pOIFSBigBlockSize)).size()) <= 0) continue;
            arrayList.add(blockWritableArray);
            this._size += n;
        } while (!blockWritableArray.partiallyRead());
        blockWritableArray = arrayList.toArray(new DocumentBlock[arrayList.size()]);
        this._big_store = new BigBlockStore(pOIFSBigBlockSize, (DocumentBlock[])blockWritableArray);
        this._property = new DocumentProperty(string, this._size);
        this._property.setDocument(this);
        if (this._property.shouldUseSmallBlocks()) {
            this._small_store = new SmallBlockStore(pOIFSBigBlockSize, SmallDocumentBlock.convert(pOIFSBigBlockSize, blockWritableArray, this._size));
            this._big_store = new BigBlockStore(pOIFSBigBlockSize, new DocumentBlock[0]);
        } else {
            this._small_store = new SmallBlockStore(pOIFSBigBlockSize, EMPTY_SMALL_BLOCK_ARRAY);
        }
    }

    public POIFSDocument(String string, InputStream inputStream) throws IOException {
        this(string, POIFSConstants.SMALLER_BIG_BLOCK_SIZE_DETAILS, inputStream);
    }

    public POIFSDocument(String string, int n, POIFSBigBlockSize pOIFSBigBlockSize, POIFSDocumentPath pOIFSDocumentPath, POIFSWriterListener pOIFSWriterListener) {
        this._size = n;
        this._bigBigBlockSize = pOIFSBigBlockSize;
        this._property = new DocumentProperty(string, this._size);
        this._property.setDocument(this);
        if (this._property.shouldUseSmallBlocks()) {
            this._small_store = new SmallBlockStore(this._bigBigBlockSize, pOIFSDocumentPath, string, n, pOIFSWriterListener);
            this._big_store = new BigBlockStore(this._bigBigBlockSize, EMPTY_BIG_BLOCK_ARRAY);
        } else {
            this._small_store = new SmallBlockStore(this._bigBigBlockSize, EMPTY_SMALL_BLOCK_ARRAY);
            this._big_store = new BigBlockStore(this._bigBigBlockSize, pOIFSDocumentPath, string, n, pOIFSWriterListener);
        }
    }

    public POIFSDocument(String string, int n, POIFSDocumentPath pOIFSDocumentPath, POIFSWriterListener pOIFSWriterListener) {
        this(string, n, POIFSConstants.SMALLER_BIG_BLOCK_SIZE_DETAILS, pOIFSDocumentPath, pOIFSWriterListener);
    }

    public BlockWritable[] getSmallBlocks() {
        return this._small_store.getBlocks();
    }

    public int getSize() {
        return this._size;
    }

    void read(byte[] byArray, int n) {
        int n2 = byArray.length;
        DataInputBlock dataInputBlock = this.getDataInputBlock(n);
        int n3 = dataInputBlock.available();
        if (n3 > n2) {
            dataInputBlock.readFully(byArray, 0, n2);
            return;
        }
        int n4 = n2;
        int n5 = 0;
        int n6 = n;
        while (n4 > 0) {
            boolean bl = n4 >= n3;
            int n7 = bl ? n3 : n4;
            dataInputBlock.readFully(byArray, n5, n7);
            n4 -= n7;
            n5 += n7;
            n6 += n7;
            if (!bl) continue;
            if (n6 == this._size) {
                if (n4 > 0) {
                    throw new IllegalStateException("reached end of document stream unexpectedly");
                }
                dataInputBlock = null;
                break;
            }
            dataInputBlock = this.getDataInputBlock(n6);
            n3 = dataInputBlock.available();
        }
    }

    DataInputBlock getDataInputBlock(int n) {
        if (n >= this._size) {
            if (n > this._size) {
                throw new RuntimeException("Request for Offset " + n + " doc size is " + this._size);
            }
            return null;
        }
        if (this._property.shouldUseSmallBlocks()) {
            return SmallDocumentBlock.getDataInputBlock(this._small_store.getBlocks(), n);
        }
        return DocumentBlock.getDataInputBlock(this._big_store.getBlocks(), n);
    }

    DocumentProperty getDocumentProperty() {
        return this._property;
    }

    @Override
    public void writeBlocks(OutputStream outputStream) throws IOException {
        this._big_store.writeBlocks(outputStream);
    }

    @Override
    public int countBlocks() {
        return this._big_store.countBlocks();
    }

    @Override
    public void setStartBlock(int n) {
        this._property.setStartBlock(n);
    }

    @Override
    public Object[] getViewableArray() {
        String string;
        Object[] objectArray = new Object[1];
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            BlockWritable[] blockWritableArray = null;
            if (this._big_store.isValid()) {
                blockWritableArray = this._big_store.getBlocks();
            } else if (this._small_store.isValid()) {
                blockWritableArray = this._small_store.getBlocks();
            }
            if (blockWritableArray != null) {
                for (int i = 0; i < blockWritableArray.length; ++i) {
                    blockWritableArray[i].writeBlocks(byteArrayOutputStream);
                }
                byte[] byArray = byteArrayOutputStream.toByteArray();
                if (byArray.length > this._property.getSize()) {
                    byte[] byArray2 = new byte[this._property.getSize()];
                    System.arraycopy(byArray, 0, byArray2, 0, byArray2.length);
                    byArray = byArray2;
                }
                byteArrayOutputStream = new ByteArrayOutputStream();
                HexDump.dump(byArray, 0L, byteArrayOutputStream, 0);
                string = byteArrayOutputStream.toString();
            } else {
                string = "<NO DATA>";
            }
        }
        catch (IOException iOException) {
            string = iOException.getMessage();
        }
        objectArray[0] = string;
        return objectArray;
    }

    @Override
    public Iterator<Object> getViewableIterator() {
        return Collections.emptyList().iterator();
    }

    @Override
    public boolean preferArray() {
        return true;
    }

    @Override
    public String getShortDescription() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Document: \"").append(this._property.getName()).append("\"");
        stringBuffer.append(" size = ").append(this.getSize());
        return stringBuffer.toString();
    }

    private static final class BigBlockStore {
        private DocumentBlock[] bigBlocks;
        private final POIFSDocumentPath _path;
        private final String _name;
        private final int _size;
        private final POIFSWriterListener _writer;
        private final POIFSBigBlockSize _bigBlockSize;

        BigBlockStore(POIFSBigBlockSize pOIFSBigBlockSize, DocumentBlock[] documentBlockArray) {
            this._bigBlockSize = pOIFSBigBlockSize;
            this.bigBlocks = (DocumentBlock[])documentBlockArray.clone();
            this._path = null;
            this._name = null;
            this._size = -1;
            this._writer = null;
        }

        BigBlockStore(POIFSBigBlockSize pOIFSBigBlockSize, POIFSDocumentPath pOIFSDocumentPath, String string, int n, POIFSWriterListener pOIFSWriterListener) {
            this._bigBlockSize = pOIFSBigBlockSize;
            this.bigBlocks = new DocumentBlock[0];
            this._path = pOIFSDocumentPath;
            this._name = string;
            this._size = n;
            this._writer = pOIFSWriterListener;
        }

        boolean isValid() {
            return this.bigBlocks.length > 0 || this._writer != null;
        }

        DocumentBlock[] getBlocks() {
            if (this.isValid() && this._writer != null) {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(this._size);
                DocumentOutputStream documentOutputStream = new DocumentOutputStream(byteArrayOutputStream, this._size);
                this._writer.processPOIFSWriterEvent(new POIFSWriterEvent(documentOutputStream, this._path, this._name, this._size));
                this.bigBlocks = DocumentBlock.convert(this._bigBlockSize, byteArrayOutputStream.toByteArray(), this._size);
            }
            return this.bigBlocks;
        }

        void writeBlocks(OutputStream outputStream) throws IOException {
            if (this.isValid()) {
                if (this._writer != null) {
                    DocumentOutputStream documentOutputStream = new DocumentOutputStream(outputStream, this._size);
                    this._writer.processPOIFSWriterEvent(new POIFSWriterEvent(documentOutputStream, this._path, this._name, this._size));
                    documentOutputStream.writeFiller(this.countBlocks() * this._bigBlockSize.getBigBlockSize(), DocumentBlock.getFillByte());
                } else {
                    for (int i = 0; i < this.bigBlocks.length; ++i) {
                        this.bigBlocks[i].writeBlocks(outputStream);
                    }
                }
            }
        }

        int countBlocks() {
            if (this.isValid()) {
                if (this._writer == null) {
                    return this.bigBlocks.length;
                }
                return (this._size + this._bigBlockSize.getBigBlockSize() - 1) / this._bigBlockSize.getBigBlockSize();
            }
            return 0;
        }
    }

    private static final class SmallBlockStore {
        private SmallDocumentBlock[] _smallBlocks;
        private final POIFSDocumentPath _path;
        private final String _name;
        private final int _size;
        private final POIFSWriterListener _writer;
        private final POIFSBigBlockSize _bigBlockSize;

        SmallBlockStore(POIFSBigBlockSize pOIFSBigBlockSize, SmallDocumentBlock[] smallDocumentBlockArray) {
            this._bigBlockSize = pOIFSBigBlockSize;
            this._smallBlocks = (SmallDocumentBlock[])smallDocumentBlockArray.clone();
            this._path = null;
            this._name = null;
            this._size = -1;
            this._writer = null;
        }

        SmallBlockStore(POIFSBigBlockSize pOIFSBigBlockSize, POIFSDocumentPath pOIFSDocumentPath, String string, int n, POIFSWriterListener pOIFSWriterListener) {
            this._bigBlockSize = pOIFSBigBlockSize;
            this._smallBlocks = new SmallDocumentBlock[0];
            this._path = pOIFSDocumentPath;
            this._name = string;
            this._size = n;
            this._writer = pOIFSWriterListener;
        }

        boolean isValid() {
            return this._smallBlocks.length > 0 || this._writer != null;
        }

        SmallDocumentBlock[] getBlocks() {
            if (this.isValid() && this._writer != null) {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(this._size);
                DocumentOutputStream documentOutputStream = new DocumentOutputStream(byteArrayOutputStream, this._size);
                this._writer.processPOIFSWriterEvent(new POIFSWriterEvent(documentOutputStream, this._path, this._name, this._size));
                this._smallBlocks = SmallDocumentBlock.convert(this._bigBlockSize, byteArrayOutputStream.toByteArray(), this._size);
            }
            return this._smallBlocks;
        }
    }
}

