/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.poifs.filesystem;

import ai.org.apache.poi.poifs.common.POIFSBigBlockSize;
import ai.org.apache.poi.poifs.common.POIFSConstants;
import ai.org.apache.poi.poifs.dev.POIFSViewable;
import ai.org.apache.poi.poifs.filesystem.BlockStore;
import ai.org.apache.poi.poifs.filesystem.DirectoryEntry;
import ai.org.apache.poi.poifs.filesystem.DirectoryNode;
import ai.org.apache.poi.poifs.filesystem.DocumentEntry;
import ai.org.apache.poi.poifs.filesystem.DocumentInputStream;
import ai.org.apache.poi.poifs.filesystem.EntryNode;
import ai.org.apache.poi.poifs.filesystem.NPOIFSDocument;
import ai.org.apache.poi.poifs.filesystem.NPOIFSMiniStore;
import ai.org.apache.poi.poifs.filesystem.NPOIFSStream;
import ai.org.apache.poi.poifs.filesystem.POIFSWriterListener;
import ai.org.apache.poi.poifs.nio.ByteArrayBackedDataSource;
import ai.org.apache.poi.poifs.nio.DataSource;
import ai.org.apache.poi.poifs.nio.FileBackedDataSource;
import ai.org.apache.poi.poifs.property.DirectoryProperty;
import ai.org.apache.poi.poifs.property.DocumentProperty;
import ai.org.apache.poi.poifs.property.NPropertyTable;
import ai.org.apache.poi.poifs.storage.BATBlock;
import ai.org.apache.poi.poifs.storage.BlockAllocationTableReader;
import ai.org.apache.poi.poifs.storage.BlockAllocationTableWriter;
import ai.org.apache.poi.poifs.storage.HeaderBlock;
import ai.org.apache.poi.poifs.storage.HeaderBlockWriter;
import ai.org.apache.poi.util.CloseIgnoringInputStream;
import ai.org.apache.poi.util.IOUtils;
import ai.org.apache.poi.util.LongField;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NPOIFSFileSystem
extends BlockStore
implements POIFSViewable,
Closeable {
    private NPOIFSMiniStore _mini_store;
    private NPropertyTable _property_table;
    private List<BATBlock> _xbat_blocks;
    private List<BATBlock> _bat_blocks;
    private HeaderBlock _header;
    private DirectoryNode _root = null;
    private DataSource _data;
    private POIFSBigBlockSize bigBlockSize = POIFSConstants.SMALLER_BIG_BLOCK_SIZE_DETAILS;

    public static InputStream createNonClosingInputStream(InputStream inputStream) {
        return new CloseIgnoringInputStream(inputStream);
    }

    private NPOIFSFileSystem(boolean bl) {
        this._header = new HeaderBlock(this.bigBlockSize);
        this._property_table = new NPropertyTable(this._header);
        this._mini_store = new NPOIFSMiniStore(this, this._property_table.getRoot(), new ArrayList<BATBlock>(), this._header);
        this._xbat_blocks = new ArrayList<BATBlock>();
        this._bat_blocks = new ArrayList<BATBlock>();
        if (bl) {
            this._data = new ByteArrayBackedDataSource(new byte[this.bigBlockSize.getBigBlockSize() * 3]);
        }
    }

    public NPOIFSFileSystem() {
        this(true);
        this._header.setBATCount(1);
        this._header.setBATArray(new int[]{0});
        BATBlock bATBlock = BATBlock.createEmptyBATBlock(this.bigBlockSize, false);
        bATBlock.setOurBlockIndex(0);
        this._bat_blocks.add(bATBlock);
        this.setNextBlock(0, -3);
        this.setNextBlock(1, -2);
        this._property_table.setStartBlock(-2);
    }

    public NPOIFSFileSystem(File file) throws IOException {
        this(file, true);
    }

    public NPOIFSFileSystem(File file, boolean bl) throws IOException {
        this(null, file, bl, true);
    }

    public NPOIFSFileSystem(FileChannel fileChannel) throws IOException {
        this(fileChannel, true);
    }

    public NPOIFSFileSystem(FileChannel fileChannel, boolean bl) throws IOException {
        this(fileChannel, null, bl, false);
    }

    private NPOIFSFileSystem(FileChannel fileChannel, File file, boolean bl, boolean bl2) throws IOException {
        this(false);
        try {
            Object object;
            if (file != null) {
                object = new FileBackedDataSource(file, bl);
                fileChannel = ((FileBackedDataSource)object).getChannel();
                this._data = object;
            } else {
                this._data = new FileBackedDataSource(fileChannel, bl);
            }
            object = ByteBuffer.allocate(512);
            IOUtils.readFully(fileChannel, (ByteBuffer)object);
            this._header = new HeaderBlock((ByteBuffer)object);
            this.readCoreContents();
        }
        catch (IOException iOException) {
            if (bl2) {
                fileChannel.close();
            }
            throw iOException;
        }
        catch (RuntimeException runtimeException) {
            if (bl2) {
                fileChannel.close();
            }
            throw runtimeException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NPOIFSFileSystem(InputStream inputStream) throws IOException {
        this(false);
        ReadableByteChannel readableByteChannel = null;
        boolean bl = false;
        try {
            readableByteChannel = Channels.newChannel(inputStream);
            ByteBuffer byteBuffer = ByteBuffer.allocate(512);
            IOUtils.readFully(readableByteChannel, byteBuffer);
            this._header = new HeaderBlock(byteBuffer);
            BlockAllocationTableReader.sanityCheckBlockCount(this._header.getBATCount());
            long l = BATBlock.calculateMaximumSize(this._header);
            if (l > Integer.MAX_VALUE) {
                throw new IllegalArgumentException("Unable read a >2gb file via an InputStream");
            }
            ByteBuffer byteBuffer2 = ByteBuffer.allocate((int)l);
            byteBuffer.position(0);
            byteBuffer2.put(byteBuffer);
            byteBuffer2.position(byteBuffer.capacity());
            IOUtils.readFully(readableByteChannel, byteBuffer2);
            bl = true;
            this._data = new ByteArrayBackedDataSource(byteBuffer2.array(), byteBuffer2.position());
        }
        finally {
            if (readableByteChannel != null) {
                readableByteChannel.close();
            }
            this.closeInputStream(inputStream, bl);
        }
        this.readCoreContents();
    }

    private void closeInputStream(InputStream inputStream, boolean bl) {
        try {
            inputStream.close();
        }
        catch (IOException iOException) {
            if (bl) {
                throw new RuntimeException(iOException);
            }
            iOException.printStackTrace();
        }
    }

    public static boolean hasPOIFSHeader(InputStream inputStream) throws IOException {
        inputStream.mark(8);
        byte[] byArray = new byte[8];
        IOUtils.readFully(inputStream, byArray);
        LongField longField = new LongField(0, byArray);
        if (inputStream instanceof PushbackInputStream) {
            PushbackInputStream pushbackInputStream = (PushbackInputStream)inputStream;
            pushbackInputStream.unread(byArray);
        } else {
            inputStream.reset();
        }
        return longField.get() == -2226271756974174256L;
    }

    private void readCoreContents() throws IOException {
        int n;
        Object object;
        this.bigBlockSize = this._header.getBigBlockSize();
        BlockStore.ChainLoopDetector chainLoopDetector = this.getChainLoopDetector();
        for (int n2 : this._header.getBATArray()) {
            this.readBAT(n2, chainLoopDetector);
        }
        int n3 = this._header.getBATCount() - this._header.getBATArray().length;
        int n4 = this._header.getXBATIndex();
        for (int n2 = 0; n2 < this._header.getXBATCount(); ++n2) {
            int n5;
            chainLoopDetector.claim(n4);
            object = this.getBlockAt(n4);
            BATBlock bATBlock = BATBlock.createBATBlock(this.bigBlockSize, (ByteBuffer)object);
            bATBlock.setOurBlockIndex(n4);
            n4 = bATBlock.getValueAt(this.bigBlockSize.getXBATEntriesPerBlock());
            this._xbat_blocks.add(bATBlock);
            n = Math.min(n3, this.bigBlockSize.getXBATEntriesPerBlock());
            for (int i = 0; i < n && (n5 = bATBlock.getValueAt(i)) != -1 && n5 != -2; ++i) {
                this.readBAT(n5, chainLoopDetector);
            }
            n3 -= n;
        }
        this._property_table = new NPropertyTable(this._header, this);
        object = new ArrayList();
        this._mini_store = new NPOIFSMiniStore(this, this._property_table.getRoot(), (List<BATBlock>)object, this._header);
        n4 = this._header.getSBATStart();
        for (n = 0; n < this._header.getSBATCount(); ++n) {
            chainLoopDetector.claim(n4);
            ByteBuffer byteBuffer = this.getBlockAt(n4);
            BATBlock bATBlock = BATBlock.createBATBlock(this.bigBlockSize, byteBuffer);
            bATBlock.setOurBlockIndex(n4);
            object.add(bATBlock);
            n4 = this.getNextBlock(n4);
        }
    }

    private void readBAT(int n, BlockStore.ChainLoopDetector chainLoopDetector) throws IOException {
        chainLoopDetector.claim(n);
        ByteBuffer byteBuffer = this.getBlockAt(n);
        BATBlock bATBlock = BATBlock.createBATBlock(this.bigBlockSize, byteBuffer);
        bATBlock.setOurBlockIndex(n);
        this._bat_blocks.add(bATBlock);
    }

    private BATBlock createBAT(int n, boolean bl) throws IOException {
        BATBlock bATBlock = BATBlock.createEmptyBATBlock(this.bigBlockSize, !bl);
        bATBlock.setOurBlockIndex(n);
        ByteBuffer byteBuffer = ByteBuffer.allocate(this.bigBlockSize.getBigBlockSize());
        int n2 = (1 + n) * this.bigBlockSize.getBigBlockSize();
        this._data.write(byteBuffer, n2);
        return bATBlock;
    }

    @Override
    protected ByteBuffer getBlockAt(int n) throws IOException {
        long l = n + 1;
        long l2 = l * (long)this.bigBlockSize.getBigBlockSize();
        try {
            return this._data.read(this.bigBlockSize.getBigBlockSize(), l2);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new IndexOutOfBoundsException("Block " + n + " not found - " + indexOutOfBoundsException);
        }
    }

    @Override
    protected ByteBuffer createBlockIfNeeded(int n) throws IOException {
        try {
            return this.getBlockAt(n);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            long l = (n + 1) * this.bigBlockSize.getBigBlockSize();
            ByteBuffer byteBuffer = ByteBuffer.allocate(this.getBigBlockSize());
            this._data.write(byteBuffer, l);
            return this.getBlockAt(n);
        }
    }

    @Override
    protected BATBlock.BATBlockAndIndex getBATBlockAndIndex(int n) {
        return BATBlock.getBATBlockAndIndex(n, this._header, this._bat_blocks);
    }

    @Override
    protected int getNextBlock(int n) {
        BATBlock.BATBlockAndIndex bATBlockAndIndex = this.getBATBlockAndIndex(n);
        return bATBlockAndIndex.getBlock().getValueAt(bATBlockAndIndex.getIndex());
    }

    @Override
    protected void setNextBlock(int n, int n2) {
        BATBlock.BATBlockAndIndex bATBlockAndIndex = this.getBATBlockAndIndex(n);
        bATBlockAndIndex.getBlock().setValueAt(bATBlockAndIndex.getIndex(), n2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected int getFreeBlock() throws IOException {
        int n = this.bigBlockSize.getBATEntriesPerBlock();
        int n2 = 0;
        for (BATBlock object2 : this._bat_blocks) {
            if (object2.hasFreeSectors()) {
                for (int i = 0; i < n; ++i) {
                    int n3 = object2.getValueAt(i);
                    if (n3 != -1) continue;
                    return n2 + i;
                }
            }
            n2 += n;
        }
        BATBlock bATBlock = this.createBAT(n2, true);
        bATBlock.setValueAt(0, -3);
        this._bat_blocks.add(bATBlock);
        if (this._header.getBATCount() >= 109) {
            void var4_7;
            Object var4_5 = null;
            for (BATBlock bATBlock2 : this._xbat_blocks) {
                if (!bATBlock2.hasFreeSectors()) continue;
                BATBlock bATBlock3 = bATBlock2;
                break;
            }
            if (var4_7 == null) {
                BATBlock bATBlock4 = this.createBAT(n2 + 1, false);
                bATBlock4.setValueAt(0, n2);
                bATBlock.setValueAt(1, -4);
                ++n2;
                if (this._xbat_blocks.size() == 0) {
                    this._header.setXBATStart(n2);
                } else {
                    this._xbat_blocks.get(this._xbat_blocks.size() - 1).setValueAt(this.bigBlockSize.getXBATEntriesPerBlock(), n2);
                }
                this._xbat_blocks.add(bATBlock4);
                this._header.setXBATCount(this._xbat_blocks.size());
            } else {
                for (int i = 0; i < this.bigBlockSize.getXBATEntriesPerBlock(); ++i) {
                    if (var4_7.getValueAt(i) != -1) continue;
                    var4_7.setValueAt(i, n2);
                    break;
                }
            }
        } else {
            int[] nArray = new int[this._header.getBATCount() + 1];
            System.arraycopy(this._header.getBATArray(), 0, nArray, 0, nArray.length - 1);
            nArray[nArray.length - 1] = n2;
            this._header.setBATArray(nArray);
        }
        this._header.setBATCount(this._bat_blocks.size());
        return n2 + 1;
    }

    protected long size() throws IOException {
        return this._data.size();
    }

    @Override
    protected BlockStore.ChainLoopDetector getChainLoopDetector() throws IOException {
        return new BlockStore.ChainLoopDetector(this._data.size());
    }

    NPropertyTable _get_property_table() {
        return this._property_table;
    }

    public NPOIFSMiniStore getMiniStore() {
        return this._mini_store;
    }

    void addDocument(NPOIFSDocument nPOIFSDocument) {
        this._property_table.addProperty(nPOIFSDocument.getDocumentProperty());
    }

    void addDirectory(DirectoryProperty directoryProperty) {
        this._property_table.addProperty(directoryProperty);
    }

    public DocumentEntry createDocument(InputStream inputStream, String string) throws IOException {
        return this.getRoot().createDocument(string, inputStream);
    }

    public DocumentEntry createDocument(String string, int n, POIFSWriterListener pOIFSWriterListener) throws IOException {
        return this.getRoot().createDocument(string, n, pOIFSWriterListener);
    }

    public DirectoryEntry createDirectory(String string) throws IOException {
        return this.getRoot().createDirectory(string);
    }

    public void writeFilesystem() throws IOException {
        if (!(this._data instanceof FileBackedDataSource)) {
            throw new IllegalArgumentException("POIFS opened from an inputstream, so writeFilesystem() may not be called. Use writeFilesystem(OutputStream) instead");
        }
        if (!((FileBackedDataSource)this._data).isWriteable()) {
            throw new IllegalArgumentException("POIFS opened in read only mode, so writeFilesystem() may not be called. Open the FileSystem in read-write mode first");
        }
        this.syncWithDataSource();
    }

    public void writeFilesystem(OutputStream outputStream) throws IOException {
        this.syncWithDataSource();
        this._data.copyTo(outputStream);
    }

    private void syncWithDataSource() throws IOException {
        ByteBuffer byteBuffer;
        NPOIFSStream nPOIFSStream = new NPOIFSStream(this, this._header.getPropertyStart());
        this._property_table.preWrite();
        this._property_table.write(nPOIFSStream);
        HeaderBlockWriter headerBlockWriter = new HeaderBlockWriter(this._header);
        headerBlockWriter.writeBlock(this.getBlockAt(-1));
        for (BATBlock bATBlock : this._bat_blocks) {
            byteBuffer = this.getBlockAt(bATBlock.getOurBlockIndex());
            BlockAllocationTableWriter.writeBlock(bATBlock, byteBuffer);
        }
        for (BATBlock bATBlock : this._xbat_blocks) {
            byteBuffer = this.getBlockAt(bATBlock.getOurBlockIndex());
            BlockAllocationTableWriter.writeBlock(bATBlock, byteBuffer);
        }
        this._mini_store.syncWithDataSource();
    }

    @Override
    public void close() throws IOException {
        this._data.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) throws IOException {
        if (stringArray.length != 2) {
            System.err.println("two arguments required: input filename and output filename");
            System.exit(1);
        }
        FileInputStream fileInputStream = new FileInputStream(stringArray[0]);
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(stringArray[1]);
            try {
                NPOIFSFileSystem nPOIFSFileSystem = new NPOIFSFileSystem(fileInputStream);
                try {
                    nPOIFSFileSystem.writeFilesystem(fileOutputStream);
                }
                finally {
                    nPOIFSFileSystem.close();
                }
            }
            finally {
                fileOutputStream.close();
            }
        }
        finally {
            fileInputStream.close();
        }
    }

    public DirectoryNode getRoot() {
        if (this._root == null) {
            this._root = new DirectoryNode((DirectoryProperty)this._property_table.getRoot(), this, null);
        }
        return this._root;
    }

    public DocumentInputStream createDocumentInputStream(String string) throws IOException {
        return this.getRoot().createDocumentInputStream(string);
    }

    void remove(EntryNode entryNode) throws IOException {
        if (entryNode instanceof DocumentEntry) {
            NPOIFSDocument nPOIFSDocument = new NPOIFSDocument((DocumentProperty)entryNode.getProperty(), this);
            nPOIFSDocument.free();
        }
        this._property_table.removeProperty(entryNode.getProperty());
    }

    @Override
    public Object[] getViewableArray() {
        if (this.preferArray()) {
            return this.getRoot().getViewableArray();
        }
        return new Object[0];
    }

    @Override
    public Iterator<Object> getViewableIterator() {
        if (!this.preferArray()) {
            return this.getRoot().getViewableIterator();
        }
        return Collections.emptyList().iterator();
    }

    @Override
    public boolean preferArray() {
        return this.getRoot().preferArray();
    }

    @Override
    public String getShortDescription() {
        return "POIFS FileSystem";
    }

    public int getBigBlockSize() {
        return this.bigBlockSize.getBigBlockSize();
    }

    public POIFSBigBlockSize getBigBlockSizeDetails() {
        return this.bigBlockSize;
    }

    @Override
    protected int getBlockStoreBlockSize() {
        return this.getBigBlockSize();
    }
}

