/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.poifs.filesystem;

import ai.org.apache.poi.hpsf.ClassID;
import ai.org.apache.poi.poifs.filesystem.DirectoryEntry;
import ai.org.apache.poi.poifs.filesystem.DocumentEntry;
import ai.org.apache.poi.poifs.filesystem.Entry;
import ai.org.apache.poi.poifs.filesystem.POIFSWriterListener;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilteringDirectoryNode
implements DirectoryEntry {
    private Set<String> excludes;
    private Map<String, List<String>> childExcludes;
    private DirectoryEntry directory;

    public FilteringDirectoryNode(DirectoryEntry directoryEntry, Collection<String> collection) {
        this.directory = directoryEntry;
        this.excludes = new HashSet<String>();
        this.childExcludes = new HashMap<String, List<String>>();
        for (String string : collection) {
            int n = string.indexOf(47);
            if (n == -1) {
                this.excludes.add(string);
                continue;
            }
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 1);
            if (!this.childExcludes.containsKey(string2)) {
                this.childExcludes.put(string2, new ArrayList());
            }
            this.childExcludes.get(string2).add(string3);
        }
    }

    @Override
    public DirectoryEntry createDirectory(String string) throws IOException {
        return this.directory.createDirectory(string);
    }

    @Override
    public DocumentEntry createDocument(String string, InputStream inputStream) throws IOException {
        return this.directory.createDocument(string, inputStream);
    }

    @Override
    public DocumentEntry createDocument(String string, int n, POIFSWriterListener pOIFSWriterListener) throws IOException {
        return this.directory.createDocument(string, n, pOIFSWriterListener);
    }

    @Override
    public Iterator<Entry> getEntries() {
        return new FilteringIterator();
    }

    @Override
    public Iterator<Entry> iterator() {
        return this.getEntries();
    }

    @Override
    public int getEntryCount() {
        int n = this.directory.getEntryCount();
        for (String string : this.excludes) {
            if (!this.directory.hasEntry(string)) continue;
            --n;
        }
        return n;
    }

    @Override
    public Set<String> getEntryNames() {
        HashSet<String> hashSet = new HashSet<String>();
        for (String string : this.directory.getEntryNames()) {
            if (this.excludes.contains(string)) continue;
            hashSet.add(string);
        }
        return hashSet;
    }

    @Override
    public boolean isEmpty() {
        return this.getEntryCount() == 0;
    }

    @Override
    public boolean hasEntry(String string) {
        if (this.excludes.contains(string)) {
            return false;
        }
        return this.directory.hasEntry(string);
    }

    @Override
    public Entry getEntry(String string) throws FileNotFoundException {
        if (this.excludes.contains(string)) {
            throw new FileNotFoundException(string);
        }
        Entry entry = this.directory.getEntry(string);
        return this.wrapEntry(entry);
    }

    private Entry wrapEntry(Entry entry) {
        String string = entry.getName();
        if (this.childExcludes.containsKey(string) && entry instanceof DirectoryEntry) {
            return new FilteringDirectoryNode((DirectoryEntry)entry, (Collection<String>)this.childExcludes.get(string));
        }
        return entry;
    }

    @Override
    public ClassID getStorageClsid() {
        return this.directory.getStorageClsid();
    }

    @Override
    public void setStorageClsid(ClassID classID) {
        this.directory.setStorageClsid(classID);
    }

    @Override
    public boolean delete() {
        return this.directory.delete();
    }

    @Override
    public boolean renameTo(String string) {
        return this.directory.renameTo(string);
    }

    @Override
    public String getName() {
        return this.directory.getName();
    }

    @Override
    public DirectoryEntry getParent() {
        return this.directory.getParent();
    }

    @Override
    public boolean isDirectoryEntry() {
        return true;
    }

    @Override
    public boolean isDocumentEntry() {
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FilteringIterator
    implements Iterator<Entry> {
        private Iterator<Entry> parent;
        private Entry next;

        private FilteringIterator() {
            this.parent = FilteringDirectoryNode.this.directory.getEntries();
            this.locateNext();
        }

        private void locateNext() {
            this.next = null;
            while (this.parent.hasNext() && this.next == null) {
                Entry entry = this.parent.next();
                if (FilteringDirectoryNode.this.excludes.contains(entry.getName())) continue;
                this.next = FilteringDirectoryNode.this.wrapEntry(entry);
            }
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public Entry next() {
            Entry entry = this.next;
            this.locateNext();
            return entry;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Remove not supported");
        }
    }
}

