/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.poifs.filesystem;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;

public final class DocumentOutputStream
extends OutputStream {
    private final OutputStream _stream;
    private final int _limit;
    private int _written;

    DocumentOutputStream(OutputStream outputStream, int n) {
        this._stream = outputStream;
        this._limit = n;
        this._written = 0;
    }

    public void write(int n) throws IOException {
        this.limitCheck(1);
        this._stream.write(n);
    }

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.limitCheck(n2);
        this._stream.write(byArray, n, n2);
    }

    public void flush() throws IOException {
        this._stream.flush();
    }

    public void close() {
    }

    void writeFiller(int n, byte by) throws IOException {
        if (n > this._written) {
            byte[] byArray = new byte[n - this._written];
            Arrays.fill(byArray, by);
            this._stream.write(byArray);
        }
    }

    private void limitCheck(int n) throws IOException {
        if (this._written + n > this._limit) {
            throw new IOException("tried to write too much data");
        }
        this._written += n;
    }
}

