/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.poifs.filesystem;

import ai.org.apache.poi.poifs.filesystem.DirectoryNode;
import ai.org.apache.poi.poifs.filesystem.DocumentEntry;
import ai.org.apache.poi.poifs.filesystem.DocumentNode;
import ai.org.apache.poi.poifs.filesystem.NDocumentInputStream;
import ai.org.apache.poi.poifs.filesystem.NPOIFSDocument;
import ai.org.apache.poi.poifs.filesystem.ODocumentInputStream;
import ai.org.apache.poi.poifs.filesystem.POIFSDocument;
import ai.org.apache.poi.util.LittleEndianInput;
import java.io.IOException;
import java.io.InputStream;

public class DocumentInputStream
extends InputStream
implements LittleEndianInput {
    protected static final int EOF = -1;
    protected static final int SIZE_SHORT = 2;
    protected static final int SIZE_INT = 4;
    protected static final int SIZE_LONG = 8;
    private DocumentInputStream delegate;

    protected DocumentInputStream() {
    }

    public DocumentInputStream(DocumentEntry documentEntry) throws IOException {
        if (!(documentEntry instanceof DocumentNode)) {
            throw new IOException("Cannot open internal document storage");
        }
        DocumentNode documentNode = (DocumentNode)documentEntry;
        DirectoryNode directoryNode = (DirectoryNode)documentEntry.getParent();
        if (documentNode.getDocument() != null) {
            this.delegate = new ODocumentInputStream(documentEntry);
        } else if (directoryNode.getFileSystem() != null) {
            this.delegate = new ODocumentInputStream(documentEntry);
        } else if (directoryNode.getNFileSystem() != null) {
            this.delegate = new NDocumentInputStream(documentEntry);
        } else {
            throw new IOException("No FileSystem bound on the parent, can't read contents");
        }
    }

    public DocumentInputStream(POIFSDocument pOIFSDocument) {
        this.delegate = new ODocumentInputStream(pOIFSDocument);
    }

    public DocumentInputStream(NPOIFSDocument nPOIFSDocument) {
        this.delegate = new NDocumentInputStream(nPOIFSDocument);
    }

    public int available() {
        return this.delegate.available();
    }

    public void close() {
        this.delegate.close();
    }

    public void mark(int n) {
        this.delegate.mark(n);
    }

    public boolean markSupported() {
        return true;
    }

    public int read() throws IOException {
        return this.delegate.read();
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        return this.delegate.read(byArray, n, n2);
    }

    public void reset() {
        this.delegate.reset();
    }

    public long skip(long l) throws IOException {
        return this.delegate.skip(l);
    }

    public byte readByte() {
        return this.delegate.readByte();
    }

    public double readDouble() {
        return this.delegate.readDouble();
    }

    public short readShort() {
        return (short)this.readUShort();
    }

    public void readFully(byte[] byArray) {
        this.readFully(byArray, 0, byArray.length);
    }

    public void readFully(byte[] byArray, int n, int n2) {
        this.delegate.readFully(byArray, n, n2);
    }

    public long readLong() {
        return this.delegate.readLong();
    }

    public int readInt() {
        return this.delegate.readInt();
    }

    public int readUShort() {
        return this.delegate.readUShort();
    }

    public int readUByte() {
        return this.delegate.readUByte();
    }
}

