/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.poifs.filesystem;

import ai.org.apache.poi.poifs.filesystem.POIFSDocumentPath;

public class DocumentDescriptor {
    private POIFSDocumentPath path;
    private String name;
    private int hashcode = 0;

    public DocumentDescriptor(POIFSDocumentPath pOIFSDocumentPath, String string) {
        if (pOIFSDocumentPath == null) {
            throw new NullPointerException("path must not be null");
        }
        if (string == null) {
            throw new NullPointerException("name must not be null");
        }
        if (string.length() == 0) {
            throw new IllegalArgumentException("name cannot be empty");
        }
        this.path = pOIFSDocumentPath;
        this.name = string;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object != null && object.getClass() == this.getClass()) {
            if (this == object) {
                bl = true;
            } else {
                DocumentDescriptor documentDescriptor = (DocumentDescriptor)object;
                bl = this.path.equals(documentDescriptor.path) && this.name.equals(documentDescriptor.name);
            }
        }
        return bl;
    }

    public int hashCode() {
        if (this.hashcode == 0) {
            this.hashcode = this.path.hashCode() ^ this.name.hashCode();
        }
        return this.hashcode;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(40 * (this.path.length() + 1));
        for (int i = 0; i < this.path.length(); ++i) {
            stringBuffer.append(this.path.getComponent(i)).append("/");
        }
        stringBuffer.append(this.name);
        return stringBuffer.toString();
    }
}

