/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.poifs.eventfilesystem;

import ai.org.apache.poi.poifs.eventfilesystem.POIFSReaderEvent;
import ai.org.apache.poi.poifs.eventfilesystem.POIFSReaderListener;
import ai.org.apache.poi.poifs.eventfilesystem.POIFSReaderRegistry;
import ai.org.apache.poi.poifs.filesystem.DocumentInputStream;
import ai.org.apache.poi.poifs.filesystem.POIFSDocument;
import ai.org.apache.poi.poifs.filesystem.POIFSDocumentPath;
import ai.org.apache.poi.poifs.property.DirectoryProperty;
import ai.org.apache.poi.poifs.property.Property;
import ai.org.apache.poi.poifs.property.PropertyTable;
import ai.org.apache.poi.poifs.storage.BlockAllocationTableReader;
import ai.org.apache.poi.poifs.storage.BlockList;
import ai.org.apache.poi.poifs.storage.HeaderBlock;
import ai.org.apache.poi.poifs.storage.RawDataBlockList;
import ai.org.apache.poi.poifs.storage.SmallBlockTableReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;

public class POIFSReader {
    private POIFSReaderRegistry registry = new POIFSReaderRegistry();
    private boolean registryClosed = false;

    public void read(InputStream inputStream) throws IOException {
        this.registryClosed = true;
        HeaderBlock headerBlock = new HeaderBlock(inputStream);
        RawDataBlockList rawDataBlockList = new RawDataBlockList(inputStream, headerBlock.getBigBlockSize());
        new BlockAllocationTableReader(headerBlock.getBigBlockSize(), headerBlock.getBATCount(), headerBlock.getBATArray(), headerBlock.getXBATCount(), headerBlock.getXBATIndex(), rawDataBlockList);
        PropertyTable propertyTable = new PropertyTable(headerBlock, rawDataBlockList);
        this.processProperties(SmallBlockTableReader.getSmallDocumentBlocks(headerBlock.getBigBlockSize(), rawDataBlockList, propertyTable.getRoot(), headerBlock.getSBATStart()), rawDataBlockList, propertyTable.getRoot().getChildren(), new POIFSDocumentPath());
    }

    public void registerListener(POIFSReaderListener pOIFSReaderListener) {
        if (pOIFSReaderListener == null) {
            throw new NullPointerException();
        }
        if (this.registryClosed) {
            throw new IllegalStateException();
        }
        this.registry.registerListener(pOIFSReaderListener);
    }

    public void registerListener(POIFSReaderListener pOIFSReaderListener, String string) {
        this.registerListener(pOIFSReaderListener, null, string);
    }

    public void registerListener(POIFSReaderListener pOIFSReaderListener, POIFSDocumentPath pOIFSDocumentPath, String string) {
        if (pOIFSReaderListener == null || string == null || string.length() == 0) {
            throw new NullPointerException();
        }
        if (this.registryClosed) {
            throw new IllegalStateException();
        }
        this.registry.registerListener(pOIFSReaderListener, pOIFSDocumentPath == null ? new POIFSDocumentPath() : pOIFSDocumentPath, string);
    }

    public static void main(String[] stringArray) throws IOException {
        if (stringArray.length == 0) {
            System.err.println("at least one argument required: input filename(s)");
            System.exit(1);
        }
        for (int i = 0; i < stringArray.length; ++i) {
            POIFSReader pOIFSReader = new POIFSReader();
            SampleListener sampleListener = new SampleListener();
            pOIFSReader.registerListener(sampleListener);
            System.out.println("reading " + stringArray[i]);
            FileInputStream fileInputStream = new FileInputStream(stringArray[i]);
            pOIFSReader.read(fileInputStream);
            fileInputStream.close();
        }
    }

    private void processProperties(BlockList blockList, BlockList blockList2, Iterator iterator, POIFSDocumentPath pOIFSDocumentPath) throws IOException {
        while (iterator.hasNext()) {
            Property property = (Property)iterator.next();
            String string = property.getName();
            if (property.isDirectory()) {
                POIFSDocumentPath pOIFSDocumentPath2 = new POIFSDocumentPath(pOIFSDocumentPath, new String[]{string});
                this.processProperties(blockList, blockList2, ((DirectoryProperty)property).getChildren(), pOIFSDocumentPath2);
                continue;
            }
            int n = property.getStartBlock();
            Iterator iterator2 = this.registry.getListeners(pOIFSDocumentPath, string);
            if (iterator2.hasNext()) {
                int n2 = property.getSize();
                POIFSDocument pOIFSDocument = null;
                pOIFSDocument = property.shouldUseSmallBlocks() ? new POIFSDocument(string, blockList.fetchBlocks(n, -1), n2) : new POIFSDocument(string, blockList2.fetchBlocks(n, -1), n2);
                while (iterator2.hasNext()) {
                    POIFSReaderListener pOIFSReaderListener = (POIFSReaderListener)iterator2.next();
                    pOIFSReaderListener.processPOIFSReaderEvent(new POIFSReaderEvent(new DocumentInputStream(pOIFSDocument), pOIFSDocumentPath, string));
                }
                continue;
            }
            if (property.shouldUseSmallBlocks()) {
                blockList.fetchBlocks(n, -1);
                continue;
            }
            blockList2.fetchBlocks(n, -1);
        }
    }

    private static class SampleListener
    implements POIFSReaderListener {
        SampleListener() {
        }

        public void processPOIFSReaderEvent(POIFSReaderEvent pOIFSReaderEvent) {
            DocumentInputStream documentInputStream = pOIFSReaderEvent.getStream();
            POIFSDocumentPath pOIFSDocumentPath = pOIFSReaderEvent.getPath();
            String string = pOIFSReaderEvent.getName();
            try {
                byte[] byArray = new byte[documentInputStream.available()];
                documentInputStream.read(byArray);
                int n = pOIFSDocumentPath.length();
                for (int i = 0; i < n; ++i) {
                    System.out.print("/" + pOIFSDocumentPath.getComponent(i));
                }
                System.out.println("/" + string + ": " + byArray.length + " bytes read");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

