/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.poifs.dev;

import ai.org.apache.poi.poifs.common.POIFSBigBlockSize;
import ai.org.apache.poi.poifs.property.PropertyTable;
import ai.org.apache.poi.poifs.storage.BlockAllocationTableReader;
import ai.org.apache.poi.poifs.storage.BlockList;
import ai.org.apache.poi.poifs.storage.HeaderBlock;
import ai.org.apache.poi.poifs.storage.ListManagedBlock;
import ai.org.apache.poi.poifs.storage.RawDataBlockList;
import ai.org.apache.poi.poifs.storage.SmallBlockTableReader;
import ai.org.apache.poi.util.HexDump;
import ai.org.apache.poi.util.IntList;
import java.io.FileInputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class POIFSHeaderDumper {
    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length == 0) {
            System.err.println("Must specify at least one file to view");
            System.exit(1);
        }
        for (int i = 0; i < stringArray.length; ++i) {
            POIFSHeaderDumper.viewFile(stringArray[i]);
        }
    }

    public static void viewFile(String string) throws Exception {
        FileInputStream fileInputStream = new FileInputStream(string);
        HeaderBlock headerBlock = new HeaderBlock(fileInputStream);
        POIFSHeaderDumper.displayHeader(headerBlock);
        POIFSBigBlockSize pOIFSBigBlockSize = headerBlock.getBigBlockSize();
        RawDataBlockList rawDataBlockList = new RawDataBlockList(fileInputStream, pOIFSBigBlockSize);
        POIFSHeaderDumper.displayRawBlocksSummary(rawDataBlockList);
        BlockAllocationTableReader blockAllocationTableReader = new BlockAllocationTableReader(headerBlock.getBigBlockSize(), headerBlock.getBATCount(), headerBlock.getBATArray(), headerBlock.getXBATCount(), headerBlock.getXBATIndex(), rawDataBlockList);
        POIFSHeaderDumper.displayBATReader(blockAllocationTableReader);
        PropertyTable propertyTable = new PropertyTable(headerBlock, rawDataBlockList);
        BlockList blockList = SmallBlockTableReader.getSmallDocumentBlocks(pOIFSBigBlockSize, rawDataBlockList, propertyTable.getRoot(), headerBlock.getSBATStart());
    }

    public static void displayHeader(HeaderBlock headerBlock) throws Exception {
        System.out.println("Header Details:");
        System.out.println(" Block size: " + headerBlock.getBigBlockSize().getBigBlockSize());
        System.out.println(" BAT (FAT) header blocks: " + headerBlock.getBATArray().length);
        System.out.println(" BAT (FAT) block count: " + headerBlock.getBATCount());
        System.out.println(" XBAT (FAT) block count: " + headerBlock.getXBATCount());
        System.out.println(" XBAT (FAT) block 1 at: " + headerBlock.getXBATIndex());
        System.out.println(" SBAT (MiniFAT) block count: " + headerBlock.getSBATCount());
        System.out.println(" SBAT (MiniFAT) block 1 at: " + headerBlock.getSBATStart());
        System.out.println(" Property table at: " + headerBlock.getPropertyStart());
        System.out.println("");
    }

    public static void displayRawBlocksSummary(RawDataBlockList rawDataBlockList) throws Exception {
        System.out.println("Raw Blocks Details:");
        System.out.println(" Number of blocks: " + rawDataBlockList.blockCount());
        Method method = rawDataBlockList.getClass().getSuperclass().getDeclaredMethod("get", Integer.TYPE);
        method.setAccessible(true);
        for (int i = 0; i < Math.min(16, rawDataBlockList.blockCount()); ++i) {
            ListManagedBlock listManagedBlock = (ListManagedBlock)method.invoke((Object)rawDataBlockList, i);
            byte[] byArray = new byte[Math.min(48, listManagedBlock.getData().length)];
            System.arraycopy(listManagedBlock.getData(), 0, byArray, 0, byArray.length);
            System.out.println(" Block #" + i + ":");
            System.out.println(HexDump.dump(byArray, 0L, 0));
        }
        System.out.println("");
    }

    public static void displayBATReader(BlockAllocationTableReader blockAllocationTableReader) throws Exception {
        System.out.println("Sectors, as referenced from the FAT:");
        Field field = blockAllocationTableReader.getClass().getDeclaredField("_entries");
        field.setAccessible(true);
        IntList intList = (IntList)field.get(blockAllocationTableReader);
        for (int i = 0; i < intList.size(); ++i) {
            int n = intList.get(i);
            String string = Integer.toString(n);
            if (n == -2) {
                string = "End Of Chain";
            } else if (n == -4) {
                string = "DI Fat Block";
            } else if (n == -3) {
                string = "Normal Fat Block";
            } else if (n == -1) {
                string = "Block Not Used (Free)";
            }
            System.out.println("  Block  # " + i + " -> " + string);
        }
        System.out.println("");
    }
}

