/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.poifs.crypt.standard;

import ai.org.apache.poi.EncryptedDocumentException;
import ai.org.apache.poi.poifs.crypt.CryptoFunctions;
import ai.org.apache.poi.poifs.crypt.DataSpaceMapUtils;
import ai.org.apache.poi.poifs.crypt.EncryptionInfo;
import ai.org.apache.poi.poifs.crypt.Encryptor;
import ai.org.apache.poi.poifs.crypt.standard.EncryptionRecord;
import ai.org.apache.poi.poifs.crypt.standard.StandardDecryptor;
import ai.org.apache.poi.poifs.crypt.standard.StandardEncryptionHeader;
import ai.org.apache.poi.poifs.crypt.standard.StandardEncryptionInfoBuilder;
import ai.org.apache.poi.poifs.crypt.standard.StandardEncryptionVerifier;
import ai.org.apache.poi.poifs.filesystem.DirectoryNode;
import ai.org.apache.poi.poifs.filesystem.POIFSWriterEvent;
import ai.org.apache.poi.poifs.filesystem.POIFSWriterListener;
import ai.org.apache.poi.util.IOUtils;
import ai.org.apache.poi.util.LittleEndianByteArrayOutputStream;
import ai.org.apache.poi.util.LittleEndianOutputStream;
import ai.org.apache.poi.util.TempFile;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.Random;
import javax.crypto.Cipher;
import javax.crypto.CipherOutputStream;
import javax.crypto.SecretKey;

public class StandardEncryptor
extends Encryptor {
    private final StandardEncryptionInfoBuilder builder;

    protected StandardEncryptor(StandardEncryptionInfoBuilder standardEncryptionInfoBuilder) {
        this.builder = standardEncryptionInfoBuilder;
    }

    public void confirmPassword(String string) {
        SecureRandom secureRandom = new SecureRandom();
        byte[] byArray = new byte[16];
        byte[] byArray2 = new byte[16];
        ((Random)secureRandom).nextBytes(byArray);
        ((Random)secureRandom).nextBytes(byArray2);
        this.confirmPassword(string, null, null, byArray, byArray2, null);
    }

    public void confirmPassword(String string, byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, byte[] byArray5) {
        StandardEncryptionVerifier standardEncryptionVerifier = this.builder.getVerifier();
        standardEncryptionVerifier.setSalt(byArray4);
        SecretKey secretKey = StandardDecryptor.generateSecretKey(string, standardEncryptionVerifier, this.getKeySizeInBytes());
        this.setSecretKey(secretKey);
        Cipher cipher = this.getCipher(secretKey, null);
        try {
            byte[] byArray6 = cipher.doFinal(byArray3);
            MessageDigest messageDigest = CryptoFunctions.getMessageDigest(standardEncryptionVerifier.getHashAlgorithm());
            byte[] byArray7 = messageDigest.digest(byArray3);
            int n = standardEncryptionVerifier.getCipherAlgorithm().encryptedVerifierHashLength;
            byte[] byArray8 = cipher.doFinal(StandardDecryptor.truncateOrPad(byArray7, n));
            standardEncryptionVerifier.setEncryptedVerifier(byArray6);
            standardEncryptionVerifier.setEncryptedVerifierHash(byArray8);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new EncryptedDocumentException("Password confirmation failed", generalSecurityException);
        }
    }

    private Cipher getCipher(SecretKey secretKey, String string) {
        StandardEncryptionVerifier standardEncryptionVerifier = this.builder.getVerifier();
        return CryptoFunctions.getCipher(secretKey, standardEncryptionVerifier.getCipherAlgorithm(), standardEncryptionVerifier.getChainingMode(), null, 1, string);
    }

    public OutputStream getDataStream(DirectoryNode directoryNode) throws IOException, GeneralSecurityException {
        this.createEncryptionInfoEntry(directoryNode);
        DataSpaceMapUtils.addDefaultDataSpace(directoryNode);
        StandardCipherOutputStream standardCipherOutputStream = new StandardCipherOutputStream(directoryNode);
        return standardCipherOutputStream;
    }

    protected int getKeySizeInBytes() {
        return this.builder.getHeader().getKeySize() / 8;
    }

    protected void createEncryptionInfoEntry(DirectoryNode directoryNode) throws IOException {
        final EncryptionInfo encryptionInfo = this.builder.getEncryptionInfo();
        final StandardEncryptionHeader standardEncryptionHeader = this.builder.getHeader();
        final StandardEncryptionVerifier standardEncryptionVerifier = this.builder.getVerifier();
        EncryptionRecord encryptionRecord = new EncryptionRecord(){

            public void write(LittleEndianByteArrayOutputStream littleEndianByteArrayOutputStream) {
                littleEndianByteArrayOutputStream.writeShort(encryptionInfo.getVersionMajor());
                littleEndianByteArrayOutputStream.writeShort(encryptionInfo.getVersionMinor());
                littleEndianByteArrayOutputStream.writeInt(encryptionInfo.getEncryptionFlags());
                standardEncryptionHeader.write(littleEndianByteArrayOutputStream);
                standardEncryptionVerifier.write(littleEndianByteArrayOutputStream);
            }
        };
        DataSpaceMapUtils.createEncryptionEntry(directoryNode, "EncryptionInfo", encryptionRecord);
    }

    protected class StandardCipherOutputStream
    extends FilterOutputStream
    implements POIFSWriterListener {
        protected long countBytes;
        protected final File fileOut;
        protected final DirectoryNode dir;

        protected StandardCipherOutputStream(DirectoryNode directoryNode) throws IOException {
            super(null);
            this.dir = directoryNode;
            this.fileOut = TempFile.createTempFile("encrypted_package", "crypt");
            FileOutputStream fileOutputStream = new FileOutputStream(this.fileOut);
            CipherOutputStream cipherOutputStream = new CipherOutputStream(fileOutputStream, StandardEncryptor.this.getCipher(StandardEncryptor.this.getSecretKey(), "PKCS5Padding"));
            this.out = cipherOutputStream;
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            this.out.write(byArray, n, n2);
            this.countBytes += (long)n2;
        }

        public void write(int n) throws IOException {
            this.out.write(n);
            ++this.countBytes;
        }

        public void close() throws IOException {
            super.close();
            this.writeToPOIFS();
        }

        void writeToPOIFS() throws IOException {
            int n = (int)(this.fileOut.length() + 8L);
            this.dir.createDocument("EncryptedPackage", n, this);
        }

        public void processPOIFSWriterEvent(POIFSWriterEvent pOIFSWriterEvent) {
            try {
                LittleEndianOutputStream littleEndianOutputStream = new LittleEndianOutputStream(pOIFSWriterEvent.getStream());
                littleEndianOutputStream.writeLong(this.countBytes);
                FileInputStream fileInputStream = new FileInputStream(this.fileOut);
                IOUtils.copy(fileInputStream, littleEndianOutputStream);
                fileInputStream.close();
                this.fileOut.delete();
                littleEndianOutputStream.close();
            }
            catch (IOException iOException) {
                throw new EncryptedDocumentException(iOException);
            }
        }
    }
}

