/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.poifs.crypt.standard;

import ai.org.apache.poi.poifs.crypt.ChainingMode;
import ai.org.apache.poi.poifs.crypt.CipherAlgorithm;
import ai.org.apache.poi.poifs.crypt.CipherProvider;
import ai.org.apache.poi.poifs.crypt.CryptoFunctions;
import ai.org.apache.poi.poifs.crypt.EncryptionHeader;
import ai.org.apache.poi.poifs.crypt.HashAlgorithm;
import ai.org.apache.poi.poifs.crypt.standard.EncryptionRecord;
import ai.org.apache.poi.poifs.filesystem.DocumentInputStream;
import ai.org.apache.poi.util.BitField;
import ai.org.apache.poi.util.LittleEndianByteArrayOutputStream;
import ai.org.apache.poi.util.LittleEndianOutput;
import java.io.IOException;

public class StandardEncryptionHeader
extends EncryptionHeader
implements EncryptionRecord {
    private static BitField flagsCryptoAPI = new BitField(4);
    private static BitField flagsDocProps = new BitField(8);
    private static BitField flagsExternal = new BitField(16);
    private static BitField flagsAES = new BitField(32);

    protected StandardEncryptionHeader(DocumentInputStream documentInputStream) throws IOException {
        this.setFlags(documentInputStream.readInt());
        this.setSizeExtra(documentInputStream.readInt());
        this.setCipherAlgorithm(CipherAlgorithm.fromEcmaId(documentInputStream.readInt()));
        this.setHashAlgorithm(HashAlgorithm.fromEcmaId(documentInputStream.readInt()));
        this.setKeySize(documentInputStream.readInt());
        this.setBlockSize(this.getKeySize());
        this.setCipherProvider(CipherProvider.fromEcmaId(documentInputStream.readInt()));
        documentInputStream.readLong();
        documentInputStream.mark(5);
        int n = documentInputStream.readInt();
        documentInputStream.reset();
        if (n == 16) {
            this.setCspName("");
        } else {
            char c;
            StringBuilder stringBuilder = new StringBuilder();
            while ((c = (char)documentInputStream.readShort()) != '\u0000') {
                stringBuilder.append(c);
            }
            this.setCspName(stringBuilder.toString());
        }
        this.setChainingMode(ChainingMode.ecb);
        this.setKeySalt(null);
    }

    protected StandardEncryptionHeader(CipherAlgorithm cipherAlgorithm, HashAlgorithm hashAlgorithm, int n, int n2, ChainingMode chainingMode) {
        this.setCipherAlgorithm(cipherAlgorithm);
        this.setHashAlgorithm(hashAlgorithm);
        this.setKeySize(n);
        this.setBlockSize(n2);
        this.setCipherProvider(cipherAlgorithm.provider);
        this.setFlags(flagsCryptoAPI.setBoolean(0, true) | flagsAES.setBoolean(0, cipherAlgorithm.provider == CipherProvider.aes));
    }

    public void write(LittleEndianByteArrayOutputStream littleEndianByteArrayOutputStream) {
        int n = littleEndianByteArrayOutputStream.getWriteIndex();
        LittleEndianOutput littleEndianOutput = littleEndianByteArrayOutputStream.createDelayedOutput(4);
        littleEndianByteArrayOutputStream.writeInt(this.getFlags());
        littleEndianByteArrayOutputStream.writeInt(0);
        littleEndianByteArrayOutputStream.writeInt(this.getCipherAlgorithm().ecmaId);
        littleEndianByteArrayOutputStream.writeInt(this.getHashAlgorithmEx().ecmaId);
        littleEndianByteArrayOutputStream.writeInt(this.getKeySize());
        littleEndianByteArrayOutputStream.writeInt(this.getCipherProvider().ecmaId);
        littleEndianByteArrayOutputStream.writeInt(0);
        littleEndianByteArrayOutputStream.writeInt(0);
        if (this.getCspName() != null) {
            littleEndianByteArrayOutputStream.write(CryptoFunctions.getUtf16LeString(this.getCspName()));
            littleEndianByteArrayOutputStream.writeShort(0);
        }
        int n2 = littleEndianByteArrayOutputStream.getWriteIndex() - n - 4;
        littleEndianOutput.writeInt(n2);
    }
}

