/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.poifs.crypt.standard;

import ai.org.apache.poi.EncryptedDocumentException;
import ai.org.apache.poi.poifs.crypt.ChainingMode;
import ai.org.apache.poi.poifs.crypt.CryptoFunctions;
import ai.org.apache.poi.poifs.crypt.Decryptor;
import ai.org.apache.poi.poifs.crypt.EncryptionHeader;
import ai.org.apache.poi.poifs.crypt.EncryptionInfo;
import ai.org.apache.poi.poifs.crypt.EncryptionVerifier;
import ai.org.apache.poi.poifs.crypt.HashAlgorithm;
import ai.org.apache.poi.poifs.filesystem.DirectoryNode;
import ai.org.apache.poi.poifs.filesystem.DocumentInputStream;
import ai.org.apache.poi.util.BoundedInputStream;
import ai.org.apache.poi.util.LittleEndian;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public class StandardDecryptor
extends Decryptor {
    private long _length = -1L;

    protected StandardDecryptor(EncryptionInfo encryptionInfo) {
        super(encryptionInfo);
    }

    public boolean verifyPassword(String string) {
        EncryptionVerifier encryptionVerifier = this.info.getVerifier();
        SecretKey secretKey = StandardDecryptor.generateSecretKey(string, encryptionVerifier, this.getKeySizeInBytes());
        Cipher cipher = this.getCipher(secretKey);
        try {
            byte[] byArray = encryptionVerifier.getEncryptedVerifier();
            byte[] byArray2 = cipher.doFinal(byArray);
            this.setVerifier(byArray2);
            MessageDigest messageDigest = CryptoFunctions.getMessageDigest(encryptionVerifier.getHashAlgorithm());
            byte[] byArray3 = messageDigest.digest(byArray2);
            byte[] byArray4 = encryptionVerifier.getEncryptedVerifierHash();
            byte[] byArray5 = cipher.doFinal(byArray4);
            byte[] byArray6 = StandardDecryptor.truncateOrPad(byArray5, byArray3.length);
            if (Arrays.equals(byArray3, byArray6)) {
                this.setSecretKey(secretKey);
                return true;
            }
            return false;
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new EncryptedDocumentException(generalSecurityException);
        }
    }

    protected static SecretKey generateSecretKey(String string, EncryptionVerifier encryptionVerifier, int n) {
        HashAlgorithm hashAlgorithm = encryptionVerifier.getHashAlgorithm();
        byte[] byArray = CryptoFunctions.hashPassword(string, hashAlgorithm, encryptionVerifier.getSalt(), encryptionVerifier.getSpinCount());
        byte[] byArray2 = new byte[4];
        LittleEndian.putInt(byArray2, 0, 0);
        byte[] byArray3 = CryptoFunctions.generateKey(byArray, hashAlgorithm, byArray2, hashAlgorithm.hashSize);
        byte[] byArray4 = StandardDecryptor.fillAndXor(byArray3, (byte)54);
        byte[] byArray5 = StandardDecryptor.fillAndXor(byArray3, (byte)92);
        byte[] byArray6 = new byte[byArray4.length + byArray5.length];
        System.arraycopy(byArray4, 0, byArray6, 0, byArray4.length);
        System.arraycopy(byArray5, 0, byArray6, byArray4.length, byArray5.length);
        byte[] byArray7 = StandardDecryptor.truncateOrPad(byArray6, n);
        SecretKeySpec secretKeySpec = new SecretKeySpec(byArray7, encryptionVerifier.getCipherAlgorithm().jceId);
        return secretKeySpec;
    }

    protected static byte[] fillAndXor(byte[] byArray, byte by) {
        byte[] byArray2 = new byte[64];
        Arrays.fill(byArray2, by);
        for (int i = 0; i < byArray.length; ++i) {
            byArray2[i] = (byte)(byArray2[i] ^ byArray[i]);
        }
        MessageDigest messageDigest = CryptoFunctions.getMessageDigest(HashAlgorithm.sha1);
        return messageDigest.digest(byArray2);
    }

    protected static byte[] truncateOrPad(byte[] byArray, int n) {
        byte[] byArray2 = new byte[n];
        System.arraycopy(byArray, 0, byArray2, 0, Math.min(n, byArray.length));
        if (n > byArray.length) {
            for (int i = byArray.length; i < n; ++i) {
                byArray2[i] = 0;
            }
        }
        return byArray2;
    }

    private Cipher getCipher(SecretKey secretKey) {
        EncryptionHeader encryptionHeader = this.info.getHeader();
        ChainingMode chainingMode = encryptionHeader.getChainingMode();
        assert (chainingMode == ChainingMode.ecb);
        return CryptoFunctions.getCipher(secretKey, encryptionHeader.getCipherAlgorithm(), chainingMode, null, 2);
    }

    public InputStream getDataStream(DirectoryNode directoryNode) throws IOException {
        DocumentInputStream documentInputStream = directoryNode.createDocumentInputStream("EncryptedPackage");
        this._length = documentInputStream.readLong();
        int n = this.info.getHeader().getCipherAlgorithm().blockSize;
        long l = (this._length / (long)n + 1L) * (long)n;
        Cipher cipher = this.getCipher(this.getSecretKey());
        BoundedInputStream boundedInputStream = new BoundedInputStream(documentInputStream, l);
        return new BoundedInputStream(new CipherInputStream(boundedInputStream, cipher), this._length);
    }

    public long getLength() {
        if (this._length == -1L) {
            throw new IllegalStateException("Decryptor.getDataStream() was not called");
        }
        return this._length;
    }

    protected int getKeySizeInBytes() {
        return this.info.getHeader().getKeySize() / 8;
    }
}

